/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.barehttp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wildfly.elytron.web.barehttp.BareHttpClient;

public class BareHttpResponse {
    private final int statusCode;
    private final Map<String, List<String>> headers;
    private final String messageBody;
    private final int contentLength;
    private final boolean chunkedEncoding;

    BareHttpResponse(Builder builder) {
        this.statusCode = builder.statusCode;
        this.headers = builder.headers;
        this.contentLength = builder.contentLength;
        this.chunkedEncoding = builder.chunkedEncoding;
        this.messageBody = builder.messageBody;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getMessageBody() {
        return this.messageBody;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public boolean isChunkedEncoding() {
        return this.chunkedEncoding;
    }

    static Builder builder(BareHttpClient.Target target, String statusLine) {
        if (!statusLine.startsWith("HTTP/1.1")) {
            throw new IllegalStateException("Not a HTTP/1.1 Response");
        }
        int statusCode = Integer.parseInt(statusLine.substring(9, 12));
        return new Builder(target, statusCode);
    }

    static class Builder {
        private final BareHttpClient.Target target;
        final int statusCode;
        final Map<String, List<String>> headers = new HashMap<String, List<String>>();
        String messageBody;
        boolean closeConnection = true;
        int contentLength = -1;
        boolean chunkedEncoding = false;

        Builder(BareHttpClient.Target target, int statusCode) {
            this.target = target;
            this.statusCode = statusCode;
        }

        boolean isChunkedEncoding() {
            return this.chunkedEncoding;
        }

        int getContentLength() {
            return this.contentLength;
        }

        Builder processHeader(String header) {
            List<Object> values;
            int colonPos = header.indexOf(58);
            String headerName = header.substring(0, colonPos);
            String headerValue = header.substring(colonPos + 2);
            if (this.headers.containsKey(headerName)) {
                values = this.headers.get(headerName);
            } else {
                values = new ArrayList();
                this.headers.put(headerName, values);
            }
            values.add(headerValue);
            switch (headerName) {
                case "Connection": {
                    if (!"keep-alive".equals(headerValue)) break;
                    this.closeConnection = false;
                    break;
                }
                case "Content-Length": {
                    this.contentLength = Integer.parseInt(headerValue);
                    this.chunkedEncoding = false;
                    break;
                }
                case "Set-Cookie": {
                    int equalsPos = headerValue.indexOf(61);
                    String cookieName = headerValue.substring(0, equalsPos);
                    int semiPos = headerValue.indexOf(59);
                    String cookieValue = semiPos < 0 ? headerValue.substring(equalsPos + 1) : headerValue.substring(equalsPos + 1, semiPos);
                    this.target.setCookie(cookieName, cookieValue);
                    break;
                }
                case "Transfer-Encoding": {
                    if (!"chunked".equals(headerValue)) break;
                    this.contentLength = -1;
                    this.chunkedEncoding = true;
                }
            }
            return this;
        }

        Builder setMessageBody(String messageBody) {
            this.messageBody = messageBody;
            return this;
        }

        public BareHttpResponse build() throws IOException {
            if (this.closeConnection) {
                this.target.close();
            }
            return new BareHttpResponse(this);
        }
    }
}

