package org.wildfly.security.keystore;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import java.security.KeyStoreException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.jboss.logging.Logger;
import java.security.InvalidKeyException;
import java.lang.Exception;
import java.security.UnrecoverableKeyException;
import org.jboss.logging.BasicLogger;
import java.io.EOFException;
import java.lang.Throwable;
import java.lang.Class;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-08-17T11:36:11-0400")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String invalidKeyStoreEntryPassword$str() {
        return "ELY02001: Invalid key store entry password for alias \"%s\"";
    }
    @Override
    public final UnrecoverableKeyException invalidKeyStoreEntryPassword(final String alias) {
        final UnrecoverableKeyException result = new UnrecoverableKeyException(String.format(getLoggingLocale(), invalidKeyStoreEntryPassword$str(), alias));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String invalidKeyStoreEntryType$str() {
        return "ELY02002: Invalid key store entry type for alias \"%s\" (expected %s, got %s)";
    }
    @Override
    public final KeyStoreException invalidKeyStoreEntryType(final String alias, final Class<?> expectedClass, final Class<?> actualClass) {
        final KeyStoreException result = new KeyStoreException(String.format(getLoggingLocale(), invalidKeyStoreEntryType$str(), alias, expectedClass, actualClass));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String keyCannotBeProtected$str() {
        return "ELY02003: Key store key for alias \"%s\" cannot be protected";
    }
    @Override
    public final KeyStoreException keyCannotBeProtected(final String alias) {
        final KeyStoreException result = new KeyStoreException(String.format(getLoggingLocale(), keyCannotBeProtected$str(), alias));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String keyStoreFailedToTranslate$str() {
        return "ELY02004: Key store failed to translate password for alias \"%s\"";
    }
    @Override
    public final IOException keyStoreFailedToTranslate(final String alias, final Throwable cause) {
        final IOException result = new IOException(String.format(getLoggingLocale(), keyStoreFailedToTranslate$str(), alias), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noAlgorithmForPassword$str() {
        return "ELY02005: Key store failed to identify a suitable algorithm for alias \"%s\"";
    }
    @Override
    public final NoSuchAlgorithmException noAlgorithmForPassword(final String alias) {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(getLoggingLocale(), noAlgorithmForPassword$str(), alias));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedWhitespaceInPasswordFile$str() {
        return "ELY02006: Unexpected whitespace in password file";
    }
    @Override
    public final IOException unexpectedWhitespaceInPasswordFile() {
        final IOException result = new IOException(String.format(getLoggingLocale(), unexpectedWhitespaceInPasswordFile$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedEof$str() {
        return "ELY02007: Unexpected end of file";
    }
    @Override
    public final EOFException unexpectedEof() {
        final EOFException result = new EOFException(String.format(getLoggingLocale(), unexpectedEof$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String reversibleLoadNotPossible$str() {
        return "ELY02008: A reversible load is not possible until the KeyStore has first been initialized";
    }
    @Override
    public final IllegalStateException reversibleLoadNotPossible() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), reversibleLoadNotPossible$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCreateKeyStore$str() {
        return "ELY02009: Unable to create a new KeyStore instance";
    }
    @Override
    public final IOException unableToCreateKeyStore(final Exception cause) {
        final IOException result = new IOException(String.format(getLoggingLocale(), unableToCreateKeyStore$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String emptyFilter$str() {
        return "ELY02012: An empty alias filter was supplied";
    }
    @Override
    public final IllegalArgumentException emptyFilter() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), emptyFilter$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingPlusMinusAt$str() {
        return "ELY02013: Filter is missing '+' or '-' at offset %d";
    }
    @Override
    public final IllegalArgumentException missingPlusMinusAt(final long position) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), missingPlusMinusAt$str(), position));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFirstWord$str() {
        return "ELY02014: Invalid first word '%s', must be one of ALL/NONE";
    }
    @Override
    public final IllegalArgumentException invalidFirstWord(final String firstWord) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidFirstWord$str(), firstWord));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToObtainDirContext$str() {
        return "ELY02015: Failed to obtain DirContext";
    }
    @Override
    public final IllegalStateException failedToObtainDirContext(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), failedToObtainDirContext$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToReturnDirContext$str() {
        return "ELY02016: Failed to return DirContext";
    }
    @Override
    public final IllegalStateException failedToReturnDirContext(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), failedToReturnDirContext$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapKeyStoreFailedToObtainAlias$str() {
        return "ELY02017: LdapKeyStore failed to obtain alias [%s]";
    }
    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainAlias(final String alias, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), ldapKeyStoreFailedToObtainAlias$str(), alias), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapKeyStoreFailedToObtainCertificate$str() {
        return "ELY02018: LdapKeyStore failed to obtain certificate [%s]";
    }
    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainCertificate(final String alias, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), ldapKeyStoreFailedToObtainCertificate$str(), alias), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapKeyStoreFailedToObtainCertificateChain$str() {
        return "ELY02019: LdapKeyStore failed to obtain certificate chain [%s]";
    }
    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainCertificateChain(final String alias, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), ldapKeyStoreFailedToObtainCertificateChain$str(), alias), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapKeyStoreFailedToObtainKey$str() {
        return "ELY02020: LdapKeyStore failed to recover key of alias [%s]";
    }
    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainKey(final String alias, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), ldapKeyStoreFailedToObtainKey$str(), alias), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapKeyStoreFailedToObtainAliasByCertificate$str() {
        return "ELY02021: LdapKeyStore failed to obtain alias by certificate";
    }
    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainAliasByCertificate(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), ldapKeyStoreFailedToObtainAliasByCertificate$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapKeyStoreFailedToRecoverKey$str() {
        return "ELY02022: LdapKeyStore failed to recover key of alias [%s]";
    }
    @Override
    public final UnrecoverableKeyException ldapKeyStoreFailedToRecoverKey(final String alias, final Throwable cause) {
        final UnrecoverableKeyException result = new UnrecoverableKeyException(String.format(getLoggingLocale(), ldapKeyStoreFailedToRecoverKey$str(), alias));
        result.initCause(cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapKeyStoreFailedToObtainCreationDate$str() {
        return "ELY02023: LdapKeyStore failed to obtain creation date of alias [%s]";
    }
    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainCreationDate(final String alias, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), ldapKeyStoreFailedToObtainCreationDate$str(), alias), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String creationNotConfigured$str() {
        return "ELY02024: Alias [%s] does not exist in LdapKeyStore and not configured for creation";
    }
    @Override
    public final KeyStoreException creationNotConfigured(final String alias) {
        final KeyStoreException result = new KeyStoreException(String.format(getLoggingLocale(), creationNotConfigured$str(), alias));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapKeyStoreFailedToStore$str() {
        return "ELY02025: LdapKeyStore failed store alias [%s]";
    }
    @Override
    public final KeyStoreException ldapKeyStoreFailedToStore(final String alias, final Throwable cause) {
        final KeyStoreException result = new KeyStoreException(String.format(getLoggingLocale(), ldapKeyStoreFailedToStore$str(), alias), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapKeyStoreFailedToSerializeCertificate$str() {
        return "ELY02026: LdapKeyStore failed to serialize certificate of alias [%s]";
    }
    @Override
    public final KeyStoreException ldapKeyStoreFailedToSerializeCertificate(final String alias, final Throwable cause) {
        final KeyStoreException result = new KeyStoreException(String.format(getLoggingLocale(), ldapKeyStoreFailedToSerializeCertificate$str(), alias), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapKeyStoreFailedToSerializeKey$str() {
        return "ELY02027: LdapKeyStore failed to protect (pack into keystore) key of alias [%s]";
    }
    @Override
    public final KeyStoreException ldapKeyStoreFailedToSerializeKey(final String alias, final Throwable cause) {
        final KeyStoreException result = new KeyStoreException(String.format(getLoggingLocale(), ldapKeyStoreFailedToSerializeKey$str(), alias), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapKeyStoreFailedToDelete$str() {
        return "ELY02028: LdapKeyStore failed to delete alias [%s]";
    }
    @Override
    public final KeyStoreException ldapKeyStoreFailedToDelete(final String alias, final Throwable cause) {
        final KeyStoreException result = new KeyStoreException(String.format(getLoggingLocale(), ldapKeyStoreFailedToDelete$str(), alias), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapKeyStoreFailedToDeleteNonExisting$str() {
        return "ELY02029: LdapKeyStore failed to delete alias [%s] - alias not found";
    }
    @Override
    public final KeyStoreException ldapKeyStoreFailedToDeleteNonExisting(final String alias) {
        final KeyStoreException result = new KeyStoreException(String.format(getLoggingLocale(), ldapKeyStoreFailedToDeleteNonExisting$str(), alias));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapKeyStoreFailedToTestAliasExistence$str() {
        return "ELY02030: LdapKeyStore failed to test alias [%s] existence";
    }
    @Override
    public final IllegalStateException ldapKeyStoreFailedToTestAliasExistence(final String alias, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), ldapKeyStoreFailedToTestAliasExistence$str(), alias), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ldapKeyStoreFailedToIterateAliases$str() {
        return "ELY02031: LdapKeyStore failed to iterate aliases";
    }
    @Override
    public final IllegalStateException ldapKeyStoreFailedToIterateAliases(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), ldapKeyStoreFailedToIterateAliases$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String keyStoreTypeNotDetected$str() {
        return "ELY02035: KeyStore type could not be detected";
    }
    @Override
    public final KeyStoreException keyStoreTypeNotDetected() {
        final KeyStoreException result = new KeyStoreException(String.format(getLoggingLocale(), keyStoreTypeNotDetected$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeyUnknownUnknownPasswordTypeOrAlgorithm$str() {
        return "ELY08027: Unknown password type or algorithm";
    }
    @Override
    public final InvalidKeyException invalidKeyUnknownUnknownPasswordTypeOrAlgorithm() {
        final InvalidKeyException result = new InvalidKeyException(String.format(getLoggingLocale(), invalidKeyUnknownUnknownPasswordTypeOrAlgorithm$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
