package org.wildfly.security.keystore;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import java.security.KeyStoreException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.jboss.logging.Logger;
import java.security.InvalidKeyException;
import java.lang.Exception;
import java.security.UnrecoverableKeyException;
import org.jboss.logging.BasicLogger;
import java.io.EOFException;
import java.lang.Throwable;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-03-22T10:59:14+0000")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String invalidKeyStoreEntryPassword = "ELY02001: Invalid key store entry password for alias \"%s\"";
    protected String invalidKeyStoreEntryPassword$str() {
        return invalidKeyStoreEntryPassword;
    }
    @Override
    public final UnrecoverableKeyException invalidKeyStoreEntryPassword(final String alias) {
        final UnrecoverableKeyException result = new UnrecoverableKeyException(String.format(getLoggingLocale(), invalidKeyStoreEntryPassword$str(), alias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeyStoreEntryType = "ELY02002: Invalid key store entry type for alias \"%s\" (expected %s, got %s)";
    protected String invalidKeyStoreEntryType$str() {
        return invalidKeyStoreEntryType;
    }
    @Override
    public final KeyStoreException invalidKeyStoreEntryType(final String alias, final Class<?> expectedClass, final Class<?> actualClass) {
        final KeyStoreException result = new KeyStoreException(String.format(getLoggingLocale(), invalidKeyStoreEntryType$str(), alias, expectedClass, actualClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyCannotBeProtected = "ELY02003: Key store key for alias \"%s\" cannot be protected";
    protected String keyCannotBeProtected$str() {
        return keyCannotBeProtected;
    }
    @Override
    public final KeyStoreException keyCannotBeProtected(final String alias) {
        final KeyStoreException result = new KeyStoreException(String.format(getLoggingLocale(), keyCannotBeProtected$str(), alias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyStoreFailedToTranslate = "ELY02004: Key store failed to translate password for alias \"%s\"";
    protected String keyStoreFailedToTranslate$str() {
        return keyStoreFailedToTranslate;
    }
    @Override
    public final IOException keyStoreFailedToTranslate(final String alias, final Throwable cause) {
        final IOException result = new IOException(String.format(getLoggingLocale(), keyStoreFailedToTranslate$str(), alias), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noAlgorithmForPassword = "ELY02005: Key store failed to identify a suitable algorithm for alias \"%s\"";
    protected String noAlgorithmForPassword$str() {
        return noAlgorithmForPassword;
    }
    @Override
    public final NoSuchAlgorithmException noAlgorithmForPassword(final String alias) {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(getLoggingLocale(), noAlgorithmForPassword$str(), alias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedWhitespaceInPasswordFile = "ELY02006: Unexpected whitespace in password file";
    protected String unexpectedWhitespaceInPasswordFile$str() {
        return unexpectedWhitespaceInPasswordFile;
    }
    @Override
    public final IOException unexpectedWhitespaceInPasswordFile() {
        final IOException result = new IOException(String.format(getLoggingLocale(), unexpectedWhitespaceInPasswordFile$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedEof = "ELY02007: Unexpected end of file";
    protected String unexpectedEof$str() {
        return unexpectedEof;
    }
    @Override
    public final EOFException unexpectedEof() {
        final EOFException result = new EOFException(String.format(getLoggingLocale(), unexpectedEof$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String reversibleLoadNotPossible = "ELY02008: A reversible load is not possible until the KeyStore has first been initialized";
    protected String reversibleLoadNotPossible$str() {
        return reversibleLoadNotPossible;
    }
    @Override
    public final IllegalStateException reversibleLoadNotPossible() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), reversibleLoadNotPossible$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCreateKeyStore = "ELY02009: Unable to create a new KeyStore instance";
    protected String unableToCreateKeyStore$str() {
        return unableToCreateKeyStore;
    }
    @Override
    public final IOException unableToCreateKeyStore(final Exception cause) {
        final IOException result = new IOException(String.format(getLoggingLocale(), unableToCreateKeyStore$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String emptyFilter = "ELY02012: An empty alias filter was supplied";
    protected String emptyFilter$str() {
        return emptyFilter;
    }
    @Override
    public final IllegalArgumentException emptyFilter() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), emptyFilter$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingPlusMinusAt = "ELY02013: Filter is missing '+' or '-' at offset %d";
    protected String missingPlusMinusAt$str() {
        return missingPlusMinusAt;
    }
    @Override
    public final IllegalArgumentException missingPlusMinusAt(final long position) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), missingPlusMinusAt$str(), position));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidFirstWord = "ELY02014: Invalid first word '%s', must be one of ALL/NONE";
    protected String invalidFirstWord$str() {
        return invalidFirstWord;
    }
    @Override
    public final IllegalArgumentException invalidFirstWord(final String firstWord) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidFirstWord$str(), firstWord));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToObtainDirContext = "ELY02015: Failed to obtain DirContext";
    protected String failedToObtainDirContext$str() {
        return failedToObtainDirContext;
    }
    @Override
    public final IllegalStateException failedToObtainDirContext(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), failedToObtainDirContext$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToReturnDirContext = "ELY02016: Failed to return DirContext";
    protected String failedToReturnDirContext$str() {
        return failedToReturnDirContext;
    }
    @Override
    public final IllegalStateException failedToReturnDirContext(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), failedToReturnDirContext$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToObtainAlias = "ELY02017: LdapKeyStore failed to obtain alias [%s]";
    protected String ldapKeyStoreFailedToObtainAlias$str() {
        return ldapKeyStoreFailedToObtainAlias;
    }
    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainAlias(final String alias, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), ldapKeyStoreFailedToObtainAlias$str(), alias), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToObtainCertificate = "ELY02018: LdapKeyStore failed to obtain certificate [%s]";
    protected String ldapKeyStoreFailedToObtainCertificate$str() {
        return ldapKeyStoreFailedToObtainCertificate;
    }
    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainCertificate(final String alias, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), ldapKeyStoreFailedToObtainCertificate$str(), alias), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToObtainCertificateChain = "ELY02019: LdapKeyStore failed to obtain certificate chain [%s]";
    protected String ldapKeyStoreFailedToObtainCertificateChain$str() {
        return ldapKeyStoreFailedToObtainCertificateChain;
    }
    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainCertificateChain(final String alias, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), ldapKeyStoreFailedToObtainCertificateChain$str(), alias), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToObtainKey = "ELY02020: LdapKeyStore failed to recover key of alias [%s]";
    protected String ldapKeyStoreFailedToObtainKey$str() {
        return ldapKeyStoreFailedToObtainKey;
    }
    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainKey(final String alias, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), ldapKeyStoreFailedToObtainKey$str(), alias), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToObtainAliasByCertificate = "ELY02021: LdapKeyStore failed to obtain alias by certificate";
    protected String ldapKeyStoreFailedToObtainAliasByCertificate$str() {
        return ldapKeyStoreFailedToObtainAliasByCertificate;
    }
    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainAliasByCertificate(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), ldapKeyStoreFailedToObtainAliasByCertificate$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToRecoverKey = "ELY02022: LdapKeyStore failed to recover key of alias [%s]";
    protected String ldapKeyStoreFailedToRecoverKey$str() {
        return ldapKeyStoreFailedToRecoverKey;
    }
    @Override
    public final UnrecoverableKeyException ldapKeyStoreFailedToRecoverKey(final String alias, final Throwable cause) {
        final UnrecoverableKeyException result = new UnrecoverableKeyException(String.format(getLoggingLocale(), ldapKeyStoreFailedToRecoverKey$str(), alias));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToObtainCreationDate = "ELY02023: LdapKeyStore failed to obtain creation date of alias [%s]";
    protected String ldapKeyStoreFailedToObtainCreationDate$str() {
        return ldapKeyStoreFailedToObtainCreationDate;
    }
    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainCreationDate(final String alias, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), ldapKeyStoreFailedToObtainCreationDate$str(), alias), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String creationNotConfigured = "ELY02024: Alias [%s] does not exist in LdapKeyStore and not configured for creation";
    protected String creationNotConfigured$str() {
        return creationNotConfigured;
    }
    @Override
    public final KeyStoreException creationNotConfigured(final String alias) {
        final KeyStoreException result = new KeyStoreException(String.format(getLoggingLocale(), creationNotConfigured$str(), alias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToStore = "ELY02025: LdapKeyStore failed store alias [%s]";
    protected String ldapKeyStoreFailedToStore$str() {
        return ldapKeyStoreFailedToStore;
    }
    @Override
    public final KeyStoreException ldapKeyStoreFailedToStore(final String alias, final Throwable cause) {
        final KeyStoreException result = new KeyStoreException(String.format(getLoggingLocale(), ldapKeyStoreFailedToStore$str(), alias), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToSerializeCertificate = "ELY02026: LdapKeyStore failed to serialize certificate of alias [%s]";
    protected String ldapKeyStoreFailedToSerializeCertificate$str() {
        return ldapKeyStoreFailedToSerializeCertificate;
    }
    @Override
    public final KeyStoreException ldapKeyStoreFailedToSerializeCertificate(final String alias, final Throwable cause) {
        final KeyStoreException result = new KeyStoreException(String.format(getLoggingLocale(), ldapKeyStoreFailedToSerializeCertificate$str(), alias), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToSerializeKey = "ELY02027: LdapKeyStore failed to protect (pack into keystore) key of alias [%s]";
    protected String ldapKeyStoreFailedToSerializeKey$str() {
        return ldapKeyStoreFailedToSerializeKey;
    }
    @Override
    public final KeyStoreException ldapKeyStoreFailedToSerializeKey(final String alias, final Throwable cause) {
        final KeyStoreException result = new KeyStoreException(String.format(getLoggingLocale(), ldapKeyStoreFailedToSerializeKey$str(), alias), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToDelete = "ELY02028: LdapKeyStore failed to delete alias [%s]";
    protected String ldapKeyStoreFailedToDelete$str() {
        return ldapKeyStoreFailedToDelete;
    }
    @Override
    public final KeyStoreException ldapKeyStoreFailedToDelete(final String alias, final Throwable cause) {
        final KeyStoreException result = new KeyStoreException(String.format(getLoggingLocale(), ldapKeyStoreFailedToDelete$str(), alias), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToDeleteNonExisting = "ELY02029: LdapKeyStore failed to delete alias [%s] - alias not found";
    protected String ldapKeyStoreFailedToDeleteNonExisting$str() {
        return ldapKeyStoreFailedToDeleteNonExisting;
    }
    @Override
    public final KeyStoreException ldapKeyStoreFailedToDeleteNonExisting(final String alias) {
        final KeyStoreException result = new KeyStoreException(String.format(getLoggingLocale(), ldapKeyStoreFailedToDeleteNonExisting$str(), alias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToTestAliasExistence = "ELY02030: LdapKeyStore failed to test alias [%s] existence";
    protected String ldapKeyStoreFailedToTestAliasExistence$str() {
        return ldapKeyStoreFailedToTestAliasExistence;
    }
    @Override
    public final IllegalStateException ldapKeyStoreFailedToTestAliasExistence(final String alias, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), ldapKeyStoreFailedToTestAliasExistence$str(), alias), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ldapKeyStoreFailedToIterateAliases = "ELY02031: LdapKeyStore failed to iterate aliases";
    protected String ldapKeyStoreFailedToIterateAliases$str() {
        return ldapKeyStoreFailedToIterateAliases;
    }
    @Override
    public final IllegalStateException ldapKeyStoreFailedToIterateAliases(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), ldapKeyStoreFailedToIterateAliases$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyStoreTypeNotDetected = "ELY02035: KeyStore type could not be detected";
    protected String keyStoreTypeNotDetected$str() {
        return keyStoreTypeNotDetected;
    }
    @Override
    public final KeyStoreException keyStoreTypeNotDetected() {
        final KeyStoreException result = new KeyStoreException(String.format(getLoggingLocale(), keyStoreTypeNotDetected$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeyUnknownUnknownPasswordTypeOrAlgorithm = "ELY08027: Unknown password type or algorithm";
    protected String invalidKeyUnknownUnknownPasswordTypeOrAlgorithm$str() {
        return invalidKeyUnknownUnknownPasswordTypeOrAlgorithm;
    }
    @Override
    public final InvalidKeyException invalidKeyUnknownUnknownPasswordTypeOrAlgorithm() {
        final InvalidKeyException result = new InvalidKeyException(String.format(getLoggingLocale(), invalidKeyUnknownUnknownPasswordTypeOrAlgorithm$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
