package org.wildfly.security.auth.realm.token._private;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.wildfly.security.auth.server.RealmUnavailableException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2021-07-14T15:40:14-0400")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String tokenRealmFailedToObtainPrincipal$str() {
        return "ELY01104: OAuth2-based realm failed to obtain principal";
    }
    @Override
    public final RuntimeException tokenRealmFailedToObtainPrincipal(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), tokenRealmFailedToObtainPrincipal$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String tokenRealmOAuth2TokenIntrospectionFailed$str() {
        return "ELY01105: OAuth2-based realm failed to introspect token";
    }
    @Override
    public final RealmUnavailableException tokenRealmOAuth2TokenIntrospectionFailed(final Throwable cause) {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), tokenRealmOAuth2TokenIntrospectionFailed$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tokenRealmFailedToObtainPrincipalWithClaim$str() {
        return "ELY01113: Token-based realm failed to obtain principal from token using claim [%s]";
    }
    @Override
    public final IllegalStateException tokenRealmFailedToObtainPrincipalWithClaim(final String claimName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), tokenRealmFailedToObtainPrincipalWithClaim$str(), claimName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tokenRealmJwtInvalidFormat$str() {
        return "ELY01114: Invalid token format. Tokens must have a signature part accordingly with JWS specification";
    }
    @Override
    public final IllegalArgumentException tokenRealmJwtInvalidFormat() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), tokenRealmJwtInvalidFormat$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tokenRealmJwtParseFailed$str() {
        return "ELY01115: Failed to parse token";
    }
    @Override
    public final IllegalStateException tokenRealmJwtParseFailed(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), tokenRealmJwtParseFailed$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tokenRealmJwtSignatureCheckFailed$str() {
        return "ELY01116: Signature verification failed";
    }
    @Override
    public final IllegalStateException tokenRealmJwtSignatureCheckFailed(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), tokenRealmJwtSignatureCheckFailed$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tokenRealmJwtSignatureInvalidAlgorithm$str() {
        return "ELY01117: Invalid signature algorithm [%s]";
    }
    @Override
    public final IllegalArgumentException tokenRealmJwtSignatureInvalidAlgorithm(final String algorithm) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), tokenRealmJwtSignatureInvalidAlgorithm$str(), algorithm));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tokenRealmJwtInvalidPublicKeyPem$str() {
        return "ELY01118: Public key could not be obtained. Probably due to an invalid PEM format.";
    }
    @Override
    public final IllegalArgumentException tokenRealmJwtInvalidPublicKeyPem() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), tokenRealmJwtInvalidPublicKeyPem$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void tokenRealmJwtWarnNoIssuerIgnoringIssuerCheck() {
        super.log.logf(FQCN, WARN, null, tokenRealmJwtWarnNoIssuerIgnoringIssuerCheck$str());
    }
    protected String tokenRealmJwtWarnNoIssuerIgnoringIssuerCheck$str() {
        return "ELY01126: Jwt-based token realm not configured with a list of valid issuers. Ignoring issuer verification.";
    }
    @Override
    public final void tokenRealmJwtWarnNoAudienceIgnoringAudienceCheck() {
        super.log.logf(FQCN, WARN, null, tokenRealmJwtWarnNoAudienceIgnoringAudienceCheck$str());
    }
    protected String tokenRealmJwtWarnNoAudienceIgnoringAudienceCheck$str() {
        return "ELY01127: Jwt-based token not configured with a list of valid audiences. Ignoring audience verification.";
    }
    @Override
    public final void tokenRealmJwtWarnNoPublicKeyIgnoringSignatureCheck() {
        super.log.logf(FQCN, WARN, null, tokenRealmJwtWarnNoPublicKeyIgnoringSignatureCheck$str());
    }
    protected String tokenRealmJwtWarnNoPublicKeyIgnoringSignatureCheck$str() {
        return "ELY01128: Jwt-based token not configured with a public key. Ignoring signature verification.";
    }
    @Override
    public final void unableToFetchJwks(final String url) {
        super.log.logf(FQCN, WARN, null, unableToFetchJwks$str(), url);
    }
    protected String unableToFetchJwks$str() {
        return "ELY01178: Unable to update jwk set from \"%1$s\".";
    }
    @Override
    public final void tokenRealmJwtNoSSLIgnoringJku() {
        super.log.logf(FQCN, WARN, null, tokenRealmJwtNoSSLIgnoringJku$str());
    }
    protected String tokenRealmJwtNoSSLIgnoringJku$str() {
        return "ELY01179: SSL not configured. jku claim will not be supported.";
    }
    @Override
    public final void tokenRealmJwkMissingClaim(final String claim) {
        super.log.logf(FQCN, INFO, null, tokenRealmJwkMissingClaim$str(), claim);
    }
    protected String tokenRealmJwkMissingClaim$str() {
        return "ELY01180: Fetched jwk does not contain \"%1$s\" claim, ignoring...";
    }
}
