/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.test;

import java.util.Arrays;
import java.util.Enumeration;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslServerFactory;
import org.junit.Assert;

public final class SaslTestUtil {
    public static <T extends SaslServerFactory> T obtainSaslServerFactory(Class<T> requiredServerFactory) {
        Enumeration<SaslServerFactory> serverFactories = Sasl.getSaslServerFactories();
        while (serverFactories.hasMoreElements()) {
            SaslServerFactory current = serverFactories.nextElement();
            if (!current.getClass().equals(requiredServerFactory)) continue;
            return (T)((SaslServerFactory)requiredServerFactory.cast(current));
        }
        return null;
    }

    public static <T extends SaslClientFactory> T obtainSaslClientFactory(Class<T> requiredClientFactory) {
        Enumeration<SaslClientFactory> clientFactories = Sasl.getSaslClientFactories();
        while (clientFactories.hasMoreElements()) {
            SaslClientFactory current = clientFactories.nextElement();
            if (!current.getClass().equals(requiredClientFactory)) continue;
            return (T)((SaslClientFactory)requiredClientFactory.cast(current));
        }
        return null;
    }

    public static void assertNoMechanisms(String[] mechanisms) {
        Assert.assertEquals((long)0L, (long)mechanisms.length);
    }

    public static void assertSingleMechanism(String mechanismName, String[] mechanisms) {
        Assert.assertEquals((long)1L, (long)mechanisms.length);
        Assert.assertEquals((Object)mechanismName, (Object)mechanisms[0]);
    }

    public static void assertMechanisms(String[] expectedMechanisms, String[] mechanisms) {
        Assert.assertEquals((long)expectedMechanisms.length, (long)mechanisms.length);
        Assert.assertTrue((boolean)Arrays.asList(expectedMechanisms).containsAll(Arrays.asList(mechanisms)));
    }
}

