/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl.test.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.security.auth.x500.X500Principal;
import org.wildfly.security.ssl.test.util.CustomIdentity;
import org.wildfly.security.ssl.test.util.DefinedCAIdentity;
import org.wildfly.security.ssl.test.util.DefinedIdentity;
import org.wildfly.security.x500.GeneralName;
import org.wildfly.security.x500.cert.AccessDescription;
import org.wildfly.security.x500.cert.AuthorityInformationAccessExtension;
import org.wildfly.security.x500.cert.BasicConstraintsExtension;
import org.wildfly.security.x500.cert.SelfSignedX509CertificateAndSigningKey;
import org.wildfly.security.x500.cert.X509CertificateBuilder;
import org.wildfly.security.x500.cert.X509CertificateExtension;

public class CAGenerationTool
implements Closeable {
    public static final String SIGNATURE_ALGORTHM = "SHA256withRSA";
    private static final String BEETLES_STORE = "beetles.keystore";
    private static final String KEY_ALGORITHM = "RSA";
    private static final String KEYSTORE_TYPE = "JKS";
    private static final int OCSP_PORT = 4854;
    static final char[] PASSWORD = "Elytron".toCharArray();
    private static final Set<Identity> BEETLES = Collections.unmodifiableSet(new HashSet<Identity>(Arrays.asList(Identity.LADYBIRD, Identity.SCARAB, Identity.DUNG, Identity.FIREFLY)));
    private static final Predicate<Identity> INCLUDE_IN_BEETLES = BEETLES::contains;
    private final KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
    private final Map<Identity, CAState> caMap = new HashMap<Identity, CAState>();
    private final Map<Identity, X509Certificate> certificateMap = new HashMap<Identity, X509Certificate>();
    private final File workingDir;
    private volatile boolean closed = false;

    protected CAGenerationTool(Builder builder) throws Exception {
        this.workingDir = new File(builder.baseDir);
        this.workingDir.mkdirs();
        KeyStore beetlesStore = CAGenerationTool.createEmptyKeyStore();
        for (Identity currentIdentity : builder.requestedIdentities) {
            if (currentIdentity.isCertificateAuthority()) {
                this.caMap.computeIfAbsent(currentIdentity, this::createCA);
                continue;
            }
            X509Certificate certificate = this.createIdentity(currentIdentity);
            this.certificateMap.put(currentIdentity, certificate);
            if (!INCLUDE_IN_BEETLES.test(currentIdentity)) continue;
            beetlesStore.setCertificateEntry(currentIdentity.toString(), certificate);
        }
        try {
            File keyStoreFile = new File(this.workingDir, BEETLES_STORE);
            try (FileOutputStream out = new FileOutputStream(keyStoreFile);){
                beetlesStore.store(out, PASSWORD);
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public DefinedIdentity getDefinedIdentity(Identity identity) {
        if (identity.isCertificateAuthority()) {
            return this.getDefinedCAIdentity(identity);
        }
        if (!this.certificateMap.containsKey((Object)identity)) {
            throw new IllegalStateException(String.format("Identity %s has not been created.", identity.toString()));
        }
        X509Certificate certificate = this.certificateMap.get((Object)identity);
        return new DefinedIdentity(this, identity, certificate);
    }

    public DefinedCAIdentity getDefinedCAIdentity(Identity identity) {
        if (!identity.isCertificateAuthority()) {
            throw new IllegalStateException(String.format("Identity %s is not a CertificateAuthority", identity.toString()));
        }
        if (!this.caMap.containsKey((Object)identity)) {
            throw new IllegalStateException(String.format("Identity %s has not been created.", identity.toString()));
        }
        CAState caState = this.caMap.get((Object)identity);
        return new DefinedCAIdentity(this, identity, caState.issuerCertificate, caState.signingKey);
    }

    public KeyStore getBeetlesKeyStore() {
        return CAGenerationTool.loadKeyStore(new File(this.workingDir, BEETLES_STORE));
    }

    @Deprecated
    public X509Certificate getCertificate(Identity identity) {
        return this.certificateMap.get((Object)identity);
    }

    @Deprecated
    public PrivateKey getPrivateKey(Identity identity) {
        if (!identity.isCertificateAuthority()) {
            throw new IllegalStateException(String.format("Identity %s if not a CertificateAuthority", identity.toString()));
        }
        return this.caMap.computeIfAbsent((Identity)identity, (Function<Identity, CAState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, createCA(org.wildfly.security.ssl.test.util.CAGenerationTool$Identity ), (Lorg/wildfly/security/ssl/test/util/CAGenerationTool$Identity;)Lorg/wildfly/security/ssl/test/util/CAGenerationTool$CAState;)((CAGenerationTool)this)).signingKey;
    }

    private CAState createCA(Identity identity) {
        CAState caState = new CAState();
        Identity signedBy = identity.getSignedBy();
        if (signedBy == null) {
            SelfSignedX509CertificateAndSigningKey issuerSelfSignedX509CertificateAndSigningKey = SelfSignedX509CertificateAndSigningKey.builder().setDn(identity.getPrincipal()).setKeyAlgorithmName(KEY_ALGORITHM).setSignatureAlgorithmName(SIGNATURE_ALGORTHM).addExtension(false, "BasicConstraints", "CA:true,pathlen:2147483647").build();
            caState.issuerCertificate = issuerSelfSignedX509CertificateAndSigningKey.getSelfSignedCertificate();
            caState.signingKey = issuerSelfSignedX509CertificateAndSigningKey.getSigningKey();
        } else {
            try {
                X509Certificate intermediateIssuerCertificate;
                CAState signerState = this.caMap.computeIfAbsent(signedBy, this::createCA);
                KeyPair keyPair = this.keyPairGenerator.generateKeyPair();
                caState.issuerCertificate = intermediateIssuerCertificate = new X509CertificateBuilder().setIssuerDn(signedBy.getPrincipal()).setSubjectDn(identity.getPrincipal()).setSignatureAlgorithmName(SIGNATURE_ALGORTHM).setSigningKey(signerState.signingKey).setPublicKey(keyPair.getPublic()).setSerialNumber(BigInteger.valueOf(signerState.serialNumber++)).addExtension((X509CertificateExtension)new BasicConstraintsExtension(false, true, -1)).addExtension((X509CertificateExtension)new AuthorityInformationAccessExtension(Collections.singletonList(new AccessDescription("1.3.6.1.5.5.7.48.1", (GeneralName)new GeneralName.URIName("http://localhost:4854/ocsp"))))).build();
                caState.signingKey = keyPair.getPrivate();
            }
            catch (CertificateException e) {
                throw new RuntimeException(e);
            }
        }
        if (identity.getKeyStoreName() != null) {
            try {
                File keyStoreFile = new File(this.workingDir, identity.getKeyStoreName());
                KeyStore keyStore = keyStoreFile.exists() ? CAGenerationTool.loadKeyStore(keyStoreFile) : CAGenerationTool.createEmptyKeyStore();
                keyStore.setCertificateEntry(identity.toString(), caState.issuerCertificate);
                try (FileOutputStream out = new FileOutputStream(keyStoreFile);){
                    keyStore.store(out, PASSWORD);
                }
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new RuntimeException(e);
            }
        }
        this.certificateMap.put(identity, caState.issuerCertificate);
        return caState;
    }

    private X509Certificate createCustomCertificate(Identity ca, X500Principal principal, KeyPair keyPair, X509CertificateExtension ... extensions) throws CertificateException {
        CAState caState = this.caMap.computeIfAbsent(ca, this::createCA);
        X509CertificateBuilder certificateBuilder = new X509CertificateBuilder().setIssuerDn(ca.getPrincipal()).setSubjectDn(principal).setSignatureAlgorithmName(SIGNATURE_ALGORTHM).setSigningKey(caState.signingKey).setPublicKey(keyPair.getPublic()).setSerialNumber(BigInteger.valueOf(caState.serialNumber++)).addExtension((X509CertificateExtension)new BasicConstraintsExtension(false, false, -1));
        for (X509CertificateExtension currentExtension : extensions) {
            certificateBuilder.addExtension(currentExtension);
        }
        return certificateBuilder.build();
    }

    CustomIdentity createCustomIdentity(String alias, X500Principal principal, String keyStoreName, Identity ca, X509CertificateExtension ... extensions) {
        try {
            KeyPair keyPair = this.keyPairGenerator.generateKeyPair();
            X509Certificate builtCertificate = this.createCustomCertificate(ca, principal, keyPair, extensions);
            File keyStoreFile = new File(this.workingDir, keyStoreName);
            KeyStore keyStore = CAGenerationTool.createEmptyKeyStore();
            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
            certificates.add(builtCertificate);
            Identity caIdentity = ca;
            do {
                CAState caState = this.caMap.get((Object)caIdentity);
                certificates.add(caState.issuerCertificate);
            } while ((caIdentity = caIdentity.getSignedBy()) != null);
            keyStore.setKeyEntry(alias, keyPair.getPrivate(), PASSWORD, certificates.toArray(new X509Certificate[certificates.size()]));
            try (FileOutputStream out = new FileOutputStream(keyStoreFile);){
                keyStore.store(out, PASSWORD);
            }
            return new CustomIdentity(this, builtCertificate, keyStoreFile);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException("Umnable to create identity", e);
        }
    }

    @Deprecated
    public X509Certificate createIdentity(String alias, X500Principal principal, String keyStoreName, Identity ca, X509CertificateExtension ... extensions) {
        try {
            KeyPair keyPair = this.keyPairGenerator.generateKeyPair();
            X509Certificate builtCertificate = this.createCustomCertificate(ca, principal, keyPair, extensions);
            File keyStoreFile = new File(this.workingDir, keyStoreName);
            KeyStore keyStore = CAGenerationTool.createEmptyKeyStore();
            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
            certificates.add(builtCertificate);
            Identity caIdentity = ca;
            do {
                CAState caState = this.caMap.get((Object)caIdentity);
                keyStore.setCertificateEntry(caIdentity.toString(), caState.issuerCertificate);
                certificates.add(caState.issuerCertificate);
            } while ((caIdentity = caIdentity.getSignedBy()) != null);
            keyStore.setKeyEntry(alias, keyPair.getPrivate(), PASSWORD, certificates.toArray(new X509Certificate[certificates.size()]));
            try (FileOutputStream out = new FileOutputStream(keyStoreFile);){
                keyStore.store(out, PASSWORD);
            }
            return builtCertificate;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    private X509Certificate createSelfSignedIdentity(String alias, X500Principal principal, String keyStoreName) {
        SelfSignedX509CertificateAndSigningKey selfSignedIdentity = SelfSignedX509CertificateAndSigningKey.builder().setDn(principal).setKeyAlgorithmName(KEY_ALGORITHM).setSignatureAlgorithmName(SIGNATURE_ALGORTHM).build();
        X509Certificate selfSignedCertificate = selfSignedIdentity.getSelfSignedCertificate();
        File keyStoreFile = new File(this.workingDir, keyStoreName);
        KeyStore keyStore = CAGenerationTool.createEmptyKeyStore();
        try {
            keyStore.setKeyEntry(alias, selfSignedIdentity.getSigningKey(), PASSWORD, new X509Certificate[]{selfSignedIdentity.getSelfSignedCertificate()});
            try (FileOutputStream out = new FileOutputStream(keyStoreFile);){
                keyStore.store(out, PASSWORD);
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
        return selfSignedCertificate;
    }

    private X509Certificate createIdentity(Identity identity) {
        Identity caIdentity = identity.getSignedBy();
        if (caIdentity == null) {
            throw new IllegalStateException(String.format("Identity %s does not have a CA.", identity.toString()));
        }
        return this.createIdentity(identity.toString(), identity.getPrincipal(), identity.getKeyStoreName(), caIdentity, new X509CertificateExtension[0]);
    }

    private static KeyStore createEmptyKeyStore() {
        try {
            KeyStore ks = KeyStore.getInstance(KEYSTORE_TYPE);
            ks.load(null, null);
            return ks;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    KeyStore loadKeyStore(Identity identity) {
        return CAGenerationTool.loadKeyStore(new File(this.workingDir, identity.getKeyStoreName()));
    }

    static KeyStore loadKeyStore(File location) {
        KeyStore keyStore;
        FileInputStream caTrustStoreFile = new FileInputStream(location);
        try {
            KeyStore keyStore2 = KeyStore.getInstance(KEYSTORE_TYPE);
            keyStore2.load(caTrustStoreFile, PASSWORD);
            keyStore = keyStore2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)caTrustStoreFile).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new RuntimeException(e);
            }
        }
        ((InputStream)caTrustStoreFile).close();
        return keyStore;
    }

    void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("The CAGenerationTool is closed.");
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.workingDir.delete();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String baseDir = ".";
        private Identity[] requestedIdentities = new Identity[0];

        public Builder setBaseDir(String baseDir) {
            this.baseDir = baseDir;
            return this;
        }

        public Builder setRequestIdentities(Identity ... requestedIdentities) {
            this.requestedIdentities = requestedIdentities;
            return this;
        }

        public CAGenerationTool build() throws Exception {
            return new CAGenerationTool(this);
        }
    }

    public static enum Identity {
        CA("CN=Elytron CA, ST=Elytron, C=UK, EMAILADDRESS=elytron@wildfly.org, O=Root Certificate Authority", null, true, "ca.truststore"),
        LADYBIRD("OU=Elytron, O=Elytron, C=UK, ST=Elytron, CN=Ladybird", CA, false, "ladybird.keystore"),
        SCARAB("OU=Elytron, O=Elytron, C=UK, ST=Elytron, CN=Scarab", CA, false, "scarab.keystore"),
        DUNG("OU=Elytron, O=Elytron, C=UK, ST=Elytron, CN=Dung", CA, false, "dung.keystore"),
        FIREFLY("OU=Elytron, O=Elytron, C=UK, ST=Elytron, CN=Firefly", CA, false, "firefly.keystore"),
        INTERMEDIATE("CN=Elytron ICA, ST=Elytron, C=UK, O=Intermediate Certificate Authority", CA, true, null),
        ROVE("OU=Elytron, O=Elytron, C=UK, ST=Elytron, CN=Rove", INTERMEDIATE, false, "rove.keystore"),
        SECOND_CA("CN=Wildfly CA, ST=Wildfly, C=CA, EMAILADDRESS=admin@wildfly.org O=Another Root Certificate Authority", null, true, "ca.truststore2"),
        LADYBUG("OU=Wildfly, O=Wildfly, C=CA, ST=Wildfly, CN=Ladybug", SECOND_CA, false, "ladybug.keystore"),
        GREENJUNE("OU=Wildfly, O=Wildfly, C=CA, ST=Wildfly, CN=Green June", SECOND_CA, false, "greenjune.keystore");

        private final X500Principal principal;
        private final Identity signedBy;
        private final boolean ca;
        private final String keyStoreName;

        private Identity(String distinguishedName, Identity signedBy, boolean ca, String keyStoreName) {
            this.principal = new X500Principal(distinguishedName);
            this.signedBy = signedBy;
            this.ca = ca;
            this.keyStoreName = keyStoreName;
        }

        public X500Principal getPrincipal() {
            return this.principal;
        }

        public Identity getSignedBy() {
            return this.signedBy;
        }

        public boolean isCertificateAuthority() {
            return this.ca;
        }

        public String getKeyStoreName() {
            return this.keyStoreName;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }

    static class CAState {
        PrivateKey signingKey;
        X509Certificate issuerCertificate;
        int serialNumber = 1;

        CAState() {
        }
    }
}

