/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl.test.util;

import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.wildfly.security.ssl.test.util.CAGenerationTool;
import org.wildfly.security.ssl.test.util.CustomIdentity;
import org.wildfly.security.ssl.test.util.DefinedIdentity;
import org.wildfly.security.x500.cert.X509CertificateExtension;

public class DefinedCAIdentity
extends DefinedIdentity {
    private final PrivateKey privateKey;

    DefinedCAIdentity(CAGenerationTool caGenerationTool, CAGenerationTool.Identity identity, X509Certificate certificate, PrivateKey privateKey) {
        super(caGenerationTool, identity, certificate);
        this.privateKey = privateKey;
    }

    public CustomIdentity createIdentity(String alias, X500Principal principal, String keyStoreName, X509CertificateExtension ... extensions) {
        this.caGenerationTool.assertNotClosed();
        return this.caGenerationTool.createCustomIdentity(alias, principal, keyStoreName, this.identity, extensions);
    }

    public PrivateKey getPrivateKey() {
        this.caGenerationTool.assertNotClosed();
        return this.privateKey;
    }

    public X509TrustManager createTrustManager() {
        this.caGenerationTool.assertNotClosed();
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
            trustManagerFactory.init(this.caGenerationTool.loadKeyStore(this.identity));
            for (TrustManager current : trustManagerFactory.getTrustManagers()) {
                if (!(current instanceof X509TrustManager)) continue;
                return (X509TrustManager)current;
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to obtain X509TrustManager.", e);
        }
        throw new IllegalStateException("Unable to obtain X509TrustManager.");
    }
}

