/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.auth.util.CaseNameRewriter;

public class CaseNameRewriterTest {
    private static final String LOWER_CASE_USER_NAME = "hellouser";
    private static final String UPPER_CASE_USER_NAME = "HELLOUSER";

    @Test
    public void testUpperCaseNameRewriter() {
        CaseNameRewriter rewriter = new CaseNameRewriter(true);
        String adjustedName = rewriter.rewriteName(LOWER_CASE_USER_NAME);
        Assert.assertEquals((Object)UPPER_CASE_USER_NAME, (Object)adjustedName);
    }

    @Test
    public void testUpperCaseNameRewriterDefaultBehaviour() {
        CaseNameRewriter rewriter = new CaseNameRewriter();
        String adjustedName = rewriter.rewriteName(LOWER_CASE_USER_NAME);
        Assert.assertEquals((Object)UPPER_CASE_USER_NAME, (Object)adjustedName);
    }

    @Test
    public void testLowerCaseNameRewriter() {
        CaseNameRewriter rewriter = new CaseNameRewriter(false);
        String adjustedName = rewriter.rewriteName(UPPER_CASE_USER_NAME);
        Assert.assertEquals((Object)LOWER_CASE_USER_NAME, (Object)adjustedName);
    }

    @Test
    public void testCaseNameRewriterExistingUserUpperCase() throws Exception {
        FileSystemSecurityRealm fileSystemSecurityRealm = this.createSecurityRealm();
        CaseNameRewriter rewriter = new CaseNameRewriter(true);
        SecurityDomain domainWithRewriter = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)fileSystemSecurityRealm).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).setPreRealmRewriter((NameRewriter)rewriter).build();
        ServerAuthenticationContext sac1 = domainWithRewriter.createNewAuthenticationContext();
        sac1.setAuthenticationName("alice");
        Assert.assertTrue((boolean)sac1.authorize());
        SecurityDomain domainWithoutRewriter = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)fileSystemSecurityRealm).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).build();
        ServerAuthenticationContext sac2 = domainWithoutRewriter.createNewAuthenticationContext();
        sac2.setAuthenticationName("alice");
        Assert.assertFalse((boolean)sac2.authorize());
    }

    @Test
    public void testCaseNameRewriterExistingUserLowerCase() throws Exception {
        FileSystemSecurityRealm fileSystemSecurityRealm = this.createSecurityRealm();
        CaseNameRewriter rewriter = new CaseNameRewriter(false);
        SecurityDomain domainWithRewriter = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)fileSystemSecurityRealm).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).setPreRealmRewriter((NameRewriter)rewriter).build();
        ServerAuthenticationContext sac1 = domainWithRewriter.createNewAuthenticationContext();
        sac1.setAuthenticationName("JOHN");
        Assert.assertTrue((boolean)sac1.authorize());
        SecurityDomain domainWithoutRewriter = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)fileSystemSecurityRealm).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).build();
        ServerAuthenticationContext sac2 = domainWithoutRewriter.createNewAuthenticationContext();
        sac2.setAuthenticationName("JOHN");
        Assert.assertFalse((boolean)sac2.authorize());
    }

    @Test
    public void testCaseNameRewriterNonExistingUser() throws Exception {
        FileSystemSecurityRealm fileSystemSecurityRealm = this.createSecurityRealm();
        CaseNameRewriter rewriter = new CaseNameRewriter(true);
        SecurityDomain securityDomain = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)fileSystemSecurityRealm).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).setPreRealmRewriter((NameRewriter)rewriter).build();
        ServerAuthenticationContext sac = securityDomain.createNewAuthenticationContext();
        sac.setAuthenticationName("bob");
        Assert.assertFalse((boolean)sac.authorize());
    }

    private FileSystemSecurityRealm createSecurityRealm() throws Exception {
        FileSystemSecurityRealm realm = new FileSystemSecurityRealm(this.getRootPath(true));
        this.addUser((ModifiableSecurityRealm)realm, "ALICE");
        this.addUser((ModifiableSecurityRealm)realm, "john");
        return realm;
    }

    private Path getRootPath(boolean deleteIfExists) throws Exception {
        Path rootPath = Paths.get(this.getClass().getResource(File.separator).toURI()).resolve("filesystem-realm");
        if (rootPath.toFile().exists() && !deleteIfExists) {
            return rootPath;
        }
        return Files.walkFileTree(Files.createDirectories(rootPath, new FileAttribute[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void addUser(ModifiableSecurityRealm realm, String userName) throws RealmUnavailableException {
        ModifiableRealmIdentity realmIdentity = realm.getRealmIdentityForUpdate((Principal)new NamePrincipal(userName));
        realmIdentity.create();
        realmIdentity.dispose();
    }
}

