/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLSession;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import mockit.Mock;
import mockit.MockUp;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.wildfly.security.auth.callback.AuthenticationCompleteCallback;
import org.wildfly.security.auth.callback.AvailableRealmsCallback;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.auth.callback.IdentityCredentialCallback;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpExchangeSpi;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.HttpServerCookie;
import org.wildfly.security.http.HttpServerMechanismsResponder;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.HttpServerResponse;
import org.wildfly.security.http.Scope;
import org.wildfly.security.http.basic.BasicMechanismFactory;
import org.wildfly.security.http.digest.DigestMechanismFactory;
import org.wildfly.security.http.digest.NonceManager;
import org.wildfly.security.http.external.ExternalMechanismFactory;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;

public class AbstractBaseHttpTest {
    protected HttpServerAuthenticationMechanismFactory basicFactory = new BasicMechanismFactory();
    protected HttpServerAuthenticationMechanismFactory digestFactory = new DigestMechanismFactory();
    protected final HttpServerAuthenticationMechanismFactory externalFactory = new ExternalMechanismFactory();

    protected void mockDigestNonce(final String nonce) {
        new MockUp<NonceManager>(){

            @Mock
            String generateNonce(byte[] salt) {
                return nonce;
            }

            @Mock
            boolean useNonce(String nonce2, byte[] salt, int nonceCount) {
                return true;
            }
        };
    }

    protected CallbackHandler getCallbackHandler(String username, String realm, String password) {
        return callbacks -> {
            for (Callback callback : callbacks) {
                if (callback instanceof AvailableRealmsCallback) {
                    ((AvailableRealmsCallback)callback).setRealmNames(new String[]{realm});
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    Assert.assertEquals((Object)realm, (Object)((RealmCallback)callback).getDefaultText());
                    continue;
                }
                if (callback instanceof NameCallback) {
                    Assert.assertEquals((Object)username, (Object)((NameCallback)callback).getDefaultName());
                    continue;
                }
                if (callback instanceof CredentialCallback) {
                    if (!"clear".equals(((CredentialCallback)callback).getAlgorithm())) {
                        throw new UnsupportedCallbackException(callback);
                    }
                    try {
                        PasswordFactory factory = PasswordFactory.getInstance((String)"clear");
                        Password pass = factory.generatePassword((KeySpec)new ClearPasswordSpec(password.toCharArray()));
                        ((CredentialCallback)callback).setCredential((Credential)new PasswordCredential(pass));
                        continue;
                    }
                    catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                        throw new IllegalStateException(e);
                    }
                }
                if (callback instanceof EvidenceVerifyCallback) {
                    PasswordGuessEvidence evidence = (PasswordGuessEvidence)((EvidenceVerifyCallback)callback).getEvidence();
                    ((EvidenceVerifyCallback)callback).setVerified(Arrays.equals(evidence.getGuess(), password.toCharArray()));
                    evidence.destroy();
                    continue;
                }
                if (callback instanceof AuthenticationCompleteCallback) continue;
                if (callback instanceof IdentityCredentialCallback) {
                    Credential credential = ((IdentityCredentialCallback)callback).getCredential();
                    MatcherAssert.assertThat((Object)credential, (Matcher)CoreMatchers.instanceOf(PasswordCredential.class));
                    ClearPassword clearPwdCredential = (ClearPassword)((PasswordCredential)credential).getPassword().castAs(ClearPassword.class);
                    Assert.assertNotNull((Object)clearPwdCredential);
                    Assert.assertArrayEquals((char[])password.toCharArray(), (char[])clearPwdCredential.getPassword());
                    continue;
                }
                if (callback instanceof AuthorizeCallback) {
                    if (username.equals(((AuthorizeCallback)callback).getAuthenticationID()) && username.equals(((AuthorizeCallback)callback).getAuthorizationID())) {
                        ((AuthorizeCallback)callback).setAuthorized(true);
                        continue;
                    }
                    ((AuthorizeCallback)callback).setAuthorized(false);
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
        };
    }

    public class TestingHttpExchangeSpi
    implements HttpExchangeSpi {
        private List<String> requestAuthorizationHeaders = Collections.emptyList();
        private List<String> responseAuthenticateHeaders = new LinkedList<String>();
        private List<String> responseAuthenticationInfoHeaders = new LinkedList<String>();
        private int statusCode;
        private Status result;

        public int getStatusCode() {
            return this.statusCode;
        }

        public Status getResult() {
            return this.result;
        }

        public List<String> getResponseAuthenticateHeaders() {
            return this.responseAuthenticateHeaders;
        }

        public List<String> getResponseAuthenticationInfoHeaders() {
            return this.responseAuthenticationInfoHeaders;
        }

        public void setRequestAuthorizationHeaders(List<String> requestAuthorizationHeaders) {
            this.requestAuthorizationHeaders = requestAuthorizationHeaders;
        }

        public List<String> getRequestHeaderValues(String headerName) {
            if ("Authorization".equals(headerName)) {
                return this.requestAuthorizationHeaders;
            }
            throw new IllegalStateException();
        }

        public void addResponseHeader(String headerName, String headerValue) {
            if ("WWW-Authenticate".equals(headerName)) {
                this.responseAuthenticateHeaders.add(headerValue);
            } else if ("Authentication-Info".equals(headerName)) {
                this.responseAuthenticationInfoHeaders.add(headerValue);
            } else {
                throw new IllegalStateException();
            }
        }

        public void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        public void authenticationComplete(SecurityIdentity securityIdentity, String mechanismName) {
            this.result = Status.COMPLETE;
        }

        public void authenticationFailed(String message, String mechanismName) {
            this.result = Status.FAILED;
        }

        public void badRequest(HttpAuthenticationException error, String mechanismName) {
            this.result = Status.BAD_REQUEST;
        }

        public String getRequestMethod() {
            return "GET";
        }

        public URI getRequestURI() {
            throw new IllegalStateException();
        }

        public String getRequestPath() {
            throw new IllegalStateException();
        }

        public Map<String, List<String>> getRequestParameters() {
            throw new IllegalStateException();
        }

        public List<HttpServerCookie> getCookies() {
            throw new IllegalStateException();
        }

        public InputStream getRequestInputStream() {
            throw new IllegalStateException();
        }

        public InetSocketAddress getSourceAddress() {
            throw new IllegalStateException();
        }

        public void setResponseCookie(HttpServerCookie cookie) {
            throw new IllegalStateException();
        }

        public OutputStream getResponseOutputStream() {
            throw new IllegalStateException();
        }

        public HttpScope getScope(Scope scope) {
            throw new IllegalStateException();
        }

        public Collection<String> getScopeIds(Scope scope) {
            throw new IllegalStateException();
        }

        public HttpScope getScope(Scope scope, String id) {
            throw new IllegalStateException();
        }
    }

    protected static class TestingHttpServerResponse
    implements HttpServerResponse {
        private int statusCode;
        private String authenticate;
        private String location;
        private List<HttpServerCookie> cookies;

        protected TestingHttpServerResponse() {
        }

        public void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public void addResponseHeader(String headerName, String headerValue) {
            if ("WWW-Authenticate".equals(headerName)) {
                this.authenticate = headerValue;
            } else if ("Location".equals(headerName)) {
                this.location = headerValue;
            }
        }

        public String getAuthenticateHeader() {
            return this.authenticate;
        }

        public String getLocation() {
            return this.location;
        }

        public List<HttpServerCookie> getCookies() {
            return this.cookies;
        }

        public void setResponseCookie(HttpServerCookie cookie) {
            if (this.cookies == null) {
                this.cookies = new ArrayList<HttpServerCookie>();
            }
            this.cookies.add(cookie);
        }

        public OutputStream getOutputStream() {
            throw new IllegalStateException();
        }

        public boolean forward(String path) {
            throw new IllegalStateException();
        }
    }

    protected static class TestingHttpServerRequest
    implements HttpServerRequest {
        private String[] authorization;
        private Status result;
        private HttpServerMechanismsResponder responder;
        private String remoteUser;
        private URI requestURI;
        private List<HttpServerCookie> cookies;

        public TestingHttpServerRequest(String[] authorization) {
            this.authorization = authorization;
            this.remoteUser = null;
        }

        public TestingHttpServerRequest(String[] authorization, URI requestURI) {
            this.authorization = authorization;
            this.remoteUser = null;
            this.requestURI = requestURI;
        }

        public TestingHttpServerRequest(String[] authorization, URI requestURI, String cookie) {
            this.authorization = authorization;
            this.remoteUser = null;
            this.requestURI = requestURI;
            if (cookie != null) {
                final String cookieName = cookie.substring(0, cookie.indexOf(61));
                final String cookieValue = cookie.substring(cookie.indexOf(61) + 1);
                this.cookies = new ArrayList<HttpServerCookie>();
                this.cookies.add(new HttpServerCookie(){

                    public String getName() {
                        return cookieName;
                    }

                    public String getValue() {
                        return cookieValue;
                    }

                    public String getDomain() {
                        return null;
                    }

                    public int getMaxAge() {
                        return -1;
                    }

                    public String getPath() {
                        return "/";
                    }

                    public boolean isSecure() {
                        return false;
                    }

                    public int getVersion() {
                        return 0;
                    }

                    public boolean isHttpOnly() {
                        return true;
                    }
                });
            }
        }

        public Status getResult() {
            return this.result;
        }

        public TestingHttpServerResponse getResponse() throws HttpAuthenticationException {
            TestingHttpServerResponse response = new TestingHttpServerResponse();
            this.responder.sendResponse((HttpServerResponse)response);
            return response;
        }

        public List<String> getRequestHeaderValues(String headerName) {
            if ("Authorization".equals(headerName)) {
                return this.authorization == null ? null : Arrays.asList(this.authorization);
            }
            return null;
        }

        public String getFirstRequestHeaderValue(String headerName) {
            throw new IllegalStateException();
        }

        public SSLSession getSSLSession() {
            throw new IllegalStateException();
        }

        public Certificate[] getPeerCertificates() {
            throw new IllegalStateException();
        }

        public void noAuthenticationInProgress(HttpServerMechanismsResponder responder) {
            this.result = Status.NO_AUTH;
            this.responder = responder;
        }

        public void authenticationInProgress(HttpServerMechanismsResponder responder) {
            this.result = Status.IN_PROGRESS;
            this.responder = responder;
        }

        public void authenticationComplete(HttpServerMechanismsResponder responder) {
            this.result = Status.COMPLETE;
            this.responder = responder;
        }

        public void authenticationComplete(HttpServerMechanismsResponder responder, Runnable logoutHandler) {
            this.result = Status.COMPLETE;
            this.responder = responder;
        }

        public void authenticationFailed(String message, HttpServerMechanismsResponder responder) {
            this.result = Status.FAILED;
            this.responder = responder;
        }

        public void badRequest(HttpAuthenticationException failure, HttpServerMechanismsResponder responder) {
            throw new IllegalStateException();
        }

        public String getRequestMethod() {
            return "GET";
        }

        public URI getRequestURI() {
            return this.requestURI;
        }

        public String getRequestPath() {
            throw new IllegalStateException();
        }

        public Map<String, List<String>> getParameters() {
            throw new IllegalStateException();
        }

        public Set<String> getParameterNames() {
            throw new IllegalStateException();
        }

        public List<String> getParameterValues(String name) {
            throw new IllegalStateException();
        }

        public String getFirstParameterValue(String name) {
            throw new IllegalStateException();
        }

        public List<HttpServerCookie> getCookies() {
            return this.cookies;
        }

        public InputStream getInputStream() {
            throw new IllegalStateException();
        }

        public InetSocketAddress getSourceAddress() {
            return null;
        }

        public boolean suspendRequest() {
            return true;
        }

        public boolean resumeRequest() {
            throw new IllegalStateException();
        }

        public HttpScope getScope(Scope scope) {
            return new HttpScope(){

                public boolean exists() {
                    return true;
                }

                public boolean create() {
                    return false;
                }

                public boolean supportsAttachments() {
                    return true;
                }

                public boolean supportsInvalidation() {
                    return false;
                }

                public void setAttachment(String key, Object value) {
                }

                public Object getAttachment(String key) {
                    return null;
                }
            };
        }

        public Collection<String> getScopeIds(Scope scope) {
            throw new IllegalStateException();
        }

        public HttpScope getScope(Scope scope, String id) {
            throw new IllegalStateException();
        }

        public void setRemoteUser(String remoteUser) {
            this.remoteUser = remoteUser;
        }

        public String getRemoteUser() {
            return this.remoteUser;
        }
    }

    protected static enum Status {
        NO_AUTH,
        IN_PROGRESS,
        BAD_REQUEST,
        COMPLETE,
        FAILED;

    }
}

