/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.wildfly.security.auth.principal.NamePrincipal;

public class TestLoginModule
implements LoginModule {
    private final Map<String, char[]> usersMap = new HashMap<String, char[]>();
    private Principal principal;
    private Subject subject;
    private CallbackHandler handler;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.handler = callbackHandler;
        this.usersMap.put("elytron", "passwd12#$".toCharArray());
        this.usersMap.put("javajoe", "$#21pass".toCharArray());
        this.usersMap.put("javaduke", "dukepass!@34".toCharArray());
    }

    @Override
    public boolean login() throws LoginException {
        NameCallback nameCallback = new NameCallback("Username");
        PasswordCallback passwordCallback = new PasswordCallback("Password", false);
        Callback[] callbacks = new Callback[]{nameCallback, passwordCallback};
        try {
            this.handler.handle(callbacks);
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new LoginException("Error handling callback: " + e.getMessage());
        }
        String username = nameCallback.getName();
        this.principal = new NamePrincipal(username);
        char[] password = passwordCallback.getPassword();
        char[] storedPassword = this.usersMap.get(username);
        return Arrays.equals(storedPassword, password);
    }

    @Override
    public boolean commit() throws LoginException {
        this.subject.getPrincipals().add(this.principal);
        TestGroup group = new TestGroup("CallerPrincipal");
        group.addMember((Principal)new NamePrincipal("auth-caller"));
        this.subject.getPrincipals().add((Principal)((Object)group));
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().clear();
        return true;
    }

    private class TestGroup
    implements Group {
        private String name;
        private HashSet<Principal> principals;

        public TestGroup(String name) {
            this.name = name;
            this.principals = new HashSet();
        }

        public String getName() {
            return this.name;
        }

        public boolean addMember(Principal user) {
            return this.principals.add(user);
        }

        public boolean removeMember(Principal user) {
            return this.principals.remove(user);
        }

        public boolean isMember(Principal member) {
            return this.principals.contains(member);
        }

        public Enumeration<? extends Principal> members() {
            return Collections.enumeration(this.principals);
        }
    }
}

