/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.plain;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.ClientUtils;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.sasl.SaslMechanismSelector;
import org.wildfly.security.sasl.plain.PlainSaslServer;
import org.wildfly.security.sasl.plain.PlainSaslServerFactory;
import org.wildfly.security.sasl.plain.WildFlyElytronSaslPlainProvider;
import org.wildfly.security.sasl.test.SaslServerBuilder;
import org.wildfly.security.sasl.test.SaslTestUtil;

public class PlainTest {
    private static final String PLAIN = "PLAIN";
    private static final Provider[] providers = new Provider[]{WildFlyElytronSaslPlainProvider.getInstance(), WildFlyElytronPasswordProvider.getInstance()};

    @BeforeClass
    public static void registerProvider() {
        for (Provider provider : providers) {
            Security.insertProviderAt(provider, 1);
        }
    }

    @AfterClass
    public static void removeProvider() {
        for (Provider provider : providers) {
            Security.removeProvider(provider.getName());
        }
    }

    @Test
    public void testPolicyIndirect() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        SaslServer server = Sasl.createSaslServer(PLAIN, "TestProtocol", "TestServer", props, null);
        Assert.assertEquals(PlainSaslServer.class, server.getClass());
        props.put("javax.security.sasl.policy.noplaintext", Boolean.toString(true));
        server = Sasl.createSaslServer(PLAIN, "TestProtocol", "TestServer", props, null);
        Assert.assertNull((Object)server);
    }

    @Test
    public void testPolicyDirect() {
        SaslServerFactory factory = SaslTestUtil.obtainSaslServerFactory(PlainSaslServerFactory.class);
        Assert.assertNotNull((String)"SaslServerFactory not registered", (Object)factory);
        HashMap<String, String> props = new HashMap<String, String>();
        String[] mechanisms = factory.getMechanismNames(props);
        SaslTestUtil.assertSingleMechanism((String)PLAIN, (String[])mechanisms);
        props.put("javax.security.sasl.policy.noplaintext", Boolean.toString(true));
        mechanisms = factory.getMechanismNames(props);
        SaslTestUtil.assertNoMechanisms((String[])mechanisms);
    }

    @Test
    public void testSuccessfulExchange() throws Exception {
        SaslServer server = this.createSaslServer("George", "gpwd".toCharArray());
        CallbackHandler clientCallback = this.createClientCallbackHandler("George", "gpwd".toCharArray());
        SaslClient client = Sasl.createSaslClient(new String[]{PLAIN}, "George", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        Assert.assertFalse((boolean)server.isComplete());
        Assert.assertFalse((boolean)client.isComplete());
        Assert.assertTrue((boolean)client.hasInitialResponse());
        byte[] message = client.evaluateChallenge(new byte[0]);
        Assert.assertEquals((Object)"George\u0000George\u0000gpwd", (Object)new String(message, StandardCharsets.UTF_8));
        server.evaluateResponse(message);
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertTrue((boolean)client.isComplete());
        Assert.assertEquals((Object)"George", (Object)server.getAuthorizationID());
    }

    @Test
    public void testBadPassword() throws Exception {
        SaslServer server = this.createSaslServer("George", "gpwd".toCharArray());
        CallbackHandler clientCallback = this.createClientCallbackHandler("George", "bad".toCharArray());
        SaslClient client = Sasl.createSaslClient(new String[]{PLAIN}, "George", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        Assert.assertFalse((boolean)server.isComplete());
        Assert.assertFalse((boolean)client.isComplete());
        Assert.assertTrue((boolean)client.hasInitialResponse());
        byte[] message = client.evaluateChallenge(new byte[0]);
        Assert.assertEquals((Object)"George\u0000George\u0000bad", (Object)new String(message, StandardCharsets.UTF_8));
        try {
            server.evaluateResponse(message);
            Assert.fail((String)"Expection exception not thrown.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertTrue((boolean)client.isComplete());
    }

    @Test
    public void testBadUsername() throws Exception {
        SaslServer server = this.createSaslServer("Borris", "gpwd".toCharArray());
        CallbackHandler clientCallback = this.createClientCallbackHandler("George", "gpwd".toCharArray());
        SaslClient client = Sasl.createSaslClient(new String[]{PLAIN}, "George", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        Assert.assertFalse((boolean)server.isComplete());
        Assert.assertFalse((boolean)client.isComplete());
        Assert.assertTrue((boolean)client.hasInitialResponse());
        byte[] message = client.evaluateChallenge(new byte[0]);
        Assert.assertEquals((Object)"George\u0000George\u0000gpwd", (Object)new String(message, StandardCharsets.UTF_8));
        try {
            server.evaluateResponse(message);
            Assert.fail((String)"Expection exception not thrown.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertTrue((boolean)client.isComplete());
    }

    @Test
    public void testSuccessfulExchange_NoAuthorization() throws Exception {
        SaslServer server = this.createSaslServer("George", "gpwd".toCharArray());
        CallbackHandler clientCallback = this.createClientCallbackHandler("George", "gpwd".toCharArray());
        SaslClient client = Sasl.createSaslClient(new String[]{PLAIN}, null, "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        Assert.assertFalse((boolean)server.isComplete());
        Assert.assertFalse((boolean)client.isComplete());
        Assert.assertTrue((boolean)client.hasInitialResponse());
        byte[] message = client.evaluateChallenge(new byte[0]);
        Assert.assertEquals((Object)"\u0000George\u0000gpwd", (Object)new String(message, StandardCharsets.UTF_8));
        server.evaluateResponse(message);
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertTrue((boolean)client.isComplete());
        Assert.assertEquals((Object)"George", (Object)server.getAuthorizationID());
    }

    @Test
    public void testSuccessfulExchange_DifferentAuthorizationID() throws Exception {
        SaslServer server = this.createSaslServer("George", "gpwd".toCharArray());
        CallbackHandler clientCallback = this.createClientCallbackHandler("George", "gpwd".toCharArray());
        SaslClient client = Sasl.createSaslClient(new String[]{PLAIN}, "Borris", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        Assert.assertFalse((boolean)server.isComplete());
        Assert.assertFalse((boolean)client.isComplete());
        Assert.assertTrue((boolean)client.hasInitialResponse());
        byte[] message = client.evaluateChallenge(new byte[0]);
        Assert.assertEquals((Object)"Borris\u0000George\u0000gpwd", (Object)new String(message, StandardCharsets.UTF_8));
        try {
            server.evaluateResponse(message);
            Assert.fail((String)"Exception not thrown.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertTrue((boolean)client.isComplete());
    }

    @Test
    public void testSuccessfulExchange_NoNormalization() throws Exception {
        String username = "George\u00a8";
        String password = "password\u00a8";
        SaslServer server = this.createSaslServer(username, password.toCharArray());
        CallbackHandler clientCallback = this.createClientCallbackHandler(username, password.toCharArray());
        SaslClient client = Sasl.createSaslClient(new String[]{PLAIN}, username, "TestProtocol", "TestServer", Collections.singletonMap("org.wildfly.sasl.skip-normalization", "true"), clientCallback);
        Assert.assertFalse((boolean)server.isComplete());
        Assert.assertFalse((boolean)client.isComplete());
        Assert.assertTrue((boolean)client.hasInitialResponse());
        byte[] message = client.evaluateChallenge(new byte[0]);
        Assert.assertEquals((Object)(username + "\u0000" + username + "\u0000" + password), (Object)new String(message, StandardCharsets.UTF_8));
        server.evaluateResponse(message);
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertTrue((boolean)client.isComplete());
        Assert.assertEquals((Object)username, (Object)server.getAuthorizationID());
    }

    @Test
    public void testMaximumLength() throws Exception {
        SaslServer server = this.createSaslServer("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb".toCharArray());
        CallbackHandler clientCallback = this.createClientCallbackHandler("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb".toCharArray());
        SaslClient client = Sasl.createSaslClient(new String[]{PLAIN}, "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        Assert.assertFalse((boolean)server.isComplete());
        Assert.assertFalse((boolean)client.isComplete());
        Assert.assertTrue((boolean)client.hasInitialResponse());
        byte[] message = client.evaluateChallenge(new byte[0]);
        Assert.assertEquals((Object)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\u0000aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\u0000bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb", (Object)new String(message, StandardCharsets.UTF_8));
        server.evaluateResponse(message);
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertTrue((boolean)client.isComplete());
        Assert.assertEquals((Object)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", (Object)server.getAuthorizationID());
    }

    private SaslServer createSaslServer(String expectedUsername, char[] expectedPassword) throws Exception {
        return new SaslServerBuilder(PlainSaslServerFactory.class, PLAIN).setUserName(expectedUsername).setPassword(expectedPassword).build();
    }

    private CallbackHandler createClientCallbackHandler(String username, char[] password) throws Exception {
        AuthenticationContext context = AuthenticationContext.empty().with(MatchRule.ALL, AuthenticationConfiguration.empty().useName(username).usePassword(password).setSaslMechanismSelector(SaslMechanismSelector.NONE.addMechanism(PLAIN)));
        return ClientUtils.getCallbackHandler(new URI("doesnot://matter?"), context);
    }
}

