/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.test;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Principal;
import java.security.Provider;
import java.security.spec.KeySpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import javax.sql.DataSource;
import org.hsqldb.jdbc.JDBCDataSource;
import org.junit.Assert;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.realm.LegacyPropertiesSecurityRealm;
import org.wildfly.security.auth.realm.SimpleMapBackedSecurityRealm;
import org.wildfly.security.auth.realm.SimpleRealmEntry;
import org.wildfly.security.auth.realm.jdbc.ColumnMapper;
import org.wildfly.security.auth.realm.jdbc.JdbcSecurityRealm;
import org.wildfly.security.auth.realm.jdbc.mapper.PasswordKeyMapper;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.MechanismRealmConfiguration;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.sasl.SaslAuthenticationFactory;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.Encoding;
import org.wildfly.security.permission.PermissionVerifier;
import org.wildfly.security.sasl.test.SaslTestUtil;
import org.wildfly.security.sasl.util.AvailableRealmsSaslServerFactory;
import org.wildfly.security.sasl.util.ChannelBindingSaslServerFactory;
import org.wildfly.security.sasl.util.CredentialSaslServerFactory;
import org.wildfly.security.sasl.util.KeyManagerCredentialSaslServerFactory;
import org.wildfly.security.sasl.util.PropertiesSaslServerFactory;
import org.wildfly.security.sasl.util.ProtocolSaslServerFactory;
import org.wildfly.security.sasl.util.SecurityProviderSaslServerFactory;
import org.wildfly.security.sasl.util.ServerNameSaslServerFactory;
import org.wildfly.security.sasl.util.TrustManagerSaslServerFactory;

public class SaslServerBuilder {
    public static final String DEFAULT_REALM_NAME = "mainRealm";
    private final Class<? extends SaslServerFactory> serverFactoryClass;
    private final String mechanismName;
    private String username;
    private Password password = NULL_PASSWORD;
    private String realmName;
    private String defaultRealmName = this.realmName = "mainRealm";
    private boolean modifiableRealm;
    private InputStream legacyInputStream;
    private boolean plainText;
    private String principalQuery;
    private JDBCDataSource dataSource;
    private String mapperAlgorithm;
    private Map<String, Permissions> permissionsMap = null;
    private Map<String, SimpleRealmEntry> passwordMap;
    private Map<String, SecurityRealm> realms = new HashMap<String, SecurityRealm>();
    private Map<String, MechanismRealmConfiguration> mechanismRealms = new LinkedHashMap<String, MechanismRealmConfiguration>();
    private Encoding hashEncoding = Encoding.BASE64;
    private Charset hashCharset = StandardCharsets.UTF_8;
    private Map<String, Object> properties;
    private Tuple<String, byte[]> bindingTypeAndData;
    private String protocol;
    private String serverName;
    private X509TrustManager trustManager;
    private X509KeyManager keyManager;
    private Credential credential;
    private boolean dontAssertBuiltServer;
    private SecurityDomain securityDomain;
    private BuilderReference<Closeable> closeableReference;
    private BuilderReference<SecurityDomain> securityDomainReference;
    private ScheduledExecutorService scheduledExecutorService;
    private Supplier<Provider[]> providerSupplier;
    private static Password NULL_PASSWORD = new Password(){

        public String getAlgorithm() {
            return null;
        }

        public String getFormat() {
            return null;
        }

        public byte[] getEncoded() {
            return new byte[0];
        }

        public Password clone() {
            return this;
        }
    };

    public SaslServerBuilder(Class<? extends SaslServerFactory> serverFactoryClass, String mechanismName) {
        this.serverFactoryClass = serverFactoryClass;
        this.mechanismName = mechanismName;
    }

    public SaslServerBuilder copy(boolean keepDomain) {
        if (this.securityDomain == null && keepDomain) {
            throw new IllegalStateException("Can only copy a built server when keeping domain");
        }
        SaslServerBuilder copy = new SaslServerBuilder(this.serverFactoryClass, this.mechanismName);
        copy.username = this.username;
        copy.password = this.password;
        copy.realmName = this.realmName;
        copy.defaultRealmName = this.defaultRealmName;
        copy.modifiableRealm = this.modifiableRealm;
        copy.legacyInputStream = this.legacyInputStream;
        copy.plainText = this.plainText;
        copy.principalQuery = this.principalQuery;
        copy.dataSource = this.dataSource;
        copy.mapperAlgorithm = this.mapperAlgorithm;
        copy.hashEncoding = this.hashEncoding;
        copy.hashCharset = this.hashCharset;
        if (this.permissionsMap != null) {
            copy.permissionsMap = new HashMap<String, Permissions>(this.permissionsMap);
        }
        if (this.properties != null) {
            copy.properties = new HashMap<String, Object>(this.properties);
        }
        copy.bindingTypeAndData = this.bindingTypeAndData;
        copy.protocol = this.protocol;
        copy.serverName = this.serverName;
        copy.dontAssertBuiltServer = this.dontAssertBuiltServer;
        if (keepDomain) {
            copy.securityDomain = this.securityDomain;
        }
        return copy;
    }

    public SaslServerBuilder setUserName(String username) {
        this.username = username;
        return this;
    }

    public SaslServerBuilder setPassword(char[] password) throws Exception {
        Assert.assertNotNull((Object)password);
        this.setPassword("clear", (KeySpec)new ClearPasswordSpec(password));
        return this;
    }

    public SaslServerBuilder setPassword(String algorithm, KeySpec keySpec) throws Exception {
        Assert.assertNotNull((Object)algorithm);
        Assert.assertNotNull((Object)this.password);
        PasswordFactory factory = this.providerSupplier != null ? PasswordFactory.getInstance((String)algorithm, this.providerSupplier) : PasswordFactory.getInstance((String)algorithm);
        return this.setPassword(factory.generatePassword(keySpec));
    }

    public SaslServerBuilder setPassword(Password password) {
        Assert.assertNotNull((Object)this.password);
        this.password = password;
        return this;
    }

    public SaslServerBuilder setPasswordInstanceMap(Map<String, Password> passwordMap) {
        Assert.assertNotNull(passwordMap);
        this.passwordMap = new HashMap<String, SimpleRealmEntry>(passwordMap.size());
        passwordMap.forEach((userName, password) -> {
            if (password == null) {
                password = NULL_PASSWORD;
            }
            this.passwordMap.put((String)userName, new SimpleRealmEntry(Collections.singletonList(new PasswordCredential(password))));
        });
        return this;
    }

    public SaslServerBuilder setPasswordMap(Map<String, String> passwordMap) throws Exception {
        Assert.assertNotNull(passwordMap);
        this.passwordMap = new HashMap<String, SimpleRealmEntry>(passwordMap.size());
        passwordMap.forEach((userName, passwordStr) -> {
            Password password;
            if (passwordStr == null) {
                password = NULL_PASSWORD;
            } else {
                try {
                    PasswordFactory factory = PasswordFactory.getInstance((String)"clear");
                    password = factory.generatePassword((KeySpec)new ClearPasswordSpec(passwordStr.toCharArray()));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            Assert.assertNotNull((Object)password);
            this.passwordMap.put((String)userName, new SimpleRealmEntry(Collections.singletonList(new PasswordCredential(password))));
        });
        return this;
    }

    public SaslServerBuilder setRealmName(String realmName) {
        Assert.assertNotNull((Object)realmName);
        this.realmName = realmName;
        return this;
    }

    public SaslServerBuilder setDefaultRealmName(String realmName) {
        this.defaultRealmName = realmName;
        return this;
    }

    public SaslServerBuilder setModifiableRealm() {
        this.modifiableRealm = true;
        return this;
    }

    public SaslServerBuilder setHashEncoding(Encoding hashEncoding) {
        Assert.assertNotNull((Object)hashEncoding);
        this.hashEncoding = hashEncoding;
        return this;
    }

    public SaslServerBuilder setHashCharset(Charset hashCharset) {
        Assert.assertNotNull((Object)hashCharset);
        this.hashCharset = hashCharset;
        return this;
    }

    public SaslServerBuilder setLegacyInputStream(InputStream legacyInputStream) {
        Assert.assertNotNull((Object)legacyInputStream);
        this.legacyInputStream = legacyInputStream;
        return this;
    }

    public SaslServerBuilder setPlainText(boolean plainText) {
        Assert.assertNotNull((Object)plainText);
        this.plainText = plainText;
        return this;
    }

    public SaslServerBuilder setPrincipalQuery(String principalQuery) {
        Assert.assertNotNull((Object)principalQuery);
        this.principalQuery = principalQuery;
        return this;
    }

    public SaslServerBuilder setDataSource(JDBCDataSource dataSource) {
        Assert.assertNotNull((Object)dataSource);
        this.dataSource = dataSource;
        return this;
    }

    public SaslServerBuilder setMapperAlgorithm(String algorithm) {
        Assert.assertNotNull((Object)algorithm);
        this.mapperAlgorithm = algorithm;
        return this;
    }

    public SaslServerBuilder setProperties(Map<String, Object> properties) {
        Assert.assertNotNull(properties);
        this.properties = properties;
        return this;
    }

    public SaslServerBuilder setPermissionsMap(Map<String, Permissions> permissionsMap) {
        Assert.assertNotNull(permissionsMap);
        this.permissionsMap = new HashMap<String, Permissions>(permissionsMap);
        return this;
    }

    public SaslServerBuilder setChannelBinding(String bindingType, byte[] bindingData) {
        Assert.assertNotNull((Object)bindingType);
        Assert.assertNotNull((Object)bindingData);
        this.bindingTypeAndData = new Tuple<String, byte[]>(bindingType, bindingData);
        return this;
    }

    public SaslServerBuilder setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public SaslServerBuilder setServerName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public SaslServerBuilder setTrustManager(X509TrustManager trustManager) {
        this.trustManager = trustManager;
        return this;
    }

    public SaslServerBuilder setKeyManager(X509KeyManager keyManager) {
        this.keyManager = keyManager;
        return this;
    }

    public SaslServerBuilder setCredential(Credential credential) {
        this.credential = credential;
        return this;
    }

    public SaslServerBuilder setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
        return this;
    }

    public SaslServerBuilder addRealm(String realmName, SecurityRealm securityRealm) {
        Assert.assertNotNull((Object)realmName);
        Assert.assertNotNull((Object)securityRealm);
        this.realms.put(realmName, securityRealm);
        return this;
    }

    public SaslServerBuilder addMechanismRealm(String realmName) {
        Assert.assertNotNull((String)"realmName", (Object)realmName);
        MechanismRealmConfiguration.Builder builder = MechanismRealmConfiguration.builder();
        builder.setRealmName(realmName);
        this.mechanismRealms.put(realmName, builder.build());
        return this;
    }

    public SaslServerBuilder setDontAssertBuiltServer() {
        this.dontAssertBuiltServer = true;
        return this;
    }

    public SaslServerBuilder registerCloseableReference(BuilderReference<Closeable> closeableReference) {
        this.closeableReference = closeableReference;
        return this;
    }

    public SaslServerBuilder registerSecurityDomainReference(BuilderReference<SecurityDomain> securityDomainReference) {
        this.securityDomainReference = securityDomainReference;
        return this;
    }

    public SaslServerBuilder setProviderSupplier(Supplier<Provider[]> providerSupplier) {
        Assert.assertNotNull((String)"providerSupplier", providerSupplier);
        this.providerSupplier = providerSupplier;
        return this;
    }

    public SaslServer build() throws IOException {
        SaslServerFactory factory;
        if (this.securityDomain == null) {
            this.securityDomain = this.createSecurityDomain(this.hashEncoding, this.hashCharset);
        }
        if (this.securityDomainReference != null) {
            ((BuilderReference)this.securityDomainReference).setReference(this.securityDomain);
        }
        if ((factory = SaslTestUtil.obtainSaslServerFactory(this.serverFactoryClass)) == null && this.providerSupplier != null) {
            factory = new SecurityProviderSaslServerFactory(this.providerSupplier);
        }
        if (this.properties != null && this.properties.size() > 0) {
            if (this.properties.containsKey("com.sun.security.sasl.digest.realm")) {
                factory = new AvailableRealmsSaslServerFactory(factory);
            }
            factory = new PropertiesSaslServerFactory(factory, this.properties);
        }
        if (this.bindingTypeAndData != null) {
            factory = new ChannelBindingSaslServerFactory(factory, (String)((Tuple)this.bindingTypeAndData).key, (byte[])((Tuple)this.bindingTypeAndData).value);
        }
        if (this.protocol != null) {
            factory = new ProtocolSaslServerFactory(factory, this.protocol);
        }
        if (this.serverName != null) {
            factory = new ServerNameSaslServerFactory(factory, this.serverName);
        }
        if (this.trustManager != null) {
            factory = new TrustManagerSaslServerFactory(factory, this.trustManager);
        }
        if (this.keyManager != null) {
            factory = new KeyManagerCredentialSaslServerFactory(factory, this.keyManager);
        }
        if (this.credential != null) {
            factory = new CredentialSaslServerFactory(factory, this.credential);
        }
        SaslAuthenticationFactory.Builder builder = SaslAuthenticationFactory.builder();
        builder.setFactory(factory);
        builder.setSecurityDomain(this.securityDomain);
        if (this.scheduledExecutorService != null) {
            builder.setScheduledExecutorService(this.scheduledExecutorService);
        }
        MechanismConfiguration.Builder mechBuilder = MechanismConfiguration.builder();
        for (MechanismRealmConfiguration realmConfiguration : this.mechanismRealms.values()) {
            mechBuilder.addMechanismRealm(realmConfiguration);
        }
        builder.setMechanismConfigurationSelector(MechanismConfigurationSelector.constantSelector((MechanismConfiguration)mechBuilder.build()));
        SaslServer server = (SaslServer)builder.build().createMechanism(this.mechanismName);
        if (!this.dontAssertBuiltServer) {
            Assert.assertNotNull((Object)server);
        }
        return server;
    }

    private SecurityDomain createSecurityDomain(Encoding hashEncoding, Charset hashCharset) throws IOException {
        SecurityDomain.Builder domainBuilder = SecurityDomain.builder();
        if (!this.modifiableRealm) {
            if (this.legacyInputStream != null) {
                LegacyPropertiesSecurityRealm mainRealm = LegacyPropertiesSecurityRealm.builder().setUsersStream(this.legacyInputStream).setHashCharset(hashCharset).setHashEncoding(hashEncoding).setPlainText(this.plainText).build();
                this.realms.put(this.realmName, (SecurityRealm)mainRealm);
                this.realms.forEach((name, securityRealm) -> domainBuilder.addRealm(name, securityRealm).build());
            } else if (this.principalQuery != null) {
                PasswordKeyMapper passwordKeyMapper = this.mapperAlgorithm.equals("bcrypt") || this.mapperAlgorithm.equals("scram-sha-256") ? PasswordKeyMapper.builder().setDefaultAlgorithm(this.mapperAlgorithm).setHashColumn(1).setHashEncoding(hashEncoding).setSaltColumn(2).setIterationCountColumn(3).build() : (this.mapperAlgorithm.equals("password-salt-digest-sha-512") ? PasswordKeyMapper.builder().setDefaultAlgorithm(this.mapperAlgorithm).setHashColumn(1).setHashEncoding(hashEncoding).setSaltColumn(2).build() : PasswordKeyMapper.builder().setDefaultAlgorithm(this.mapperAlgorithm).setHashColumn(1).setHashEncoding(hashEncoding).build());
                JdbcSecurityRealm mainRealm = JdbcSecurityRealm.builder().setHashCharset(hashCharset).principalQuery(this.principalQuery).withMapper(new ColumnMapper[]{passwordKeyMapper}).from((DataSource)this.dataSource).build();
                this.realms.put(this.realmName, (SecurityRealm)mainRealm);
                this.realms.forEach((name, securityRealm) -> domainBuilder.addRealm(name, securityRealm).build());
            } else {
                SimpleMapBackedSecurityRealm mainRealm = this.providerSupplier != null ? new SimpleMapBackedSecurityRealm(this.providerSupplier) : new SimpleMapBackedSecurityRealm();
                this.realms.put(this.realmName, (SecurityRealm)mainRealm);
                this.realms.forEach((name, securityRealm) -> domainBuilder.addRealm(name, securityRealm).build());
                if (this.passwordMap != null) {
                    mainRealm.setIdentityMap(this.passwordMap);
                } else if (this.username != null) {
                    mainRealm.setIdentityMap(Collections.singletonMap(this.username, new SimpleRealmEntry(Collections.singletonList(new PasswordCredential(this.password)), Attributes.EMPTY)));
                }
            }
        } else {
            final Path root = Paths.get(".", "target", "test-domains", String.valueOf(System.currentTimeMillis())).normalize();
            Files.createDirectories(root, new FileAttribute[0]);
            FileSystemSecurityRealm mainRealm = new FileSystemSecurityRealm(root, hashEncoding, hashCharset);
            this.realms.put(this.realmName, (SecurityRealm)mainRealm);
            this.realms.forEach((name, securityRealm) -> domainBuilder.addRealm(name, securityRealm).build());
            ModifiableRealmIdentity realmIdentity = mainRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal(this.username));
            realmIdentity.create();
            realmIdentity.setCredentials(Collections.singletonList(new PasswordCredential(this.password)));
            realmIdentity.dispose();
            if (this.closeableReference != null) {
                ((BuilderReference)this.closeableReference).setReference(new Closeable(){

                    @Override
                    public void close() throws IOException {
                        this.delete(root.getParent().toFile());
                    }

                    private void delete(File file) {
                        if (file.isDirectory()) {
                            for (File child : file.listFiles()) {
                                this.delete(child);
                            }
                        }
                        file.delete();
                    }
                });
            }
        }
        domainBuilder.setDefaultRealmName(this.defaultRealmName);
        if (this.permissionsMap == null) {
            this.permissionsMap = new HashMap<String, Permissions>();
        }
        domainBuilder.setPermissionMapper((permissionMappable, roles) -> {
            PermissionVerifier v = PermissionVerifier.from((Permission)new LoginPermission());
            Permissions permissions = this.permissionsMap.get(permissionMappable.getPrincipal().toString());
            return permissions == null ? v : v.or(PermissionVerifier.from((PermissionCollection)permissions));
        });
        return domainBuilder.build();
    }

    public static class BuilderReference<T> {
        private T ref;

        private void setReference(T ref) {
            this.ref = ref;
        }

        public T getReference() {
            return this.ref;
        }
    }

    private static class Tuple<K, V> {
        private final K key;
        private final V value;

        public Tuple(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

