/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth;

import java.security.Principal;
import javax.security.auth.callback.CallbackHandler;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.TestCallbackHandler;
import org.wildfly.security.auth.TestLoginModule2;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.JaasSecurityRealm;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.PublicKeyCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;

public class JaasSecurityRealmTest {
    @BeforeClass
    public static void beforeClass() {
        System.setProperty("java.security.auth.login.config", JaasSecurityRealmTest.class.getResource("jaas-login.config").toString());
    }

    @AfterClass
    public static void afterClass() {
        System.clearProperty("java.security.auth.login.config");
    }

    @Test
    public void testSmokeJaasSecurityRealm() throws Exception {
        JaasSecurityRealm realm = new JaasSecurityRealm("Entry1");
        RealmIdentity realmIdentity = realm.getRealmIdentity((Principal)new NamePrincipal("elytron"));
        Assert.assertNotNull((String)"Unexpected null realm identity", (Object)realmIdentity);
        Assert.assertEquals((String)"Invalid credential support", (Object)SupportLevel.UNSUPPORTED, (Object)realmIdentity.getCredentialAcquireSupport(PasswordCredential.class, "blah", null));
        Assert.assertEquals((String)"Invalid credential support", (Object)SupportLevel.UNSUPPORTED, (Object)realmIdentity.getCredentialAcquireSupport(PublicKeyCredential.class, null, null));
        Assert.assertEquals((String)"Invalid credential support", (Object)SupportLevel.POSSIBLY_SUPPORTED, (Object)realmIdentity.getEvidenceVerifySupport(PasswordGuessEvidence.class, "blah"));
        Assert.assertNull((String)"Invalid non null credential", (Object)realmIdentity.getCredential(PasswordCredential.class, null));
        Assert.assertTrue((boolean)realmIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("passwd12#$".toCharArray())));
        Assert.assertFalse((boolean)realmIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("wrongpass".toCharArray())));
        Assert.assertTrue((boolean)realmIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("passwd12#$".toCharArray())));
        Assert.assertNotNull((String)"Unexpected null authenticated realm identity", (Object)realmIdentity.getAuthorizationIdentity());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEntryCannotBeNull() {
        new JaasSecurityRealm(null);
    }

    @Test(expected=RealmUnavailableException.class)
    public void testPathMustExist() throws RealmUnavailableException {
        JaasSecurityRealm realm = new JaasSecurityRealm("entry", "this/path/does/not/exist");
        RealmIdentity realmIdentity = realm.getRealmIdentity((Principal)new NamePrincipal("javajoe"));
        realmIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("$#21pass".toCharArray()));
    }

    @Test
    public void testJaasSecurityRealmWithCustomCallbackHandler() throws Exception {
        JaasSecurityRealm realm = new JaasSecurityRealm("Entry1", null, null, (CallbackHandler)new TestCallbackHandler());
        RealmIdentity realmIdentity = realm.getRealmIdentity((Principal)new NamePrincipal("javajoe"));
        Assert.assertTrue((boolean)realmIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("$#21pass".toCharArray())));
        Assert.assertFalse((boolean)realmIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("wrongpass".toCharArray())));
    }

    @Test
    public void testJaasSecurityRealmWithEntry2() throws Exception {
        JaasSecurityRealm realm = new JaasSecurityRealm("Entry2", null, null, (CallbackHandler)new TestCallbackHandler());
        RealmIdentity realmIdentity = realm.getRealmIdentity((Principal)new NamePrincipal("javajoe"));
        Assert.assertFalse((boolean)realmIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("$#21pass".toCharArray())));
        Assert.assertFalse((boolean)realmIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("wrongpass".toCharArray())));
        realmIdentity = realm.getRealmIdentity((Principal)new NamePrincipal("userFromTestModule2"));
        Assert.assertFalse((boolean)realmIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("$#21pass".toCharArray())));
        Assert.assertTrue((boolean)realmIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("userPassword".toCharArray())));
    }

    @Test
    public void testJaasSecurityRealmWithConfiguredPathToJAASConfigFile() throws Exception {
        JaasSecurityRealm realm = new JaasSecurityRealm("Entry1", "./src/test/resources/org/wildfly/security/auth/jaas-login2.config", null);
        RealmIdentity realmIdentity = realm.getRealmIdentity((Principal)new NamePrincipal("javajoe"));
        Assert.assertFalse((boolean)realmIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("$#21pass".toCharArray())));
        realmIdentity = realm.getRealmIdentity((Principal)new NamePrincipal("userFromTestModule2"));
        Assert.assertFalse((boolean)realmIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("wrongpass".toCharArray())));
        Assert.assertTrue((boolean)realmIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("userPassword".toCharArray())));
        SecurityDomain securityDomain = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)realm).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).build();
        ServerAuthenticationContext sac1 = securityDomain.createNewAuthenticationContext();
        sac1.setAuthenticationName("userFromTestModule2");
        Assert.assertFalse((boolean)sac1.verifyEvidence((Evidence)new PasswordGuessEvidence("incorrectPassword".toCharArray())));
        Assert.assertTrue((boolean)sac1.verifyEvidence((Evidence)new PasswordGuessEvidence("userPassword".toCharArray())));
        Assert.assertTrue((boolean)sac1.authorize());
        Assert.assertTrue((boolean)sac1.exists());
    }

    @Test
    public void testJaasAuthorizationIdentityRoles() throws Exception {
        JaasSecurityRealm realm = new JaasSecurityRealm("Entry1", null, null, (CallbackHandler)new TestCallbackHandler());
        SecurityDomain securityDomain = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)realm).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).build();
        ServerAuthenticationContext sac1 = securityDomain.createNewAuthenticationContext();
        sac1.setAuthenticationPrincipal((Principal)new NamePrincipal("javajoe"));
        Assert.assertTrue((boolean)sac1.verifyEvidence((Evidence)new PasswordGuessEvidence("$#21pass".toCharArray())));
        Assert.assertTrue((boolean)sac1.authorize());
        Assert.assertTrue((boolean)sac1.exists());
        Assert.assertTrue((boolean)sac1.getAuthorizedIdentity().getRoles().contains("Admin"));
        Assert.assertTrue((boolean)sac1.getAuthorizedIdentity().getRoles().contains("User"));
        Assert.assertTrue((boolean)sac1.getAuthorizedIdentity().getRoles().contains("Guest"));
        Assert.assertFalse((boolean)sac1.getAuthorizedIdentity().getRoles().contains("Non_existent_role"));
    }

    @Test
    public void testJaasRealmAttributes() throws Exception {
        JaasSecurityRealm realm = new JaasSecurityRealm("Entry1", null, null, (CallbackHandler)new TestCallbackHandler());
        SecurityDomain securityDomain = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)realm).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).build();
        ServerAuthenticationContext sac1 = securityDomain.createNewAuthenticationContext();
        sac1.setAuthenticationPrincipal((Principal)new NamePrincipal("javajoe"));
        Assert.assertTrue((boolean)sac1.verifyEvidence((Evidence)new PasswordGuessEvidence("$#21pass".toCharArray())));
        Assert.assertTrue((boolean)sac1.authorize());
        Assert.assertTrue((boolean)sac1.exists());
        Assert.assertTrue((boolean)sac1.getAuthorizedIdentity().getAttributes().containsKey("NamePrincipal"));
        Assert.assertEquals((Object)"whoami", (Object)sac1.getAuthorizedIdentity().getAttributes().get("NamePrincipal").get(0));
        Assert.assertEquals((Object)"anonymous", (Object)sac1.getAuthorizedIdentity().getAttributes().get("AnonymousPrincipal").get(0));
        Assert.assertNotEquals((Object)"non_existent_attribute", (Object)sac1.getAuthorizedIdentity().getAttributes().get("NamePrincipal").get(0));
        Assert.assertNotEquals((Object)"whoami", (Object)sac1.getAuthorizedIdentity().getAttributes().get("NonExistentAttributeKey").get(0));
        Assert.assertEquals((Object)"Admin", (Object)sac1.getAuthorizedIdentity().getAttributes().get("Roles").get(0));
        Assert.assertEquals((Object)"User", (Object)sac1.getAuthorizedIdentity().getAttributes().get("Roles").get(1));
        Assert.assertEquals((Object)"Guest", (Object)sac1.getAuthorizedIdentity().getAttributes().get("Roles").get(2));
    }

    @Test
    public void testJaasRealmWithProvidedClassLoader() throws Exception {
        JaasSecurityRealm realm = new JaasSecurityRealm("Entry1", null, TestLoginModule2.class.getClassLoader());
        SecurityDomain domainWithRewriter = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)realm).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).build();
        ServerAuthenticationContext sac1 = domainWithRewriter.createNewAuthenticationContext();
        sac1.setAuthenticationPrincipal((Principal)new NamePrincipal("javajoe"));
        Assert.assertTrue((boolean)sac1.verifyEvidence((Evidence)new PasswordGuessEvidence("$#21pass".toCharArray())));
        Assert.assertTrue((boolean)sac1.authorize());
        Assert.assertTrue((boolean)sac1.exists());
        Assert.assertTrue((boolean)sac1.getAuthorizedIdentity().getAttributes().containsKey("NamePrincipal"));
        Assert.assertEquals((Object)"whoami", (Object)sac1.getAuthorizedIdentity().getAttributes().get("NamePrincipal").get(0));
        Assert.assertEquals((Object)"anonymous", (Object)sac1.getAuthorizedIdentity().getAttributes().get("AnonymousPrincipal").get(0));
        Assert.assertNotEquals((Object)"non_existent_attribute", (Object)sac1.getAuthorizedIdentity().getAttributes().get("NamePrincipal").get(0));
        Assert.assertNotEquals((Object)"whoami", (Object)sac1.getAuthorizedIdentity().getAttributes().get("NonExistentAttributeKey").get(0));
        Assert.assertEquals((Object)"Admin", (Object)sac1.getAuthorizedIdentity().getAttributes().get("Roles").get(0));
        Assert.assertEquals((Object)"User", (Object)sac1.getAuthorizedIdentity().getAttributes().get("Roles").get(1));
        Assert.assertEquals((Object)"Guest", (Object)sac1.getAuthorizedIdentity().getAttributes().get("Roles").get(2));
    }
}

