/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.wildfly.security.auth.principal.AnonymousPrincipal;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.credential.BearerTokenCredential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.ClearPassword;

public class TestLoginModule
implements LoginModule {
    private final Map<String, char[]> usersMap = new HashMap<String, char[]>();
    private Subject subject;
    private CallbackHandler handler;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.handler = callbackHandler;
        this.usersMap.put("elytron", "passwd12#$".toCharArray());
        this.usersMap.put("javajoe", "$#21pass".toCharArray());
        this.usersMap.put("javaduke", "dukepass!@34".toCharArray());
    }

    @Override
    public boolean login() throws LoginException {
        NameCallback nameCallback = new NameCallback("Username");
        PasswordCallback passwordCallback = new PasswordCallback("Password", false);
        Callback[] callbacks = new Callback[]{nameCallback, passwordCallback};
        try {
            this.handler.handle(callbacks);
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new LoginException("Error handling callback: " + e.getMessage());
        }
        String username = nameCallback.getName();
        char[] password = passwordCallback.getPassword();
        char[] storedPassword = this.usersMap.get(username);
        return password != null && username != null && Arrays.equals(storedPassword, password);
    }

    @Override
    public boolean commit() throws LoginException {
        this.subject.getPrincipals().add((Principal)new NamePrincipal("whoami"));
        this.subject.getPrincipals().add((Principal)new AnonymousPrincipal());
        this.subject.getPrincipals().add(new Roles("Admin"));
        this.subject.getPrincipals().add(new Roles("User"));
        this.subject.getPrincipals().add(new Roles("Guest"));
        this.subject.getPrivateCredentials().add(new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])"myPrivatePassword".toCharArray())));
        this.subject.getPrivateCredentials().add(new BearerTokenCredential("myPrivateToken"));
        this.subject.getPublicCredentials().add(new BearerTokenCredential("myPublicToken"));
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().clear();
        return true;
    }

    private static class Roles
    implements Principal {
        private final String name;

        Roles(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

