/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.external;

import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import mockit.integration.junit4.JMockit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.external.WildFlyElytronHttpExternalProvider;
import org.wildfly.security.http.impl.AbstractBaseHttpTest;

@RunWith(value=JMockit.class)
public class ExternalAuthenticationMechanismTest
extends AbstractBaseHttpTest {
    private static final Provider provider = WildFlyElytronHttpExternalProvider.getInstance();

    @BeforeClass
    public static void registerProvider() {
        Security.insertProviderAt(provider, 1);
    }

    @AfterClass
    public static void removeProvider() {
        Security.removeProvider(provider.getName());
    }

    @Test
    public void testExternalAuthenticationMechanism() throws Exception {
        HttpServerAuthenticationMechanism mechanism = this.externalFactory.createAuthenticationMechanism("EXTERNAL", Collections.emptyMap(), this.getCallbackHandler("remoteUser", "testrealm@host.com", null));
        AbstractBaseHttpTest.TestingHttpServerRequest request1 = new AbstractBaseHttpTest.TestingHttpServerRequest(null);
        mechanism.evaluateRequest((HttpServerRequest)request1);
        Assert.assertEquals((Object)((Object)AbstractBaseHttpTest.Status.NO_AUTH), (Object)((Object)request1.getResult()));
        AbstractBaseHttpTest.TestingHttpServerRequest request2 = new AbstractBaseHttpTest.TestingHttpServerRequest(null);
        request2.setRemoteUser("wrongUser");
        mechanism.evaluateRequest((HttpServerRequest)request2);
        Assert.assertEquals((Object)((Object)AbstractBaseHttpTest.Status.FAILED), (Object)((Object)request2.getResult()));
        Assert.assertEquals((long)403L, (long)request2.getResponse().getStatusCode());
        AbstractBaseHttpTest.TestingHttpServerRequest request3 = new AbstractBaseHttpTest.TestingHttpServerRequest(null);
        request3.setRemoteUser("remoteUser");
        mechanism.evaluateRequest((HttpServerRequest)request3);
        Assert.assertEquals((Object)((Object)AbstractBaseHttpTest.Status.COMPLETE), (Object)((Object)request3.getResult()));
    }
}

