/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.store._private;

import java.io.IOException;
import java.io.Serializable;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.UnsupportedCredentialTypeException;
import org.wildfly.security.credential.store._private.ElytronMessages;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String unableToCreateKeyStore$str() {
        return "ELY02009: Unable to create a new KeyStore instance";
    }

    @Override
    public final IOException unableToCreateKeyStore(Exception cause) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.unableToCreateKeyStore$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String wrongTypeOfExternalStorageKey$str() {
        return "ELY09500: External storage key under alias \"%s\" has to be a SecretKey";
    }

    @Override
    public final CredentialStoreException wrongTypeOfExternalStorageKey(String keyAlias) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.wrongTypeOfExternalStorageKey$str(), keyAlias));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotAcquireCredentialFromStore$str() {
        return "ELY09504: Cannot acquire a credential from the credential store";
    }

    @Override
    public final CredentialStoreException cannotAcquireCredentialFromStore(Throwable cause) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.cannotAcquireCredentialFromStore$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nonModifiableCredentialStore$str() {
        return "ELY09505: Cannot perform operation '%s': Credential store is set non modifiable";
    }

    @Override
    public final CredentialStoreException nonModifiableCredentialStore(String operation) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.nonModifiableCredentialStore$str(), operation));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidProtectionParameter$str() {
        return "ELY09507: Invalid protection parameter given: %s";
    }

    @Override
    public final CredentialStoreException invalidProtectionParameter(CredentialStore.ProtectionParameter protectionParameter) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.invalidProtectionParameter$str(), protectionParameter));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotWriteCredentialToStore$str() {
        return "ELY09508: Cannot write credential to store";
    }

    @Override
    public final CredentialStoreException cannotWriteCredentialToStore(Throwable cause) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.cannotWriteCredentialToStore$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedCredentialType$str() {
        return "ELY09509: Unsupported credential type %s";
    }

    @Override
    public final UnsupportedCredentialTypeException unsupportedCredentialType(Class<?> type) {
        UnsupportedCredentialTypeException result = new UnsupportedCredentialTypeException(String.format(this.getLoggingLocale(), this.unsupportedCredentialType$str(), type));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidCredentialStoreEntryType$str() {
        return "ELY09510: Invalid credential store keystore entry %s: expected %s";
    }

    @Override
    public final CredentialStoreException invalidCredentialStoreEntryType(Class<? extends KeyStore.Entry> entryType, Class<? extends KeyStore.Entry> expectedType) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.invalidCredentialStoreEntryType$str(), entryType, expectedType));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToReadCredentialTypeFromStore$str() {
        return "ELY09511: Unable to read credential %s from store";
    }

    @Override
    public final CredentialStoreException unableToReadCredentialTypeFromStore(Class<? extends Credential> credentialType) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.unableToReadCredentialTypeFromStore$str(), credentialType));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotRemoveCredentialFromStore$str() {
        return "ELY09512: Unable to remove credential from store";
    }

    @Override
    public final CredentialStoreException cannotRemoveCredentialFromStore(Throwable cause) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.cannotRemoveCredentialFromStore$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotFlushCredentialStore$str() {
        return "ELY09513: Unable to flush credential store to storage";
    }

    @Override
    public final CredentialStoreException cannotFlushCredentialStore(Throwable cause) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.cannotFlushCredentialStore$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotInitializeCredentialStore$str() {
        return "ELY09514: Unable to initialize credential store";
    }

    @Override
    public final CredentialStoreException cannotInitializeCredentialStore(Throwable cause) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.cannotInitializeCredentialStore$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void logIgnoredUnrecognizedKeyStoreEntry(String alias) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.logIgnoredUnrecognizedKeyStoreEntry$str(), (Object)alias);
    }

    protected String logIgnoredUnrecognizedKeyStoreEntry$str() {
        return "ELY09515: Ignored unrecognized key store entry \"%s\"";
    }

    @Override
    public final void logFailedToReadKeyFromKeyStore(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.logFailedToReadKeyFromKeyStore$str(), new Object[0]);
    }

    protected String logFailedToReadKeyFromKeyStore$str() {
        return "ELY09516: Failed to read a credential entry from the key store";
    }

    protected String protectionParameterRequired$str() {
        return "ELY09517: This credential store type requires a store-wide protection parameter";
    }

    @Override
    public final CredentialStoreException protectionParameterRequired() {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.protectionParameterRequired$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String automaticStorageCreationDisabled$str() {
        return "ELY09518: Automatic storage creation for the Credential Store is disabled \"%s\"";
    }

    @Override
    public final CredentialStoreException automaticStorageCreationDisabled(String location) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.automaticStorageCreationDisabled$str(), location));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedFileVersion$str() {
        return "ELY09519: Unexpected credential store external storage file version \"%s\"";
    }

    @Override
    public final IOException unexpectedFileVersion(String version) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.unexpectedFileVersion$str(), version));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unrecognizedEntryType$str() {
        return "ELY09520: Unrecognized entry type \"%s\"";
    }

    @Override
    public final IOException unrecognizedEntryType(String entryType) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.unrecognizedEntryType$str(), entryType));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String internalEncryptionProblem$str() {
        return "ELY09521: Internal encryption problem while reading \"%s\"";
    }

    @Override
    public final IOException internalEncryptionProblem(Exception e, String location) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.internalEncryptionProblem$str(), location), e);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String algorithmNotBlockBased$str() {
        return "ELY09522: \"%s\" is not a block based algorithm";
    }

    @Override
    public final CredentialStoreException algorithmNotBlockBased(String algorithm) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.algorithmNotBlockBased$str(), algorithm));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String algorithmNotIV$str() {
        return "ELY09523: Algorithm \"%s\" does not use an initialization vector (IV)";
    }

    @Override
    public final CredentialStoreException algorithmNotIV(String algorithm) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.algorithmNotIV$str(), algorithm));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String readBytesMismatch$str() {
        return "ELY09524: The actual number of bytes read %d is different from the expected number of bytes %d to be read";
    }

    @Override
    public final IOException readBytesMismatch(int actual, int expected) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.readBytesMismatch$str(), actual, expected));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String locationAndExternalPathAreIdentical$str() {
        return "ELY09525: location and externalPath initial attributes are the same. [location=%s, externalPath=%s]";
    }

    @Override
    public final CredentialStoreException locationAndExternalPathAreIdentical(String location, String externalPath) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.locationAndExternalPathAreIdentical$str(), location, externalPath));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedAttribute$str() {
        return "ELY09526: Unable to initialize credential store as attribute %s is unsupported in %s";
    }

    @Override
    public final CredentialStoreException unsupportedAttribute(String attribute, List<String> validAttribute) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.unsupportedAttribute$str(), attribute, validAttribute));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String externalPathMissing$str() {
        return "ELY09528: The externalPath attribute for key store type %s is missing.";
    }

    @Override
    public final CredentialStoreException externalPathMissing(String keyStoreType) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.externalPathMissing$str(), keyStoreType));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String externalStorageKeyDoesNotExist$str() {
        return "ELY11006: External storage key under alias \"%s\" does not exist";
    }

    @Override
    public final CredentialStoreException externalStorageKeyDoesNotExist(String keyAlias) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.externalStorageKeyDoesNotExist$str(), keyAlias));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String credentialStoreFileDoesNotExist$str() {
        return "ELY12000: The credential store file %s does not exist or cannot be accessed.";
    }

    @Override
    public final CredentialStoreException credentialStoreFileDoesNotExist(String fileLocation) {
        CredentialStoreException result = new CredentialStoreException(String.format(this.getLoggingLocale(), this.credentialStoreFileDoesNotExist$str(), fileLocation));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

