/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.otp;

import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Locale;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.callback.CredentialUpdateCallback;
import org.wildfly.security.auth.callback.ExclusiveNameCallback;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.interfaces.OneTimePassword;
import org.wildfly.security.password.spec.OneTimePasswordSpec;
import org.wildfly.security.sasl.otp.OTPUtil;
import org.wildfly.security.sasl.util.AbstractSaslServer;
import org.wildfly.security.util.ByteStringBuilder;
import org.wildfly.security.util.CodePointIterator;

final class OTPSaslServer
extends AbstractSaslServer {
    private static final int ST_CHALLENGE = 1;
    private static final int ST_PROCESS_RESPONSE = 2;
    private String previousAlgorithm;
    private String previousSeed;
    private int previousSequenceNumber;
    private byte[] previousHash;
    private ExclusiveNameCallback exclusiveNameCallback;
    private String userName;
    private String authorizationID;

    OTPSaslServer(String mechanismName, String protocol, String serverName, CallbackHandler callbackHandler) {
        super(mechanismName, protocol, serverName, callbackHandler);
    }

    @Override
    public void init() {
        this.setNegotiationState(1);
    }

    @Override
    public String getAuthorizationID() {
        if (!this.isComplete()) {
            throw ElytronMessages.log.mechAuthenticationNotComplete(this.getMechanismName());
        }
        return this.authorizationID;
    }

    @Override
    protected byte[] evaluateMessage(int state, byte[] response) throws SaslException {
        switch (state) {
            case 1: {
                CodePointIterator cpi = CodePointIterator.ofUtf8Bytes(response);
                CodePointIterator di = cpi.delimitedBy(0);
                this.authorizationID = di.hasNext() ? di.drainToString() : null;
                cpi.next();
                this.userName = di.drainToString();
                OTPUtil.validateUserName(this.userName);
                if (this.authorizationID == null || this.authorizationID.isEmpty()) {
                    this.authorizationID = this.userName;
                }
                OTPUtil.validateAuthorizationId(this.authorizationID);
                this.exclusiveNameCallback = new ExclusiveNameCallback("Remote authentication name", this.userName, true, true);
                CredentialCallback credentialCallback = new CredentialCallback(PasswordCredential.class);
                this.handleCallbacks(this.exclusiveNameCallback, credentialCallback);
                if (!this.exclusiveNameCallback.hasExclusiveAccess()) {
                    throw ElytronMessages.log.mechUnableToObtainExclusiveAccess(this.getMechanismName(), this.userName).toSaslException();
                }
                OneTimePassword previousPassword = credentialCallback.applyToCredential(PasswordCredential.class, c -> c.getPassword().castAs(OneTimePassword.class));
                if (previousPassword == null) {
                    throw ElytronMessages.log.mechUnableToRetrievePassword(this.getMechanismName(), this.userName).toSaslException();
                }
                this.previousAlgorithm = previousPassword.getAlgorithm();
                OTPUtil.validateAlgorithm(this.previousAlgorithm);
                this.previousSeed = new String(previousPassword.getSeed(), StandardCharsets.US_ASCII);
                OTPUtil.validateSeed(this.previousSeed);
                this.previousSequenceNumber = previousPassword.getSequenceNumber();
                OTPUtil.validateSequenceNumber(this.previousSequenceNumber);
                this.previousHash = previousPassword.getHash();
                ByteStringBuilder challenge = new ByteStringBuilder();
                challenge.append(this.previousAlgorithm);
                challenge.append(' ');
                challenge.appendNumber(this.previousSequenceNumber - 1);
                challenge.append(' ');
                challenge.append(this.previousSeed);
                challenge.append(' ');
                challenge.append("ext");
                this.setNegotiationState(2);
                return challenge.toArray();
            }
            case 2: {
                String algorithm;
                OneTimePasswordSpec passwordSpec;
                byte[] currentHash;
                CodePointIterator cpi = CodePointIterator.ofUtf8Bytes(response);
                CodePointIterator di = cpi.delimitedBy(58);
                String responseType = di.drainToString().toLowerCase(Locale.ENGLISH);
                OTPUtil.skipDelims(di, cpi, 58);
                switch (responseType) {
                    case "hex": 
                    case "word": {
                        currentHash = responseType.equals("hex") ? OTPUtil.convertFromHex(di.drainToString()) : OTPUtil.convertFromWords(di.drainToString(), this.previousAlgorithm);
                        passwordSpec = new OneTimePasswordSpec(currentHash, this.previousSeed.getBytes(StandardCharsets.US_ASCII), this.previousSequenceNumber - 1);
                        algorithm = this.previousAlgorithm;
                        break;
                    }
                    case "init-hex": 
                    case "init-word": {
                        currentHash = responseType.equals("init-hex") ? OTPUtil.convertFromHex(di.drainToString()) : OTPUtil.convertFromWords(di.drainToString(), this.previousAlgorithm);
                        try {
                            OTPUtil.skipDelims(di, cpi, 58);
                            CodePointIterator si = di.delimitedBy(32);
                            String newAlgorithm = "otp-" + si.drainToString();
                            OTPUtil.validateAlgorithm(newAlgorithm);
                            OTPUtil.skipDelims(si, di, 32);
                            int newSequenceNumber = Integer.parseInt(si.drainToString());
                            OTPUtil.validateSequenceNumber(newSequenceNumber);
                            OTPUtil.skipDelims(si, di, 32);
                            String newSeed = si.drainToString();
                            OTPUtil.validateSeed(newSeed);
                            OTPUtil.skipDelims(di, cpi, 58);
                            byte[] newHash = responseType.equals("init-hex") ? OTPUtil.convertFromHex(di.drainToString()) : OTPUtil.convertFromWords(di.drainToString(), newAlgorithm);
                            passwordSpec = new OneTimePasswordSpec(newHash, newSeed.getBytes(StandardCharsets.US_ASCII), newSequenceNumber);
                            algorithm = newAlgorithm;
                            break;
                        }
                        catch (SaslException e) {
                            OneTimePasswordSpec passwordSpec2 = new OneTimePasswordSpec(currentHash, this.previousSeed.getBytes(StandardCharsets.US_ASCII), this.previousSequenceNumber - 1);
                            String algorithm2 = this.previousAlgorithm;
                            this.verifyAndUpdateCredential(currentHash, algorithm2, passwordSpec2);
                            throw ElytronMessages.log.mechOTPReinitializationFailed(e).toSaslException();
                        }
                    }
                    default: {
                        throw ElytronMessages.log.mechInvalidOTPResponseType().toSaslException();
                    }
                }
                if (cpi.hasNext()) {
                    throw ElytronMessages.log.mechInvalidMessageReceived(this.getMechanismName()).toSaslException();
                }
                this.verifyAndUpdateCredential(currentHash, algorithm, passwordSpec);
                if (this.authorizationID == null) {
                    this.authorizationID = this.userName;
                }
                AuthorizeCallback authorizeCallback = new AuthorizeCallback(this.userName, this.authorizationID);
                this.handleCallbacks(authorizeCallback);
                if (!authorizeCallback.isAuthorized()) {
                    throw ElytronMessages.log.mechAuthorizationFailed(this.getMechanismName(), this.userName, this.authorizationID).toSaslException();
                }
                this.negotiationComplete();
                return null;
            }
            case 0: {
                if (response != null && response.length != 0) {
                    throw ElytronMessages.log.mechMessageAfterComplete(this.getMechanismName()).toSaslException();
                }
                return null;
            }
        }
        throw Assert.impossibleSwitchCase((int)state);
    }

    @Override
    public void dispose() throws SaslException {
        this.previousHash = null;
        this.previousSeed = null;
    }

    private void verifyAndUpdateCredential(byte[] currentHash, String newAlgorithm, OneTimePasswordSpec newPasswordSpec) throws SaslException {
        if (!Arrays.equals(this.previousHash, OTPUtil.hashAndFold(this.previousAlgorithm, currentHash))) {
            throw ElytronMessages.log.mechPasswordNotVerified(this.getMechanismName()).toSaslException();
        }
        this.updateCredential(newAlgorithm, newPasswordSpec);
    }

    private void updateCredential(String newAlgorithm, OneTimePasswordSpec newPasswordSpec) throws SaslException {
        try {
            PasswordFactory passwordFactory = PasswordFactory.getInstance(newAlgorithm);
            OneTimePassword newPassword = (OneTimePassword)passwordFactory.generatePassword(newPasswordSpec);
            CredentialUpdateCallback credentialUpdateCallback = new CredentialUpdateCallback(new PasswordCredential(newPassword));
            this.handleCallbacks(this.exclusiveNameCallback, credentialUpdateCallback);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw ElytronMessages.log.mechUnableToUpdatePassword(this.getMechanismName(), this.userName).toSaslException();
        }
    }
}

