/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.SimpleRealmEntry;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.password.Password;

public class SimpleMapBackedSecurityRealm
implements SecurityRealm {
    private final Supplier<Provider[]> providers;
    private final NameRewriter rewriter;
    private volatile Map<String, SimpleRealmEntry> map = Collections.emptyMap();

    public SimpleMapBackedSecurityRealm(NameRewriter rewriter) {
        this(rewriter, Security::getProviders);
    }

    public SimpleMapBackedSecurityRealm(NameRewriter rewriter, Supplier<Provider[]> providers) {
        this.rewriter = (NameRewriter)Assert.checkNotNullParam((String)"rewriter", (Object)rewriter);
        this.providers = (Supplier)Assert.checkNotNullParam((String)"provider", providers);
    }

    public SimpleMapBackedSecurityRealm() {
        this(NameRewriter.IDENTITY_REWRITER);
    }

    public SimpleMapBackedSecurityRealm(Supplier<Provider[]> providers) {
        this(NameRewriter.IDENTITY_REWRITER, providers);
    }

    public void setPasswordMap(Map<String, SimpleRealmEntry> map) {
        Assert.checkNotNullParam((String)"map", map);
        this.map = map;
    }

    public void setPasswordMap(String name, Password password, Attributes attributes) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"password", (Object)password);
        Assert.checkNotNullParam((String)"attributes", (Object)attributes);
        this.map = Collections.singletonMap(name, new SimpleRealmEntry(Collections.singletonList(new PasswordCredential(password)), attributes));
    }

    public void setPasswordMap(String name, Password password) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"password", (Object)password);
        this.map = Collections.singletonMap(name, new SimpleRealmEntry(Collections.singletonList(new PasswordCredential(password))));
    }

    @Override
    public RealmIdentity getRealmIdentity(Principal principal) {
        if (!(principal instanceof NamePrincipal)) {
            return RealmIdentity.NON_EXISTENT;
        }
        String name = this.rewriter.rewriteName(principal.getName());
        if (name == null) {
            throw ElytronMessages.log.invalidName();
        }
        return new SimpleMapRealmIdentity(name);
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        return SupportLevel.POSSIBLY_SUPPORTED;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"evidenceType", evidenceType);
        return SupportLevel.POSSIBLY_SUPPORTED;
    }

    private class SimpleMapRealmIdentity
    implements RealmIdentity {
        private final String name;

        SimpleMapRealmIdentity(String name) {
            this.name = name;
        }

        @Override
        public Principal getRealmIdentityPrincipal() {
            return new NamePrincipal(this.name);
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            SimpleRealmEntry entry = (SimpleRealmEntry)SimpleMapBackedSecurityRealm.this.map.get(this.name);
            if (entry == null) {
                return SupportLevel.UNSUPPORTED;
            }
            for (Credential credential : entry.getCredentials()) {
                if (!credentialType.isInstance(credential) || algorithmName != null && (!(credential instanceof AlgorithmCredential) || !algorithmName.equals(((AlgorithmCredential)credential).getAlgorithm()))) continue;
                return SupportLevel.SUPPORTED;
            }
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return this.getCredential(credentialType, null);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            SimpleRealmEntry entry = (SimpleRealmEntry)SimpleMapBackedSecurityRealm.this.map.get(this.name);
            if (entry == null) {
                return null;
            }
            for (Credential credential : entry.getCredentials()) {
                if (!credentialType.isInstance(credential) || algorithmName != null && (!(credential instanceof AlgorithmCredential) || !algorithmName.equals(((AlgorithmCredential)credential).getAlgorithm()))) continue;
                return (C)((Credential)credentialType.cast(credential.clone()));
            }
            return null;
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() {
            SimpleRealmEntry entry = (SimpleRealmEntry)SimpleMapBackedSecurityRealm.this.map.get(this.name);
            return entry == null ? AuthorizationIdentity.EMPTY : AuthorizationIdentity.basicIdentity(entry.getAttributes());
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"evidenceType", evidenceType);
            SimpleRealmEntry entry = (SimpleRealmEntry)SimpleMapBackedSecurityRealm.this.map.get(this.name);
            if (entry == null) {
                return SupportLevel.UNSUPPORTED;
            }
            for (Credential credential : entry.getCredentials()) {
                if (!credential.canVerify(evidenceType, algorithmName)) continue;
                return SupportLevel.SUPPORTED;
            }
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"evidence", (Object)evidence);
            SimpleRealmEntry entry = (SimpleRealmEntry)SimpleMapBackedSecurityRealm.this.map.get(this.name);
            if (entry == null) {
                return false;
            }
            ElytronMessages.log.tracef("Trying to authenticate %s using SimpleMapBackedSecurityRealm.", this.name);
            for (Credential credential : entry.getCredentials()) {
                if (!credential.canVerify(evidence)) continue;
                return credential.verify(SimpleMapBackedSecurityRealm.this.providers, evidence);
            }
            return false;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return SimpleMapBackedSecurityRealm.this.map.containsKey(this.name);
        }
    }
}

