/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz.jacc;

import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.authz.jacc.ElytronPolicyConfiguration;
import org.wildfly.security.authz.jacc.ElytronPolicyConfigurationFactory;
import org.wildfly.security.authz.jacc.SecurityIdentityHandler;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JaccDelegatingPolicy
extends Policy {
    private static final PrivilegedAction<Policy> GET_POLICY_ACTION = Policy::getPolicy;
    private static final String ANY_AUTHENTICATED_USER_ROLE = "**";
    private final Policy delegate;
    private final Set<Class<? extends Permission>> supportedPermissionTypes = new HashSet<Class<? extends Permission>>();

    public JaccDelegatingPolicy() {
        this(WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(GET_POLICY_ACTION) : Policy.getPolicy());
    }

    public JaccDelegatingPolicy(Policy delegate) {
        this.delegate = (Policy)Assert.checkNotNullParam((String)"delegate", (Object)delegate);
        this.supportedPermissionTypes.add(WebResourcePermission.class);
        this.supportedPermissionTypes.add(WebRoleRefPermission.class);
        this.supportedPermissionTypes.add(WebUserDataPermission.class);
        this.supportedPermissionTypes.add(EJBMethodPermission.class);
        this.supportedPermissionTypes.add(EJBRoleRefPermission.class);
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        try {
            if (this.isJaccPermission(permission)) {
                ElytronPolicyConfiguration policyConfiguration = (ElytronPolicyConfiguration)ElytronPolicyConfigurationFactory.getCurrentPolicyConfiguration();
                if (this.impliesExcludedPermission(permission, policyConfiguration)) {
                    return false;
                }
                if (this.impliesUncheckedPermission(permission, policyConfiguration)) {
                    return true;
                }
                if (this.impliesRolePermission(domain, permission, policyConfiguration)) {
                    return true;
                }
            }
            if (this.impliesIdentityPermission(permission)) {
                return true;
            }
        }
        catch (Exception e) {
            ElytronMessages.log.authzFailedToCheckPermission(domain, permission, e);
        }
        return this.delegate.implies(domain, permission);
    }

    @Override
    public PermissionCollection getPermissions(final ProtectionDomain domain) {
        ElytronMessages.log.getPermissionsNotSupported();
        return new PermissionCollection(){

            @Override
            public void add(Permission permission) {
                throw ElytronMessages.log.readOnlyPermissionCollection();
            }

            @Override
            public boolean implies(Permission permission) {
                return JaccDelegatingPolicy.this.implies(domain, permission);
            }

            @Override
            public Enumeration<Permission> elements() {
                return JaccDelegatingPolicy.this.delegate.getPermissions(domain).elements();
            }
        };
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codeSource) {
        return codeSource == null ? Policy.UNSUPPORTED_EMPTY_COLLECTION : this.getPermissions(new ProtectionDomain(codeSource, null));
    }

    @Override
    public void refresh() {
        this.delegate.refresh();
    }

    private boolean impliesIdentityPermission(Permission permission) {
        SecurityIdentity actualIdentity = this.getCurrentSecurityIdentity();
        return actualIdentity != null && actualIdentity.implies(permission);
    }

    private SecurityIdentity getCurrentSecurityIdentity() {
        try {
            return (SecurityIdentity)PolicyContext.getContext((String)SecurityIdentityHandler.KEY);
        }
        catch (Exception cause) {
            ElytronMessages.log.authzCouldNotObtainSecurityIdentity(cause);
            return null;
        }
    }

    private void extractRolesFromCurrentIdentity(Set<String> roles) throws PolicyContextException, ClassNotFoundException {
        Roles identityRoles;
        SecurityIdentity identity = this.getCurrentSecurityIdentity();
        if (identity != null && (identityRoles = identity.getRoles()) != null) {
            for (String roleName : identityRoles) {
                roles.add(roleName);
            }
        }
    }

    private void extractRolesFromProtectionDomain(ProtectionDomain domain, Set<String> roles) {
        Principal[] domainPrincipals = domain.getPrincipals();
        if (domainPrincipals != null) {
            for (Principal principal : domainPrincipals) {
                roles.add(principal.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean impliesRolePermission(ProtectionDomain domain, Permission permission, ElytronPolicyConfiguration policyConfiguration) throws PolicyContextException, ClassNotFoundException {
        Map<String, Permissions> rolePermissions;
        HashSet<String> roles = new HashSet<String>();
        this.extractRolesFromProtectionDomain(domain, roles);
        this.extractRolesFromCurrentIdentity(roles);
        roles.add(ANY_AUTHENTICATED_USER_ROLE);
        Map<String, Permissions> map = rolePermissions = policyConfiguration.getRolePermissions();
        synchronized (map) {
            for (String roleName : roles) {
                Permissions permissions = rolePermissions.get(roleName);
                if (permissions == null || !permissions.implies(permission)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean impliesUncheckedPermission(Permission permission, ElytronPolicyConfiguration policyConfiguration) {
        Permissions uncheckedPermissions;
        Permissions permissions = uncheckedPermissions = policyConfiguration.getUncheckedPermissions();
        synchronized (permissions) {
            return uncheckedPermissions.implies(permission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean impliesExcludedPermission(Permission permission, ElytronPolicyConfiguration policyConfiguration) {
        Permissions excludedPermissions;
        Permissions permissions = excludedPermissions = policyConfiguration.getExcludedPermissions();
        synchronized (permissions) {
            return excludedPermissions.implies(permission);
        }
    }

    private boolean isJaccPermission(Permission permission) {
        return this.supportedPermissionTypes.contains(permission.getClass());
    }
}

