package org.wildfly.security.encryption;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.security.GeneralSecurityException;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-02-02T17:36:01+0100")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String badKeySize$str() {
        return "ELY19000: Invalid size value. Must be one of 128, 192, or 256";
    }
    @Override
    public final GeneralSecurityException badKeySize() {
        final GeneralSecurityException result = new GeneralSecurityException(String.format(getLoggingLocale(), badKeySize$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String badKeyPrefix$str() {
        return "ELY19001: Invalid prefix importing SecretKey";
    }
    @Override
    public final GeneralSecurityException badKeyPrefix() {
        final GeneralSecurityException result = new GeneralSecurityException(String.format(getLoggingLocale(), badKeyPrefix$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedVersion$str() {
        return "ELY19002: Unsupported version '%d' the maximum supported version is '%d'";
    }
    @Override
    public final GeneralSecurityException unsupportedVersion(final int discovered, final int maxSupported) {
        final GeneralSecurityException result = new GeneralSecurityException(String.format(getLoggingLocale(), unsupportedVersion$str(), discovered, maxSupported));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedTokenType$str() {
        return "ELY19003: Unexpected token type '%s', expected '%s'";
    }
    @Override
    public final GeneralSecurityException unexpectedTokenType(final String actual, final String expected) {
        final GeneralSecurityException result = new GeneralSecurityException(String.format(getLoggingLocale(), unexpectedTokenType$str(), actual, expected));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToDecodeBase64Token$str() {
        return "ELY19004: Unable to decode Base64 token.";
    }
    @Override
    public final GeneralSecurityException unableToDecodeBase64Token(final Throwable cause) {
        final GeneralSecurityException result = new GeneralSecurityException(String.format(getLoggingLocale(), unableToDecodeBase64Token$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
}
