package org.wildfly.security.auth.client._private;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import javax.xml.stream.XMLStreamReader;
import org.wildfly.client.config.XMLLocation;
import org.jboss.logging.DelegatingBasicLogger;
import javax.xml.namespace.QName;
import java.lang.String;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.jboss.logging.Logger;
import java.lang.Exception;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Class;
import java.util.Arrays;
import org.wildfly.client.config.ConfigurationXMLStreamReader;
import org.wildfly.client.config.ConfigXMLParseException;
import java.lang.IllegalArgumentException;
import javax.xml.stream.Location;


import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-09-13T14:34:07-0400")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String xmlNoModuleFound$str() {
        return "ELY01001: No module found for identifier \"%s\"";
    }
    @Override
    public final ConfigXMLParseException xmlNoModuleFound(final XMLStreamReader reader, final Exception e, final String moduleIdentifier) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlNoModuleFound$str(), moduleIdentifier), reader, e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String xmlInvalidPortNumber$str() {
        return "ELY01002: Invalid port number \"%s\" specified for attribute \"%s\" of element \"%s\"; expected a numerical value between 1 and 65535 (inclusive)";
    }
    @Override
    public final ConfigXMLParseException xmlInvalidPortNumber(final XMLStreamReader reader, final String attributeValue, final String attributeName, final QName elementName) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlInvalidPortNumber$str(), attributeValue, attributeName, elementName), reader);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPortNumber$str() {
        return "ELY01028: Invalid port number \"%d\"";
    }
    @Override
    public final IllegalArgumentException invalidPortNumber(final int port) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidPortNumber$str(), port));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidHostSpec$str() {
        return "ELY01029: Invalid host specification \"%s\"";
    }
    @Override
    public final IllegalArgumentException invalidHostSpec(final String hostSpec) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidHostSpec$str(), hostSpec));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCreateKeyManager$str() {
        return "ELY01035: Unable to create key manager";
    }
    @Override
    public final IOException unableToCreateKeyManager(final Exception e) {
        final IOException result = new IOException(String.format(getLoggingLocale(), unableToCreateKeyManager$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCreateTrustManager$str() {
        return "ELY01036: Unable to create trust manager";
    }
    @Override
    public final IOException unableToCreateTrustManager(final Exception e) {
        final IOException result = new IOException(String.format(getLoggingLocale(), unableToCreateTrustManager$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotObtainCredential$str() {
        return "ELY01041: Could not obtain credential";
    }
    @Override
    public final RuntimeException couldNotObtainCredential() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotObtainCredential$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidName$str() {
        return "ELY01064: Invalid identity name";
    }
    @Override
    public final IllegalArgumentException invalidName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidName$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void postAssociationFailed(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, postAssociationFailed$str());
    }
    protected String postAssociationFailed$str() {
        return "ELY01091: Post-association peer context action failed";
    }
    protected String xmlUnknownSslContextSpecified$str() {
        return "ELY01129: Unknown SSL context \"%s\" specified";
    }
    @Override
    public final ConfigXMLParseException xmlUnknownSslContextSpecified(final Location location, final String name) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlUnknownSslContextSpecified$str(), name), location);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String xmlDuplicateSslContextName$str() {
        return "ELY01130: Duplicate SSL context name \"%s\"";
    }
    @Override
    public final ConfigXMLParseException xmlDuplicateSslContextName(final String name, final ConfigurationXMLStreamReader reader) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlDuplicateSslContextName$str(), name), reader);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String xmlUnknownAuthenticationConfigurationSpecified$str() {
        return "ELY01132: Unknown authentication configuration \"%s\" specified";
    }
    @Override
    public final ConfigXMLParseException xmlUnknownAuthenticationConfigurationSpecified(final Location location, final String name) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlUnknownAuthenticationConfigurationSpecified$str(), name), location);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String xmlFailedToCreateCredential$str() {
        return "ELY01133: Failed to create credential";
    }
    @Override
    public final ConfigXMLParseException xmlFailedToCreateCredential(final Location location, final Throwable cause) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlFailedToCreateCredential$str()), location, cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String xmlDuplicateAuthenticationConfigurationName$str() {
        return "ELY01134: Duplicate authentication configuration name \"%s\"";
    }
    @Override
    public final ConfigXMLParseException xmlDuplicateAuthenticationConfigurationName(final String name, final ConfigurationXMLStreamReader reader) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlDuplicateAuthenticationConfigurationName$str(), name), reader);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String xmlFailedToLoadKeyStoreData$str() {
        return "ELY01135: Failed to load keystore data";
    }
    @Override
    public final ConfigXMLParseException xmlFailedToLoadKeyStoreData(final Location location, final Throwable cause) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlFailedToLoadKeyStoreData$str()), location, cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String xmlFailedToCreateKeyStore$str() {
        return "ELY01136: Failed to create keystore";
    }
    @Override
    public final ConfigXMLParseException xmlFailedToCreateKeyStore(final Location location, final Throwable cause) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlFailedToCreateKeyStore$str()), location, cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String xmlInvalidKeyStoreEntryType$str() {
        return "ELY01137: Invalid key store entry type for alias \"%s\" (expected %s, got %s)";
    }
    @Override
    public final ConfigXMLParseException xmlInvalidKeyStoreEntryType(final Location location, final String alias, final Class<?> expectedClass, final Class<?> actualClass) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlInvalidKeyStoreEntryType$str(), alias, expectedClass, actualClass), location);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String xmlFailedToCreateCredentialStore$str() {
        return "ELY01139: Failed to create credential store";
    }
    @Override
    public final ConfigXMLParseException xmlFailedToCreateCredentialStore(final Location location, final Throwable cause) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlFailedToCreateCredentialStore$str()), location, cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String xmlWrongPemType$str() {
        return "ELY01140: Wrong PEM content type; expected %s, actually was %s";
    }
    @Override
    public final ConfigXMLParseException xmlWrongPemType(final ConfigurationXMLStreamReader reader, final Class<?> expected, final Class<?> actual) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlWrongPemType$str(), expected, actual), reader);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String xmlNoPemContent$str() {
        return "ELY01141: No PEM content found";
    }
    @Override
    public final ConfigXMLParseException xmlNoPemContent(final ConfigurationXMLStreamReader reader) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlNoPemContent$str()), reader);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String xmlInvalidUrl$str() {
        return "ELY01143: Invalid URL [%s]";
    }
    @Override
    public final ConfigXMLParseException xmlInvalidUrl(final String url) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlInvalidUrl$str(), url));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String keyStoreEntryMissing$str() {
        return "ELY01159: Key store entry for alias \"%s\" is missing.";
    }
    @Override
    public final ConfigXMLParseException keyStoreEntryMissing(final Location location, final String alias) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), keyStoreEntryMissing$str(), alias), location);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String xmlInvalidGssMechanismName$str() {
        return "ELY01162: Invalid GSS mechanism name \"%s\" - unable to convert to mechanism OID";
    }
    @Override
    public final ConfigXMLParseException xmlInvalidGssMechanismName(final XMLStreamReader reader, final String mechanismName) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlInvalidGssMechanismName$str(), mechanismName), reader);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String xmlGssMechanismOidConversionFailed$str() {
        return "ELY01163: Mechanism OID conversion from string \"%s\" failed";
    }
    @Override
    public final ConfigXMLParseException xmlGssMechanismOidConversionFailed(final XMLStreamReader reader, final String mechanismOid, final Throwable cause) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlGssMechanismOidConversionFailed$str(), mechanismOid), reader, cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String xmlUnableToIdentifyProvider$str() {
        return "ELY01164: Unable to identify provider name=%s, for service type=%s, algorithm=%s";
    }
    @Override
    public final ConfigXMLParseException xmlUnableToIdentifyProvider(final Location location, final String providerName, final String serviceType, final String algorithm) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlUnableToIdentifyProvider$str(), providerName, serviceType, algorithm), location);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void xmlDeprecatedElement(final String name, final XMLLocation location) {
        super.log.logf(FQCN, WARN, null, xmlDeprecatedElement$str(), name, location);
    }
    protected String xmlDeprecatedElement$str() {
        return "ELY01166: %2$s: Element \"%1$s\" is deprecated";
    }
    protected String missingAlias$str() {
        return "ELY02034: Alias must be specified if more than one entry exist in keystore";
    }
    @Override
    public final ConfigXMLParseException missingAlias(final Location location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), missingAlias$str()), location);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String xmlUnknownKeyStoreSpecified$str() {
        return "ELY02010: Unknown key store specified";
    }
    @Override
    public final ConfigXMLParseException xmlUnknownKeyStoreSpecified(final Location location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlUnknownKeyStoreSpecified$str()), location);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noDefaultTrustManager$str() {
        return "ELY04005: No default trust manager available";
    }
    @Override
    public final NoSuchAlgorithmException noDefaultTrustManager() {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(getLoggingLocale(), noDefaultTrustManager$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noDefaultKeyManager$str() {
        return "ELY04028: No default key manager available";
    }
    @Override
    public final NoSuchAlgorithmException noDefaultKeyManager() {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(getLoggingLocale(), noDefaultKeyManager$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateAttributeFound$str() {
        return "ELY09501: Duplicate attribute (\"%s\") found in configuration.";
    }
    @Override
    public final ConfigXMLParseException duplicateAttributeFound(final XMLStreamReader reader, final String attribute) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), duplicateAttributeFound$str(), attribute), reader);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateCredentialStoreName$str() {
        return "ELY09502: Duplicate credential store name found in configuration \"%s\"";
    }
    @Override
    public final ConfigXMLParseException duplicateCredentialStoreName(final XMLStreamReader reader, final String storeName) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), duplicateCredentialStoreName$str(), storeName), reader);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String xmlCredentialStoreNameNotDefined$str() {
        return "ELY09503: Credential store name \"%s\" not defined";
    }
    @Override
    public final ConfigXMLParseException xmlCredentialStoreNameNotDefined(final Location location, final String storeName) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlCredentialStoreNameNotDefined$str(), storeName), location);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String xmlInvalidCredentialStoreRef$str() {
        return "ELY09527: Invalid credential store reference";
    }
    @Override
    public final ConfigXMLParseException xmlInvalidCredentialStoreRef(final Location location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlInvalidCredentialStoreRef$str()), location);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String xmlUnsupportedAlgorithmForType$str() {
        return "ELY09529: Unsupported algorithm \"%s\" for %s type";
    }
    @Override
    public final ConfigXMLParseException xmlUnsupportedAlgorithmForType(final Location location, final String algorithm, final String type) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlUnsupportedAlgorithmForType$str(), algorithm, type), location);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String atLeastOneCipherSuiteAttributeMustBeProvided$str() {
        return "ELY14000: At least one of the '%s' and '%s' cipher-suite attributes must be provided";
    }
    @Override
    public final ConfigXMLParseException atLeastOneCipherSuiteAttributeMustBeProvided(final String attribute1, final String attribute2) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), atLeastOneCipherSuiteAttributeMustBeProvided$str(), attribute1, attribute2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String xmlInvalidOpenSSHKey$str() {
        return "ELY14001: Wrong Key content type; expected OpenSSH private key";
    }
    @Override
    public final ConfigXMLParseException xmlInvalidOpenSSHKey(final ConfigurationXMLStreamReader reader) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), xmlInvalidOpenSSHKey$str()), reader);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToObtainSslContext$str() {
        return "ELY14002: Unable to obtain SSLContext";
    }
    @Override
    public final ConfigXMLParseException unableToObtainSslContext() {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), unableToObtainSslContext$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nameCallbackHandlingWasUnsuccessful$str() {
        return "ELY14003: Name callback handling was unsuccessful";
    }
    @Override
    public final ConfigXMLParseException nameCallbackHandlingWasUnsuccessful() {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), nameCallbackHandlingWasUnsuccessful$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String passwordCallbackHandlingWasUnsuccessful$str() {
        return "ELY14004: Password callback handling was unsuccessful";
    }
    @Override
    public final ConfigXMLParseException passwordCallbackHandlingWasUnsuccessful() {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), passwordCallbackHandlingWasUnsuccessful$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sslContextForSecurityProviderCreatesInfiniteLoop$str() {
        return "ELY14005: Default SSL context in security provider creates infinite loop";
    }
    @Override
    public final NoSuchAlgorithmException sslContextForSecurityProviderCreatesInfiniteLoop() {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(getLoggingLocale(), sslContextForSecurityProviderCreatesInfiniteLoop$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String clientConfigurationFileNotFound$str() {
        return "ELY14006: Configuration file path passed to WildFlyElytronClientDefaultSSLContextProvider not found";
    }
    @Override
    public final IllegalArgumentException clientConfigurationFileNotFound() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), clientConfigurationFileNotFound$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String clientConfigurationFileNotValid$str() {
        return "ELY14007: Invalid path passed to WildFlyElytronClientDefaultSSLContextProvider";
    }
    @Override
    public final IllegalArgumentException clientConfigurationFileNotValid() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), clientConfigurationFileNotValid$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotObtainClientDefaultSSLContext$str() {
        return "ELY14008: WildFlyElytronClientDefaultSSLContextProvider could not obtain client default SSLContext";
    }
    @Override
    public final NoSuchAlgorithmException couldNotObtainClientDefaultSSLContext() {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(getLoggingLocale(), couldNotObtainClientDefaultSSLContext$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
