/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.Provider;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import java.util.function.Supplier;
import javax.security.auth.x500.X500Principal;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.ElytronMessages;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.util.ProviderUtil;
import org.wildfly.security.x500.util.X500PrincipalUtil;

public class KeyStoreBackedSecurityRealm
implements SecurityRealm {
    private final Supplier<Provider[]> providers;
    private final KeyStore keyStore;

    public KeyStoreBackedSecurityRealm(KeyStore keyStore) {
        this(keyStore, ProviderUtil.INSTALLED_PROVIDERS);
    }

    public KeyStoreBackedSecurityRealm(KeyStore keyStore, Supplier<Provider[]> providers) {
        this.keyStore = keyStore;
        this.providers = providers;
    }

    @Override
    public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
        if (principal instanceof NamePrincipal) {
            String name = principal.getName();
            ElytronMessages.log.tracef("KeyStoreRealm: obtaining certificate by alias [%s]", (Object)name);
            return new KeyStoreRealmIdentity(name);
        }
        X500Principal x500Principal = X500PrincipalUtil.asX500Principal(principal);
        if (x500Principal == null) {
            ElytronMessages.log.tracef("KeyStoreRealm: conversion of principal [%s] to X500Principal failed", (Object)principal);
            return RealmIdentity.NON_EXISTENT;
        }
        ElytronMessages.log.tracef("KeyStoreRealm: obtaining certificate by X500Principal [%s]", (Object)x500Principal);
        KeyStore keyStore = this.keyStore;
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate certificate;
                String alias = aliases.nextElement();
                if (!keyStore.isCertificateEntry(alias) || !((certificate = keyStore.getCertificate(alias)) instanceof X509Certificate) || !x500Principal.equals(X500PrincipalUtil.asX500Principal(((X509Certificate)certificate).getSubjectX500Principal()))) continue;
                ElytronMessages.log.tracef("KeyStoreRealm: certificate found by X500Principal in alias [%s]", (Object)alias);
                return new KeyStoreRealmIdentity(alias);
            }
        }
        catch (KeyStoreException e) {
            throw ElytronMessages.log.failedToReadKeyStore(e);
        }
        ElytronMessages.log.tracef("KeyStoreRealm: certificate not found by X500Principal", new Object[0]);
        return RealmIdentity.NON_EXISTENT;
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        return SupportLevel.POSSIBLY_SUPPORTED;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"evidenceType", evidenceType);
        return SupportLevel.POSSIBLY_SUPPORTED;
    }

    private KeyStore.Entry getEntry(String name) {
        try {
            KeyStore.Entry entry = this.keyStore.getEntry(name, null);
            if (entry == null) {
                ElytronMessages.log.tracef("KeyStoreRealm: alias [%s] does not exist in KeyStore", (Object)name);
            }
            return entry;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
            ElytronMessages.log.tracef((Throwable)e, "KeyStoreRealm: Obtaining entry [%s] from KeyStore failed", (Object)name);
            return null;
        }
    }

    private class KeyStoreRealmIdentity
    implements RealmIdentity {
        private final String name;

        private KeyStoreRealmIdentity(String name) {
            this.name = name;
        }

        @Override
        public Principal getRealmIdentityPrincipal() {
            return new NamePrincipal(this.name);
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            KeyStore.Entry entry = KeyStoreBackedSecurityRealm.this.getEntry(this.name);
            if (entry == null) {
                return SupportLevel.UNSUPPORTED;
            }
            Credential credential = Credential.fromKeyStoreEntry(entry);
            return credential != null && credential.matches(credentialType, algorithmName, parameterSpec) ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            KeyStore.Entry entry = KeyStoreBackedSecurityRealm.this.getEntry(this.name);
            if (entry == null) {
                return null;
            }
            Credential credential = Credential.fromKeyStoreEntry(entry);
            return credential != null ? (C)credential.castAs(credentialType, algorithmName, parameterSpec) : null;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            return this.getCredential(credentialType, algorithmName, null);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return this.getCredential(credentialType, null);
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() {
            return AuthorizationIdentity.EMPTY;
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            KeyStore.Entry entry = KeyStoreBackedSecurityRealm.this.getEntry(this.name);
            if (entry == null) {
                return SupportLevel.UNSUPPORTED;
            }
            Credential credential = Credential.fromKeyStoreEntry(entry);
            if (credential != null && credential.canVerify(evidenceType, algorithmName)) {
                ElytronMessages.log.tracef("KeyStoreRealm: verification supported using alias [%s]", (Object)this.name);
                return SupportLevel.SUPPORTED;
            }
            ElytronMessages.log.tracef("KeyStoreRealm: verification unsupported - unsupported entry type of alias [%s]", (Object)this.name);
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            KeyStore.Entry entry = KeyStoreBackedSecurityRealm.this.getEntry(this.name);
            if (entry == null) {
                return false;
            }
            Credential credential = Credential.fromKeyStoreEntry(entry);
            if (credential != null && credential.canVerify(evidence) && credential.verify(KeyStoreBackedSecurityRealm.this.providers, evidence)) {
                ElytronMessages.log.tracef("KeyStoreRealm: verification succeed for alias [%s]", (Object)this.name);
                return true;
            }
            ElytronMessages.log.tracef("KeyStoreRealm: verification failed - rejected by credential from alias [%s]", (Object)this.name);
            return false;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return KeyStoreBackedSecurityRealm.this.getEntry(this.name) != null;
        }
    }
}

