/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.io.IOException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;
import org.wildfly.security.http.oidc.OidcException;

@MessageLogger(projectCode="ELY", length=5)
@ValidIdRanges(value={@ValidIdRange(min=23000, max=23999)})
interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages log = Logger.getMessageLogger(ElytronMessages.class, "org.wildfly.security.http.oidc");

    @Message(id=23000, value="Unexpected HTTP status code in response from OIDC provider \"%d\"")
    public OidcException unexpectedResponseCodeFromOidcProvider(int var1);

    @Message(id=23001, value="No entity in response from OIDC provider")
    public OidcException noEntityInResponse();

    @Message(id=23002, value="Unexpected error sending request to OIDC provider")
    public OidcException unexpectedErrorSendingRequestToOidcProvider(@Cause Exception var1);

    @Message(id=23003, value="Either provider-url or auth-server-url needs to be configured")
    public IllegalArgumentException providerUrlOrAuthServerUrlNeedsToBeConfigured();

    @LogMessage
    @Message(id=23004, value="Loaded OpenID provider metadata from '%s'")
    public void loadedOpenIdProviderMetadata(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=23005, value="Unable to load OpenID provider metadata from %s")
    public void unableToLoadOpenIdProviderMetadata(String var1);

    @Message(id=23006, value="Failed to decode request URI")
    public RuntimeException failedToDecodeRequestUri(@Cause Exception var1);

    @Message(id=23007, value="Failed to write to response output stream")
    public RuntimeException failedToWriteToResponseOutputStream(@Cause Exception var1);

    @Message(id=23008, value="Unable to parse token")
    public IllegalArgumentException unableToParseToken();

    @Message(id=23009, value="OIDC client configuration file not found")
    public RuntimeException oidcConfigFileNotFound(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=23010, value="Failed to invoke remote logout")
    public void failedToInvokeRemoteLogout(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=23011, value="Refresh token failure")
    public void refreshTokenFailure(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=23012, value="Refresh token failure status: %d %s")
    public void refreshTokenFailureStatus(int var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=23013, value="Failed verification of token: %s")
    public void failedVerificationOfToken(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=23014, value="Failed to refresh the token with a longer time-to-live than the minimum")
    public void failedToRefreshTokenWithALongerTTLThanMin();

    @Message(id=23015, value="No expected issuer given")
    public IllegalArgumentException noExpectedIssuerGiven();

    @Message(id=23016, value="No client ID given")
    public IllegalArgumentException noClientIDGiven();

    @Message(id=23017, value="No expected JWS algorithm given")
    public IllegalArgumentException noExpectedJwsAlgorithmGiven();

    @Message(id=23018, value="No JWKS public key or client secret key given")
    public IllegalArgumentException noJwksPublicKeyOrClientSecretKeyGiven();

    @Message(id=23019, value="Invalid ID token")
    public OidcException invalidIDToken(@Cause Throwable var1);

    @Message(id=0, value="Unexpected value for azp (issued for) claim")
    public String unexpectedValueForIssuedForClaim();

    @Message(id=23020, value="Invalid token claim value")
    public IllegalArgumentException invalidTokenClaimValue();

    @Message(id=23021, value="Invalid ID token claims")
    public OidcException invalidIDTokenClaims();

    @Message(id=23022, value="Must set 'realm' in config")
    public RuntimeException keycloakRealmMissing();

    @Message(id=23023, value="Must set 'resource' or 'client-id'")
    public RuntimeException resourceOrClientIdMustBeSet();

    @Message(id=23024, value="For bearer auth, you must set the 'realm-public-key' or one of 'auth-server-url' and 'provider-url'")
    public IllegalArgumentException invalidConfigurationForBearerAuth();

    @Message(id=23025, value="Must set 'auth-server-url' or 'provider-url'")
    public RuntimeException authServerUrlOrProviderUrlMustBeSet();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=23026, value="Client '%s' does not have a secret configured")
    public void noClientSecretConfigured(String var1);

    @Message(id=23027, value="Unsupported public key")
    public IllegalArgumentException unsupportedPublicKey();

    @Message(id=23028, value="Unable to create signed token")
    public IllegalArgumentException unableToCreateSignedToken();

    @Message(id=23029, value="Configuration of jwt credentials is missing or incorrect for client '%s'")
    public RuntimeException invalidJwtClientCredentialsConfig(String var1);

    @Message(id=23030, value="Missing parameter '%s' in jwt credentials for client %s")
    public RuntimeException missingParameterInJwtClientCredentialsConfig(String var1, String var2);

    @Message(id=23031, value="Unable to parse key '%s' with value '%s'")
    public IllegalArgumentException unableToParseKeyWithValue(String var1, Object var2);

    @Message(id=23032, value="Unable to load key with alias '%s' from keystore")
    public RuntimeException unableToLoadKeyWithAlias(String var1);

    @Message(id=23033, value="Unable to load private key from keystore")
    public RuntimeException unableToLoadPrivateKey(@Cause Throwable var1);

    @Message(id=23034, value="Unable to find keystore file '%s'")
    public RuntimeException unableToFindKeystoreFile(String var1);

    @Message(id=23035, value="Configuration of secret jwt client credentials is missing or incorrect for client '%s'")
    public RuntimeException invalidJwtClientCredentialsUsingSecretConfig(String var1);

    @Message(id=23036, value="Invalid value for 'algorithm' in secret jwt client credentials configuration for client '%s'")
    public RuntimeException invalidAlgorithmInJwtClientCredentialsConfig(String var1);

    @Message(id=23037, value="Unable to determine client credentials provider type for client '%s'")
    public RuntimeException unableToDetermineClientCredentialsProviderType(String var1);

    @Message(id=23038, value="Unable to find client credentials provider '%s'")
    public RuntimeException unableToFindClientCredentialsProvider(String var1);

    @Message(id=23039, value="Unable to load keystore")
    public RuntimeException unableToLoadKeyStore(@Cause Throwable var1);

    @Message(id=23040, value="Unable to load truststore")
    public RuntimeException unableToLoadTrustStore(@Cause Throwable var1);

    @Message(id=23041, value="Unable to find truststore file '%s'")
    public RuntimeException unableToFindTrustStoreFile(String var1);

    @Message(id=23042, value="Unexpected value for at_hash claim")
    public String unexpectedValueForAtHashClaim();

    @Message(id=23043, value="Uknown algorithm: '%s'")
    public IllegalArgumentException unknownAlgorithm(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=23044, value="Failed to parse token from cookie")
    public void failedToParseTokenFromCookie(@Cause Throwable var1);

    @Message(id=23045, value="Unable to create redirect response")
    public IllegalArgumentException unableToCreateRedirectResponse(@Cause Throwable var1);

    @Message(id=23046, value="Unable to set auth server URL")
    public RuntimeException unableToSetAuthServerUrl(@Cause Throwable var1);

    @Message(id=23047, value="Unable resolve a relative URL")
    public RuntimeException unableToResolveARelativeUrl();

    @Message(id=23048, value="Invalid URI: '%s'")
    public RuntimeException invalidUri(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=23049, value="Invalid 'auth-server-url' or 'provider-url': '%s'")
    public void invalidAuthServerUrlOrProviderUrl(String var1);

    @Message(id=23050, value="Invalid bearer token claims")
    public OidcException invalidBearerTokenClaims();

    @Message(id=23051, value="Invalid bearer token")
    public OidcException invalidBearerToken(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=23052, value="No trusted certificates in token")
    public void noTrustedCertificatesInToken();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=23053, value="No peer certificates established on the connection")
    public void noPeerCertificatesEstablishedOnConnection();

    @Message(id=23054, value="Unexpected value for typ claim")
    public String unexpectedValueForTypeClaim();

    @Message(id=23055, value="Unable to obtain token: %d")
    public IOException unableToObtainToken(int var1);

    @Message(id=23056, value="No message entity")
    public IOException noMessageEntity();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=23057, value="principal-attribute '%s' claim does not exist, falling back to 'sub'")
    public void principalAttributeClaimDoesNotExist(String var1);
}

