/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import java.security.Permission;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.wildfly.common.Assert;
import org.wildfly.transaction.TransactionPermission;
import org.wildfly.transaction.client.AssociationListener;

public abstract class AbstractTransaction
implements Transaction {
    private static final TransactionPermission ASSOCIATION_LISTENER_PERMISSION = TransactionPermission.forName("registerAssociationListener");
    private final Object outflowLock = new Object();
    private final long start = System.nanoTime();
    final Set<AssociationListener> associationListeners = new CopyOnWriteArraySet<AssociationListener>();

    AbstractTransaction() {
    }

    abstract void registerInterposedSynchronization(Synchronization var1) throws IllegalStateException;

    abstract Object getResource(Object var1) throws NullPointerException;

    abstract void putResource(Object var1, Object var2) throws NullPointerException;

    abstract Object getKey();

    boolean getRollbackOnly() {
        try {
            return this.getStatus() == 1;
        }
        catch (SystemException e) {
            return false;
        }
    }

    abstract void suspend() throws SystemException;

    abstract void resume() throws SystemException;

    abstract void verifyAssociation();

    public abstract int getTransactionTimeout();

    public final int getEstimatedRemainingTime() {
        long elapsed = System.nanoTime() - this.start;
        int transactionTimeout = this.getTransactionTimeout();
        return transactionTimeout - (int)Math.min((Math.max(elapsed, 0L) + 999999999L) / 1000000000L, (long)transactionTimeout);
    }

    public <T> T getProviderInterface(Class<T> providerInterfaceType) {
        return null;
    }

    public void registerAssociationListener(AssociationListener associationListener) {
        Assert.checkNotNullParam((String)"associationListener", (Object)associationListener);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)((Object)ASSOCIATION_LISTENER_PERMISSION));
        }
        this.associationListeners.add(associationListener);
    }

    Object getOutflowLock() {
        return this.outflowLock;
    }
}

