/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.wildfly.common.Assert;
import org.wildfly.transaction.client.AbstractTransaction;
import org.wildfly.transaction.client.LocalTransactionContext;
import org.wildfly.transaction.client._private.Log;

public final class ContextTransactionManager
implements TransactionManager {
    static final ContextTransactionManager INSTANCE = new ContextTransactionManager();
    final ThreadLocal<State> stateRef = ThreadLocal.withInitial(State::new);

    private ContextTransactionManager() {
    }

    public void begin() throws NotSupportedException, SystemException {
        State state = this.stateRef.get();
        if (state.transaction != null) {
            throw Log.log.nestedNotSupported();
        }
        this.resume(LocalTransactionContext.getCurrent().beginTransaction(state.timeout));
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        State state = this.stateRef.get();
        try {
            if (state.transaction == null) {
                throw Log.log.noTransaction();
            }
            state.transaction.commit();
        }
        finally {
            state.transaction = null;
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        State state = this.stateRef.get();
        try {
            if (state.transaction == null) {
                throw Log.log.noTransaction();
            }
            state.transaction.rollback();
        }
        finally {
            state.transaction = null;
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        State state = this.stateRef.get();
        if (state.transaction == null) {
            throw Log.log.noTransaction();
        }
        state.transaction.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        State state = this.stateRef.get();
        return state == null || state.transaction == null ? 6 : state.transaction.getStatus();
    }

    public AbstractTransaction getTransaction() {
        AbstractTransaction transaction = this.stateRef.get().transaction;
        if (transaction != null) {
            transaction.verifyAssociation();
        }
        return transaction;
    }

    public void setTransactionTimeout(int timeout) {
        Assert.checkMinimumParameter((String)"timeout", (int)0, (int)timeout);
        this.stateRef.get().timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractTransaction suspend() throws SystemException {
        State state = this.stateRef.get();
        AbstractTransaction transaction = state.transaction;
        if (transaction == null) {
            return null;
        }
        try {
            transaction.suspend();
            AbstractTransaction abstractTransaction = transaction;
            return abstractTransaction;
        }
        finally {
            state.transaction = null;
        }
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (transaction != null && !(transaction instanceof AbstractTransaction)) {
            throw Log.log.notSupportedTransaction(transaction);
        }
        this.resume((AbstractTransaction)transaction);
    }

    void resume(AbstractTransaction transaction) throws IllegalStateException, SystemException {
        State state = this.stateRef.get();
        if (state.transaction != null) {
            throw Log.log.alreadyAssociated();
        }
        if (transaction != null) {
            transaction.resume();
        }
        state.transaction = transaction;
    }

    public static ContextTransactionManager getInstance() {
        return INSTANCE;
    }

    ThreadLocal<State> getStateRef() {
        return this.stateRef;
    }

    static final class State {
        AbstractTransaction transaction;
        int timeout = 43200;

        State() {
        }
    }
}

