/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import java.io.Serializable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.wildfly.common.Assert;
import org.wildfly.transaction.client.AbstractTransaction;
import org.wildfly.transaction.client.AssociationListener;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.LocalTransactionContext;
import org.wildfly.transaction.client.RemoteTransactionContext;
import org.wildfly.transaction.client.XAOutflowedResources;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.spi.LocalTransactionProvider;

public final class LocalTransaction
extends AbstractTransaction {
    private final LocalTransactionContext owner;
    private final Transaction transaction;

    LocalTransaction(LocalTransactionContext owner, Transaction transaction) {
        this.owner = owner;
        this.transaction = transaction;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        if (this.isImported()) {
            throw Log.log.commitOnImported();
        }
        try {
            TransactionManager transactionManager = this.owner.getProvider().getTransactionManager();
            if (this.transaction.equals(transactionManager.getTransaction())) {
                transactionManager.commit();
            } else {
                this.owner.getProvider().commitLocal(this.transaction);
            }
        }
        finally {
            XAOutflowedResources outflowedResources = RemoteTransactionContext.getOutflowedResources(this);
            if (outflowedResources == null || outflowedResources.getEnlistedSubordinates() == 0) {
                this.owner.getProvider().dropLocal(this.transaction);
            }
        }
    }

    public void rollback() throws IllegalStateException, SystemException {
        if (this.isImported()) {
            throw Log.log.rollbackOnImported();
        }
        TransactionManager transactionManager = this.owner.getProvider().getTransactionManager();
        if (this.transaction.equals(transactionManager.getTransaction())) {
            transactionManager.rollback();
        } else {
            this.owner.getProvider().rollbackLocal(this.transaction);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.transaction.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        return this.transaction.getStatus();
    }

    @Override
    public int getTransactionTimeout() {
        return this.owner.getProvider().getTimeout(this.transaction);
    }

    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        Assert.checkNotNullParam((String)"xaRes", (Object)xaRes);
        return this.transaction.enlistResource(xaRes);
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        Assert.checkNotNullParam((String)"xaRes", (Object)xaRes);
        return this.transaction.delistResource(xaRes, flag);
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        Assert.checkNotNullParam((String)"sync", (Object)sync);
        this.transaction.registerSynchronization((Synchronization)new AssociatedSynchronization(sync));
    }

    public String getParentName() {
        return this.owner.getProvider().getNameFromXid(this.owner.getProvider().getXid(this.transaction));
    }

    @Override
    void registerInterposedSynchronization(Synchronization sync) throws IllegalStateException {
        Assert.checkNotNullParam((String)"sync", (Object)sync);
        this.owner.getProvider().registerInterposedSynchronization(this.transaction, new AssociatedSynchronization(sync));
    }

    @Override
    Object getResource(Object key) throws NullPointerException {
        return this.owner.getProvider().getResource(this.transaction, Assert.checkNotNullParamWithNullPointerException((String)"key", (Object)key));
    }

    @Override
    void putResource(Object key, Object value) throws NullPointerException {
        this.owner.getProvider().putResource(this.transaction, Assert.checkNotNullParamWithNullPointerException((String)"key", (Object)key), value);
    }

    @Override
    Object getKey() {
        return this.owner.getProvider().getKey(this.transaction);
    }

    @Override
    boolean getRollbackOnly() {
        return this.owner.getProvider().getRollbackOnly(this.transaction);
    }

    @Override
    void suspend() throws SystemException {
        for (AssociationListener associationListener : this.associationListeners) {
            try {
                associationListener.associationChanged(this, false);
            }
            catch (Throwable t) {
                Log.log.tracef(t, "An association listener %s threw an exception on transaction %s", associationListener, this);
            }
        }
        TransactionManager transactionManager = this.owner.getProvider().getTransactionManager();
        if (!this.transaction.equals(transactionManager.getTransaction())) {
            throw Log.log.invalidTxnState();
        }
        Transaction transactionManagerTransaction = transactionManager.suspend();
        if (!this.transaction.equals(transactionManagerTransaction)) {
            throw Log.log.unexpectedProviderTransactionMismatch(this.transaction, transactionManagerTransaction);
        }
    }

    @Override
    void resume() throws SystemException {
        TransactionManager transactionManager = this.owner.getProvider().getTransactionManager();
        try {
            transactionManager.resume(this.transaction);
        }
        catch (InvalidTransactionException e) {
            throw Log.log.invalidTxnState();
        }
        Transaction transactionManagerTransaction = transactionManager.getTransaction();
        if (!this.transaction.equals(transactionManagerTransaction)) {
            throw Log.log.unexpectedProviderTransactionMismatch(this.transaction, transactionManagerTransaction);
        }
        for (AssociationListener associationListener : this.associationListeners) {
            try {
                associationListener.associationChanged(this, true);
            }
            catch (Throwable t) {
                Log.log.tracef(t, "An association listener %s threw an exception on transaction %s", associationListener, this);
            }
        }
    }

    @Override
    void verifyAssociation() {
        TransactionManager transactionManager = this.owner.getProvider().getTransactionManager();
        try {
            Transaction transactionManagerTransaction = transactionManager.getTransaction();
            if (!this.transaction.equals(transactionManagerTransaction)) {
                throw Log.log.unexpectedProviderTransactionMismatch(this.transaction, transactionManagerTransaction);
            }
        }
        catch (SystemException e) {
            throw Log.log.invalidTxnState();
        }
    }

    public boolean isImported() {
        return this.owner.getProvider().isImported(this.transaction);
    }

    @Override
    public <T> T getProviderInterface(Class<T> providerInterfaceType) {
        return this.owner.getProvider().getProviderInterface(this.transaction, providerInterfaceType);
    }

    public int hashCode() {
        return this.transaction.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof LocalTransaction && this.equals((LocalTransaction)obj);
    }

    private boolean equals(LocalTransaction obj) {
        return this == obj || obj != null && this.transaction.equals(obj.transaction);
    }

    static final class AssociatedSynchronization
    implements Synchronization,
    Serializable {
        private static final long serialVersionUID = -4894315841737258909L;
        private final Synchronization delegate;

        AssociatedSynchronization(Synchronization delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeCompletion() {
            Transaction transaction;
            LocalTransactionContext transactionContext = LocalTransactionContext.getCurrent();
            LocalTransactionProvider provider = transactionContext.getProvider();
            try {
                transaction = provider.getTransactionManager().getTransaction();
            }
            catch (SystemException e) {
                throw Log.log.invalidTxnState();
            }
            LocalTransaction localTransaction = transactionContext.getOrAttach(transaction);
            ContextTransactionManager.State state = ContextTransactionManager.getInstance().getStateRef().get();
            AbstractTransaction old = state.transaction;
            state.transaction = localTransaction;
            try {
                this.delegate.beforeCompletion();
            }
            finally {
                state.transaction = old;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            Transaction transaction;
            LocalTransactionContext transactionContext = LocalTransactionContext.getCurrent();
            LocalTransactionProvider provider = transactionContext.getProvider();
            try {
                transaction = provider.getTransactionManager().getTransaction();
            }
            catch (SystemException e) {
                throw Log.log.invalidTxnState();
            }
            LocalTransaction localTransaction = transactionContext.getOrAttach(transaction);
            ContextTransactionManager.State state = ContextTransactionManager.getInstance().getStateRef().get();
            AbstractTransaction old = state.transaction;
            state.transaction = localTransaction;
            try {
                this.delegate.afterCompletion(status);
            }
            finally {
                state.transaction = old;
            }
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof AssociatedSynchronization && this.delegate.equals(((AssociatedSynchronization)obj).delegate);
        }

        public String toString() {
            return String.format("Association wrapper around %s", this.delegate);
        }
    }
}

