/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import java.io.Serializable;
import java.net.URI;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.wildfly.transaction.client.AbstractTransaction;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.RemoteTransaction;
import org.wildfly.transaction.client.RemoteTransactionContext;
import org.wildfly.transaction.client.SerializedUserTransaction;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.spi.RemoteTransactionProvider;
import org.wildfly.transaction.client.spi.SimpleTransactionControl;

public final class RemoteUserTransaction
implements UserTransaction,
Serializable {
    private static final long serialVersionUID = 8612109476723652825L;
    private static final int DEFAULT_TIMEOUT = 43200;
    private final ThreadLocal<State> stateRef = ThreadLocal.withInitial(State::new);
    private final URI location;

    RemoteUserTransaction(URI location) {
        this.location = location;
    }

    public void begin() throws NotSupportedException, SystemException {
        ContextTransactionManager transactionManager = ContextTransactionManager.getInstance();
        if (transactionManager.getTransaction() != null) {
            throw Log.log.nestedNotSupported();
        }
        RemoteTransactionProvider provider = RemoteTransactionContext.getInstancePrivate().getProvider(this.location);
        if (provider == null) {
            throw Log.log.noProviderForUri(this.location);
        }
        SimpleTransactionControl control = provider.getPeerHandle(this.location).begin();
        int timeout = this.stateRef.get().timeout;
        transactionManager.resume(new RemoteTransaction(control, this.location, timeout));
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        ContextTransactionManager transactionManager = ContextTransactionManager.getInstance();
        RemoteTransaction remoteTransaction = this.getMatchingTransaction();
        if (remoteTransaction == null) {
            throw Log.log.invalidTxnState();
        }
        transactionManager.commit();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        ContextTransactionManager transactionManager = ContextTransactionManager.getInstance();
        RemoteTransaction remoteTransaction = this.getMatchingTransaction();
        if (remoteTransaction == null) {
            throw Log.log.invalidTxnState();
        }
        transactionManager.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        ContextTransactionManager transactionManager = ContextTransactionManager.getInstance();
        RemoteTransaction remoteTransaction = this.getMatchingTransaction();
        if (remoteTransaction == null) {
            throw Log.log.noTransaction();
        }
        transactionManager.setRollbackOnly();
    }

    public int getStatus() {
        RemoteTransaction remoteTransaction = this.getMatchingTransaction();
        return remoteTransaction == null ? 6 : remoteTransaction.getStatus();
    }

    public URI getLocation() {
        return this.location;
    }

    RemoteTransaction getMatchingTransaction() {
        AbstractTransaction transaction = ContextTransactionManager.getInstance().getTransaction();
        if (!(transaction instanceof RemoteTransaction)) {
            return null;
        }
        RemoteTransaction remoteTransaction = (RemoteTransaction)transaction;
        if (!remoteTransaction.getLocation().equals(this.location)) {
            return null;
        }
        return remoteTransaction;
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (seconds < 0) {
            throw Log.log.negativeTxnTimeout();
        }
        this.stateRef.get().timeout = seconds == 0 ? 43200 : seconds;
    }

    Object writeReplace() {
        return new SerializedUserTransaction(this.location);
    }

    static final class State {
        int timeout = 43200;

        State() {
        }
    }
}

