/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client.provider.remoting;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.transaction.xa.Xid;
import org.jboss.remoting3.util.StreamUtils;
import org.wildfly.transaction.client.SimpleXid;

class Protocol {
    public static final boolean SIGNED = true;
    public static final boolean UNSIGNED = false;
    public static final int VERSION_MIN = 0;
    public static final int VERSION_MAX = 0;
    public static final int M_CAPABILITY = 0;
    public static final int M_XA_ROLLBACK = 2;
    public static final int M_XA_PREPARE = 3;
    public static final int M_XA_COMMIT = 4;
    public static final int M_XA_FORGET = 5;
    public static final int M_XA_BEFORE = 6;
    public static final int M_XA_RECOVER = 7;
    public static final int M_XA_RB_ONLY = 8;
    public static final int M_UT_COMMIT = 10;
    public static final int M_UT_ROLLBACK = 11;
    public static final int M_RESP_CAPABILITY = 0;
    public static final int M_RESP_XA_ROLLBACK = 18;
    public static final int M_RESP_XA_PREPARE = 19;
    public static final int M_RESP_XA_COMMIT = 20;
    public static final int M_RESP_XA_FORGET = 21;
    public static final int M_RESP_XA_BEFORE = 22;
    public static final int M_RESP_XA_RECOVER = 23;
    public static final int M_RESP_UT_COMMIT = 25;
    public static final int M_RESP_UT_ROLLBACK = 26;
    public static final int M_RESP_PARAM_ERROR = 254;
    public static final int M_RESP_ERROR = 255;
    public static final int P_XID = 1;
    public static final int P_ONE_PHASE = 2;
    public static final int P_PARENT_NAME = 3;
    public static final int P_XA_RDONLY = 7;
    public static final int P_UT_RB_EXC = 16;
    public static final int P_UT_HME_EXC = 17;
    public static final int P_UT_HRE_EXC = 18;
    public static final int P_UT_SYS_EXC = 19;
    public static final int P_UT_IS_EXC = 20;
    public static final int P_SEC_EXC = 32;
    public static final int P_XA_ERROR = 48;
    public static final int P_VERSION_ERROR = 64;
    public static final int P_SEC_CONTEXT = 240;
    public static final int P_TXN_CONTEXT = 241;

    Protocol() {
    }

    public static void writeParam(int param, OutputStream os, int val, boolean signed) throws IOException {
        StreamUtils.writeInt8((OutputStream)os, (int)param);
        int len = signed && val < 0 ? 32 - Integer.numberOfLeadingZeros(~val) + 8 >> 3 : 32 - Integer.numberOfLeadingZeros(val) + 7 >> 3;
        StreamUtils.writeInt8((OutputStream)os, (int)len);
        switch (len) {
            case 4: {
                StreamUtils.writeInt8((OutputStream)os, (int)(val >> 24));
            }
            case 3: {
                StreamUtils.writeInt8((OutputStream)os, (int)(val >> 16));
            }
            case 2: {
                StreamUtils.writeInt8((OutputStream)os, (int)(val >> 8));
            }
            case 1: {
                StreamUtils.writeInt8((OutputStream)os, (int)(val >> 0));
            }
        }
    }

    public static void writeParam(int param, OutputStream os, byte[] bytes) throws IOException {
        StreamUtils.writeInt8((OutputStream)os, (int)param);
        if (bytes == null || bytes.length == 0) {
            StreamUtils.writeInt8((OutputStream)os, (int)0);
        } else {
            StreamUtils.writePackedUnsignedInt32((OutputStream)os, (int)bytes.length);
            os.write(bytes);
        }
    }

    public static void writeParam(int param, OutputStream os, String str) throws IOException {
        if (str == null || str.isEmpty()) {
            Protocol.writeParam(param, os);
        } else {
            Protocol.writeParam(param, os, str.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static void writeParam(int param, OutputStream os) throws IOException {
        StreamUtils.writeInt8((OutputStream)os, (int)param);
        StreamUtils.writeInt8((OutputStream)os, (int)0);
    }

    public static void writeParam(int param, OutputStream os, Xid xid) throws IOException {
        if (xid == null) {
            Protocol.writeParam(param, os);
            return;
        }
        int formatId = xid.getFormatId();
        byte[] gtid = xid.getGlobalTransactionId();
        byte[] bq = xid.getBranchQualifier();
        if (gtid.length > 64 || bq.length > 64) {
            throw new IOException("Cannot write invalid XID");
        }
        int len = gtid.length + bq.length + 5;
        assert (len < 256);
        StreamUtils.writeInt8((OutputStream)os, (int)param);
        StreamUtils.writePackedUnsignedInt32((OutputStream)os, (int)len);
        StreamUtils.writeInt32BE((OutputStream)os, (int)formatId);
        StreamUtils.writeInt8((OutputStream)os, (int)gtid.length);
        os.write(gtid);
        os.write(bq);
    }

    public static int readIntParam(InputStream is, int len) throws IOException {
        int t = 0;
        for (int i = 0; i < len; ++i) {
            t = t << 8 | StreamUtils.readInt8((InputStream)is) & 0xFF;
        }
        return t;
    }

    public static String readStringParam(InputStream is, int len) throws IOException {
        byte[] b = new byte[len];
        StreamUtils.readFully((InputStream)is, (byte[])b);
        return new String(b, StandardCharsets.UTF_8);
    }

    public static SimpleXid readXid(InputStream is, int len) throws IOException {
        int formatId = StreamUtils.readInt32BE((InputStream)is);
        len -= 4;
        int gtidLen = StreamUtils.readInt8((InputStream)is);
        if (--len < gtidLen) {
            throw new EOFException();
        }
        byte[] gtid = gtidLen == 0 ? SimpleXid.NO_BYTES : new byte[gtidLen];
        StreamUtils.readFully((InputStream)is, (byte[])gtid);
        byte[] bq = (len -= gtidLen) == 0 ? SimpleXid.NO_BYTES : new byte[len];
        StreamUtils.readFully((InputStream)is, (byte[])bq);
        return new SimpleXid(formatId, gtid, bq);
    }
}

