/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client.provider.remoting;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3.util.BlockingInvocation;
import org.jboss.remoting3.util.Invocation;
import org.jboss.remoting3.util.InvocationTracker;
import org.jboss.remoting3.util.StreamUtils;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.AuthenticationException;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.provider.remoting.Protocol;
import org.wildfly.transaction.client.provider.remoting.SimpleIdResolver;
import org.wildfly.transaction.client.provider.remoting.TransactionClientChannel;
import org.wildfly.transaction.client.spi.SimpleTransactionControl;

class RemotingRemoteTransactionHandle
implements SimpleTransactionControl {
    private final TransactionClientChannel channel;
    private final AtomicInteger statusRef = new AtomicInteger(0);
    private final int id;
    private final SimpleIdResolver resolver = connection -> {
        Assert.checkNotNullParam((String)"connection", (Object)connection);
        if (this.getConnection() != connection) {
            throw Log.log.invalidTransactionConnection();
        }
        return this.getId();
    };

    RemotingRemoteTransactionHandle(int id, TransactionClientChannel channel) {
        this.id = id;
        this.channel = channel;
    }

    public int getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        AtomicInteger statusRef;
        AtomicInteger atomicInteger = statusRef = this.statusRef;
        synchronized (atomicInteger) {
            int oldVal = statusRef.get();
            if (oldVal == 0 || oldVal == 1) {
                statusRef.set(4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        AtomicInteger statusRef = this.statusRef;
        int oldVal = statusRef.get();
        if (oldVal != 0 && oldVal != 1) {
            throw Log.log.invalidTxnState();
        }
        AtomicInteger atomicInteger = statusRef;
        synchronized (atomicInteger) {
            block64: {
                oldVal = statusRef.get();
                if (oldVal == 1) {
                    this.rollback();
                    throw Log.log.rollbackOnlyRollback();
                }
                if (oldVal != 0) {
                    throw Log.log.invalidTxnState();
                }
                statusRef.set(8);
                try {
                    Throwable throwable;
                    InvocationTracker invocationTracker = this.channel.getInvocationTracker();
                    BlockingInvocation invocation = (BlockingInvocation)invocationTracker.addInvocation(BlockingInvocation::new);
                    try {
                        throwable = null;
                        try (MessageOutputStream os = invocationTracker.allocateMessage((Invocation)invocation);){
                            os.writeShort(invocation.getIndex());
                            os.writeByte(10);
                            Protocol.writeParam(241, (OutputStream)os, this.id, false);
                            int peerIdentityId = this.channel.getConnection().getPeerIdentityId();
                            if (peerIdentityId != 0) {
                                Protocol.writeParam(240, (OutputStream)os, peerIdentityId, false);
                            }
                        }
                        catch (Throwable peerIdentityId) {
                            throwable = peerIdentityId;
                            throw peerIdentityId;
                        }
                    }
                    catch (IOException | AuthenticationException e) {
                        statusRef.set(5);
                        throw Log.log.failedToSend((Exception)e);
                    }
                    try {
                        throwable = null;
                        try (BlockingInvocation.Response response = invocation.getResponse();){
                            try (MessageInputStream is = response.getInputStream();){
                                if (is.readUnsignedByte() != 25) {
                                    throw Log.log.unknownResponse();
                                }
                                int id = is.read();
                                if (id != -1) {
                                    do {
                                        Protocol.readIntParam((InputStream)is, StreamUtils.readPackedUnsignedInt32((InputStream)is));
                                    } while (is.read() != -1);
                                }
                                if (id == -1) {
                                    statusRef.set(3);
                                    break block64;
                                }
                                if (id == 17) {
                                    statusRef.set(5);
                                    throw Log.log.peerHeuristicMixedException();
                                }
                                if (id == 18) {
                                    statusRef.set(5);
                                    throw Log.log.peerHeuristicRollbackException();
                                }
                                if (id == 20) {
                                    statusRef.set(5);
                                    throw Log.log.peerIllegalStateException();
                                }
                                if (id == 16) {
                                    statusRef.set(4);
                                    throw Log.log.transactionRolledBackByPeer();
                                }
                                if (id == 19) {
                                    statusRef.set(5);
                                    throw Log.log.peerSystemException();
                                }
                                if (id == 32) {
                                    statusRef.set(oldVal);
                                    throw Log.log.peerSecurityException();
                                }
                                statusRef.set(5);
                                throw Log.log.unknownResponse();
                            }
                            catch (IOException e) {
                                statusRef.set(5);
                                throw Log.log.responseFailed(e);
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        statusRef.set(5);
                        throw Log.log.operationInterrupted();
                    }
                    catch (IOException e) {
                        Log.log.inboundException(e);
                    }
                }
                finally {
                    statusRef.compareAndSet(8, 5);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SecurityException, SystemException {
        AtomicInteger statusRef = this.statusRef;
        int oldVal = statusRef.get();
        if (oldVal != 0 && oldVal != 1) {
            throw Log.log.invalidTxnState();
        }
        AtomicInteger atomicInteger = statusRef;
        synchronized (atomicInteger) {
            block60: {
                oldVal = statusRef.get();
                if (oldVal != 0 && oldVal != 1) {
                    throw Log.log.invalidTxnState();
                }
                statusRef.set(9);
                try {
                    Throwable throwable;
                    InvocationTracker invocationTracker = this.channel.getInvocationTracker();
                    BlockingInvocation invocation = (BlockingInvocation)invocationTracker.addInvocation(BlockingInvocation::new);
                    try {
                        throwable = null;
                        try (MessageOutputStream os = invocationTracker.allocateMessage((Invocation)invocation);){
                            os.writeShort(invocation.getIndex());
                            os.writeByte(11);
                            Protocol.writeParam(241, (OutputStream)os, this.id, false);
                            int peerIdentityId = this.channel.getConnection().getPeerIdentityId();
                            if (peerIdentityId != 0) {
                                Protocol.writeParam(240, (OutputStream)os, peerIdentityId, false);
                            }
                        }
                        catch (Throwable peerIdentityId) {
                            throwable = peerIdentityId;
                            throw peerIdentityId;
                        }
                    }
                    catch (IOException | AuthenticationException e) {
                        statusRef.set(5);
                        throw Log.log.failedToSend((Exception)e);
                    }
                    try {
                        throwable = null;
                        try (BlockingInvocation.Response response = invocation.getResponse();){
                            try (MessageInputStream is = response.getInputStream();){
                                if (is.readUnsignedByte() != 26) {
                                    throw Log.log.unknownResponse();
                                }
                                int id = is.read();
                                if (id != -1) {
                                    do {
                                        Protocol.readIntParam((InputStream)is, StreamUtils.readPackedUnsignedInt32((InputStream)is));
                                    } while (is.read() != -1);
                                }
                                if (id == -1) {
                                    statusRef.set(4);
                                    break block60;
                                }
                                if (id == 20) {
                                    statusRef.set(5);
                                    throw Log.log.peerIllegalStateException();
                                }
                                if (id == 19) {
                                    statusRef.set(5);
                                    throw Log.log.peerSystemException();
                                }
                                if (id == 32) {
                                    statusRef.set(oldVal);
                                    throw Log.log.peerSecurityException();
                                }
                                statusRef.set(5);
                                throw Log.log.unknownResponse();
                            }
                            catch (IOException e) {
                                statusRef.set(5);
                                throw Log.log.responseFailed(e);
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        statusRef.set(5);
                        throw Log.log.operationInterrupted();
                    }
                    catch (IOException e) {
                        Log.log.inboundException(e);
                    }
                }
                finally {
                    statusRef.compareAndSet(9, 5);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRollbackOnly() throws SystemException {
        AtomicInteger statusRef = this.statusRef;
        int oldVal = statusRef.get();
        if (oldVal == 1) {
            return;
        }
        if (oldVal != 0) {
            throw Log.log.invalidTxnState();
        }
        AtomicInteger atomicInteger = statusRef;
        synchronized (atomicInteger) {
            oldVal = statusRef.get();
            if (oldVal == 1) {
                return;
            }
            if (oldVal != 0) {
                throw Log.log.invalidTxnState();
            }
            statusRef.set(1);
        }
    }

    @Override
    public <T> T getProviderInterface(Class<T> type) {
        return type.isAssignableFrom(SimpleIdResolver.class) ? (T)type.cast(this.resolver) : null;
    }

    Connection getConnection() {
        return this.channel.getConnection();
    }
}

