/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client.provider.remoting;

import java.net.URI;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.transaction.SystemException;
import org.jboss.remoting3.Endpoint;
import org.wildfly.transaction.client.provider.remoting.RemotingFallbackPeerProvider;
import org.wildfly.transaction.client.provider.remoting.RemotingRemoteTransactionPeer;
import org.wildfly.transaction.client.spi.RemoteTransactionPeer;
import org.wildfly.transaction.client.spi.RemoteTransactionProvider;

public final class RemotingRemoteTransactionProvider
implements RemoteTransactionProvider {
    private final RemotingFallbackPeerProvider fallbackProvider;

    public RemotingRemoteTransactionProvider() {
        ServiceLoader<RemotingFallbackPeerProvider> loader = ServiceLoader.load(RemotingFallbackPeerProvider.class, RemotingRemoteTransactionProvider.class.getClassLoader());
        Iterator<RemotingFallbackPeerProvider> iterator = loader.iterator();
        RemotingFallbackPeerProvider fallbackProvider = null;
        while (true) {
            try {
                if (!iterator.hasNext()) break;
                fallbackProvider = iterator.next();
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                continue;
            }
            break;
        }
        this.fallbackProvider = fallbackProvider;
    }

    @Override
    public boolean supportsScheme(String scheme) {
        return Endpoint.getCurrent().isValidUriScheme(scheme);
    }

    @Override
    public RemoteTransactionPeer getPeerHandle(URI location) throws SystemException {
        return new RemotingRemoteTransactionPeer(location, Endpoint.getCurrent(), this.fallbackProvider);
    }
}

