/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client.provider.remoting;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.ClientServiceHandle;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3._private.IntIndexHashMap;
import org.jboss.remoting3._private.IntIndexMap;
import org.jboss.remoting3.util.BlockingInvocation;
import org.jboss.remoting3.util.Invocation;
import org.jboss.remoting3.util.InvocationTracker;
import org.jboss.remoting3.util.StreamUtils;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.security.auth.AuthenticationException;
import org.wildfly.transaction.client.SimpleXid;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.provider.remoting.Protocol;
import org.wildfly.transaction.client.provider.remoting.RemotingOperations;
import org.wildfly.transaction.client.provider.remoting.RemotingRemoteTransactionHandle;
import org.wildfly.transaction.client.spi.SimpleTransactionControl;
import org.xnio.FinishedIoFuture;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

final class TransactionClientChannel
implements RemotingOperations {
    private final Channel channel;
    private final InvocationTracker invocationTracker;
    private final IntIndexMap<RemotingRemoteTransactionHandle> peerTransactionMap = new IntIndexHashMap(RemotingRemoteTransactionHandle::getId);
    private final Channel.Receiver receiver = new ReceiverImpl();
    private static final ClientServiceHandle<TransactionClientChannel> CLIENT_SERVICE_HANDLE = new ClientServiceHandle("txn", TransactionClientChannel::construct);

    TransactionClientChannel(Channel channel) {
        this.channel = channel;
        this.invocationTracker = new InvocationTracker(channel);
    }

    private static IoFuture<TransactionClientChannel> construct(Channel channel) {
        TransactionClientChannel clientChannel = new TransactionClientChannel(channel);
        channel.receiveMessage(clientChannel.getReceiver());
        return new FinishedIoFuture((Object)clientChannel);
    }

    @Override
    @NotNull
    public SimpleTransactionControl begin() throws SystemException {
        RemotingRemoteTransactionHandle handle;
        int id;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        IntIndexMap<RemotingRemoteTransactionHandle> map = this.peerTransactionMap;
        while (map.containsKey(id = random.nextInt()) || map.putIfAbsent((Object)(handle = new RemotingRemoteTransactionHandle(id, this))) != null) {
        }
        return handle;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        Throwable throwable;
        InvocationTracker invocationTracker = this.getInvocationTracker();
        BlockingInvocation invocation = (BlockingInvocation)invocationTracker.addInvocation(BlockingInvocation::new);
        try {
            throwable = null;
            try (MessageOutputStream os = invocationTracker.allocateMessage((Invocation)invocation);){
                os.writeShort(invocation.getIndex());
                os.writeByte(2);
                Protocol.writeParam(1, (OutputStream)os, xid);
                int peerIdentityId = this.channel.getConnection().getPeerIdentityId();
                if (peerIdentityId != 0) {
                    Protocol.writeParam(240, (OutputStream)os, peerIdentityId, false);
                }
            }
            catch (Throwable peerIdentityId) {
                throwable = peerIdentityId;
                throw peerIdentityId;
            }
        }
        catch (IOException | AuthenticationException e) {
            throw Log.log.failedToSendXA((Exception)e, -3);
        }
        try {
            throwable = null;
            try (BlockingInvocation.Response response = invocation.getResponse();){
                try (MessageInputStream is = response.getInputStream();){
                    if (is.readUnsignedByte() != 18) {
                        throw Log.log.unknownResponseXa(-3);
                    }
                    int id = is.read();
                    if (id == 48) {
                        int error = Protocol.readIntParam((InputStream)is, StreamUtils.readPackedSignedInt32((InputStream)is));
                        id = is.read();
                        if (id != -1) {
                            XAException ex = Log.log.unrecognizedParameter(-7, id);
                            ex.addSuppressed(Log.log.peerXaException(error));
                            throw ex;
                        }
                        throw Log.log.protocolErrorXA(error);
                    }
                    if (id == 32) {
                        id = is.read();
                        if (id != -1) {
                            XAException ex = Log.log.unrecognizedParameter(-7, id);
                            ex.addSuppressed(Log.log.peerSecurityException());
                            throw ex;
                        }
                        throw Log.log.peerSecurityException();
                    }
                    if (id != -1) {
                        throw Log.log.unrecognizedParameter(-7, id);
                    }
                }
                catch (IOException e) {
                    throw Log.log.responseFailedXa(e, -3);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Log.log.interruptedXA(-3);
        }
        catch (IOException e) {
            Log.log.inboundException(e);
        }
    }

    @Override
    public void setRollbackOnly(Xid xid) throws XAException {
        Throwable throwable;
        InvocationTracker invocationTracker = this.getInvocationTracker();
        BlockingInvocation invocation = (BlockingInvocation)invocationTracker.addInvocation(BlockingInvocation::new);
        try {
            throwable = null;
            try (MessageOutputStream os = invocationTracker.allocateMessage((Invocation)invocation);){
                os.writeShort(invocation.getIndex());
                os.writeByte(8);
                Protocol.writeParam(1, (OutputStream)os, xid);
                int peerIdentityId = this.channel.getConnection().getPeerIdentityId();
                if (peerIdentityId != 0) {
                    Protocol.writeParam(240, (OutputStream)os, peerIdentityId, false);
                }
            }
            catch (Throwable peerIdentityId) {
                throwable = peerIdentityId;
                throw peerIdentityId;
            }
        }
        catch (IOException | AuthenticationException e) {
            throw Log.log.failedToSendXA((Exception)e, -3);
        }
        try {
            throwable = null;
            try (BlockingInvocation.Response response = invocation.getResponse();){
                try (MessageInputStream is = response.getInputStream();){
                    if (is.readUnsignedByte() != 24) {
                        throw Log.log.unknownResponseXa(-3);
                    }
                    int id = is.read();
                    if (id == 48) {
                        int error = Protocol.readIntParam((InputStream)is, StreamUtils.readPackedSignedInt32((InputStream)is));
                        id = is.read();
                        if (id != -1) {
                            XAException ex = Log.log.unrecognizedParameter(-7, id);
                            ex.addSuppressed(Log.log.peerXaException(error));
                            throw ex;
                        }
                        throw Log.log.protocolErrorXA(error);
                    }
                    if (id == 32) {
                        id = is.read();
                        if (id != -1) {
                            XAException ex = Log.log.unrecognizedParameter(-7, id);
                            ex.addSuppressed(Log.log.peerSecurityException());
                            throw ex;
                        }
                        throw Log.log.peerSecurityException();
                    }
                    if (id != -1) {
                        throw Log.log.unrecognizedParameter(-7, id);
                    }
                }
                catch (IOException e) {
                    throw Log.log.responseFailedXa(e, -3);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Log.log.interruptedXA(-3);
        }
        catch (IOException e) {
            Log.log.inboundException(e);
        }
    }

    @Override
    public void beforeCompletion(Xid xid) throws XAException {
        Throwable throwable;
        InvocationTracker invocationTracker = this.getInvocationTracker();
        BlockingInvocation invocation = (BlockingInvocation)invocationTracker.addInvocation(BlockingInvocation::new);
        try {
            throwable = null;
            try (MessageOutputStream os = invocationTracker.allocateMessage((Invocation)invocation);){
                os.writeShort(invocation.getIndex());
                os.writeByte(6);
                Protocol.writeParam(1, (OutputStream)os, xid);
                int peerIdentityId = this.channel.getConnection().getPeerIdentityId();
                if (peerIdentityId != 0) {
                    Protocol.writeParam(240, (OutputStream)os, peerIdentityId, false);
                }
            }
            catch (Throwable peerIdentityId) {
                throwable = peerIdentityId;
                throw peerIdentityId;
            }
        }
        catch (IOException | AuthenticationException e) {
            throw Log.log.failedToSendXA((Exception)e, -3);
        }
        try {
            throwable = null;
            try (BlockingInvocation.Response response = invocation.getResponse();){
                try (MessageInputStream is = response.getInputStream();){
                    if (is.readUnsignedByte() != 22) {
                        throw Log.log.unknownResponseXa(-3);
                    }
                    int id = is.read();
                    int error = 0;
                    boolean sec = false;
                    if (id == 48) {
                        error = Protocol.readIntParam((InputStream)is, StreamUtils.readPackedUnsignedInt32((InputStream)is));
                    } else if (id == 32) {
                        sec = true;
                        Protocol.readIntParam((InputStream)is, StreamUtils.readPackedUnsignedInt32((InputStream)is));
                    }
                    while (is.read() != -1) {
                        Protocol.readIntParam((InputStream)is, StreamUtils.readPackedUnsignedInt32((InputStream)is));
                    }
                    if (sec) {
                        throw Log.log.peerSecurityException();
                    }
                    if (error != 0) {
                        throw Log.log.peerXaException(error);
                    }
                }
                catch (IOException e) {
                    throw Log.log.responseFailedXa(e, -3);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Log.log.interruptedXA(-3);
        }
        catch (IOException e) {
            Log.log.inboundException(e);
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        Throwable throwable;
        boolean readOnly = false;
        InvocationTracker invocationTracker = this.getInvocationTracker();
        BlockingInvocation invocation = (BlockingInvocation)invocationTracker.addInvocation(BlockingInvocation::new);
        try {
            throwable = null;
            try (MessageOutputStream os = invocationTracker.allocateMessage((Invocation)invocation);){
                os.writeShort(invocation.getIndex());
                os.writeByte(3);
                Protocol.writeParam(1, (OutputStream)os, xid);
                int peerIdentityId = this.channel.getConnection().getPeerIdentityId();
                if (peerIdentityId != 0) {
                    Protocol.writeParam(240, (OutputStream)os, peerIdentityId, false);
                }
            }
            catch (Throwable peerIdentityId) {
                throwable = peerIdentityId;
                throw peerIdentityId;
            }
        }
        catch (IOException | AuthenticationException e) {
            throw Log.log.failedToSendXA((Exception)e, -3);
        }
        try {
            throwable = null;
            try (BlockingInvocation.Response response = invocation.getResponse();){
                try (MessageInputStream is = response.getInputStream();){
                    if (is.readUnsignedByte() != 19) {
                        throw Log.log.unknownResponseXa(-3);
                    }
                    int id = is.read();
                    int error = 0;
                    boolean sec = false;
                    if (id == 48) {
                        error = Protocol.readIntParam((InputStream)is, StreamUtils.readPackedSignedInt32((InputStream)is));
                    } else if (id == 32) {
                        sec = true;
                    } else if (id == 7) {
                        readOnly = true;
                    }
                    if (id != -1) {
                        do {
                            Protocol.readIntParam((InputStream)is, StreamUtils.readPackedUnsignedInt32((InputStream)is));
                        } while (is.read() != -1);
                    }
                    if (sec) {
                        throw Log.log.peerSecurityException();
                    }
                    if (error != 0) {
                        throw Log.log.peerXaException(error);
                    }
                }
                catch (IOException e) {
                    throw Log.log.responseFailedXa(e, -3);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Log.log.interruptedXA(-3);
        }
        catch (IOException e) {
            Log.log.inboundException(e);
        }
        return readOnly ? 3 : 0;
    }

    @Override
    public void forget(Xid xid) throws XAException {
        Throwable throwable;
        InvocationTracker invocationTracker = this.getInvocationTracker();
        BlockingInvocation invocation = (BlockingInvocation)invocationTracker.addInvocation(BlockingInvocation::new);
        try {
            throwable = null;
            try (MessageOutputStream os = invocationTracker.allocateMessage((Invocation)invocation);){
                os.writeShort(invocation.getIndex());
                os.writeByte(5);
                Protocol.writeParam(1, (OutputStream)os, xid);
                int peerIdentityId = this.channel.getConnection().getPeerIdentityId();
                if (peerIdentityId != 0) {
                    Protocol.writeParam(240, (OutputStream)os, peerIdentityId, false);
                }
            }
            catch (Throwable peerIdentityId) {
                throwable = peerIdentityId;
                throw peerIdentityId;
            }
        }
        catch (IOException | AuthenticationException e) {
            throw Log.log.failedToSendXA((Exception)e, -3);
        }
        try {
            throwable = null;
            try (BlockingInvocation.Response response = invocation.getResponse();){
                try (MessageInputStream is = response.getInputStream();){
                    if (is.readUnsignedByte() != 21) {
                        throw Log.log.unknownResponseXa(-3);
                    }
                    int id = is.read();
                    int error = 0;
                    boolean sec = false;
                    if (id == 48) {
                        error = Protocol.readIntParam((InputStream)is, StreamUtils.readPackedSignedInt32((InputStream)is));
                    } else if (id == 32) {
                        sec = true;
                    }
                    if (id != -1) {
                        do {
                            Protocol.readIntParam((InputStream)is, StreamUtils.readPackedUnsignedInt32((InputStream)is));
                        } while (is.read() != -1);
                    }
                    if (sec) {
                        throw Log.log.peerSecurityException();
                    }
                    if (error != 0) {
                        throw Log.log.peerXaException(error);
                    }
                }
                catch (IOException e) {
                    throw Log.log.responseFailedXa(e, -3);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Log.log.interruptedXA(-3);
        }
        catch (IOException e) {
            Log.log.inboundException(e);
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        Throwable throwable;
        InvocationTracker invocationTracker = this.getInvocationTracker();
        BlockingInvocation invocation = (BlockingInvocation)invocationTracker.addInvocation(BlockingInvocation::new);
        try {
            throwable = null;
            try (MessageOutputStream os = invocationTracker.allocateMessage((Invocation)invocation);){
                os.writeShort(invocation.getIndex());
                os.writeByte(4);
                Protocol.writeParam(1, (OutputStream)os, xid);
                int peerIdentityId = this.channel.getConnection().getPeerIdentityId();
                if (peerIdentityId != 0) {
                    Protocol.writeParam(240, (OutputStream)os, peerIdentityId, false);
                }
                if (onePhase) {
                    Protocol.writeParam(2, (OutputStream)os);
                }
            }
            catch (Throwable peerIdentityId) {
                throwable = peerIdentityId;
                throw peerIdentityId;
            }
        }
        catch (IOException | AuthenticationException e) {
            throw Log.log.failedToSendXA((Exception)e, -3);
        }
        try {
            throwable = null;
            try (BlockingInvocation.Response response = invocation.getResponse();){
                try (MessageInputStream is = response.getInputStream();){
                    if (is.readUnsignedByte() != 20) {
                        throw Log.log.unknownResponseXa(-3);
                    }
                    int id = is.read();
                    int error = 0;
                    boolean sec = false;
                    if (id == 48) {
                        error = Protocol.readIntParam((InputStream)is, StreamUtils.readPackedSignedInt32((InputStream)is));
                    } else if (id == 32) {
                        sec = true;
                    }
                    if (id != -1) {
                        do {
                            Protocol.readIntParam((InputStream)is, StreamUtils.readPackedUnsignedInt32((InputStream)is));
                        } while (is.read() != -1);
                    }
                    if (sec) {
                        throw Log.log.peerSecurityException();
                    }
                    if (error != 0) {
                        throw Log.log.peerXaException(error);
                    }
                }
                catch (IOException e) {
                    throw Log.log.responseFailedXa(e, -3);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Log.log.interruptedXA(-3);
        }
        catch (IOException e) {
            Log.log.inboundException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public Xid[] recover(int flag, String parentName) throws XAException {
        if (flag != 0x1000000) {
            return SimpleXid.NO_XIDS;
        }
        InvocationTracker invocationTracker = this.getInvocationTracker();
        BlockingInvocation invocation = (BlockingInvocation)invocationTracker.addInvocation(BlockingInvocation::new);
        try (MessageOutputStream os = invocationTracker.allocateMessage((Invocation)invocation);){
            os.writeShort(invocation.getIndex());
            os.writeByte(7);
            int peerIdentityId = this.channel.getConnection().getPeerIdentityId();
            if (peerIdentityId != 0) {
                Protocol.writeParam(240, (OutputStream)os, peerIdentityId, false);
            }
            Protocol.writeParam(3, (OutputStream)os, parentName);
        }
        catch (IOException | AuthenticationException e) {
            throw Log.log.failedToSendXA((Exception)e, -3);
        }
        ArrayList<SimpleXid> recoveryList = new ArrayList<SimpleXid>();
        try (BlockingInvocation.Response response = invocation.getResponse();){
            try (MessageInputStream is = response.getInputStream();){
                if (is.readUnsignedByte() != 23) {
                    throw Log.log.unknownResponseXa(-3);
                }
                int id = is.read();
                int error = 0;
                boolean sec = false;
                while (true) {
                    if (id == 48) {
                        error = Protocol.readIntParam((InputStream)is, StreamUtils.readPackedSignedInt32((InputStream)is));
                    } else if (id == 32) {
                        sec = true;
                    } else if (id == 1) {
                        if (error != 0 && !sec) {
                            recoveryList.add(Protocol.readXid((InputStream)is, StreamUtils.readPackedUnsignedInt32((InputStream)is)));
                        }
                    } else {
                        if (id == -1) {
                            if (sec) {
                                throw Log.log.peerSecurityException();
                            }
                            break;
                        }
                        error = -3;
                    }
                    id = is.read();
                }
                if (error != 0) {
                    throw Log.log.peerXaException(error);
                }
            }
            Xid[] xidArray = recoveryList.toArray(SimpleXid.NO_XIDS);
            return xidArray;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Log.log.interruptedXA(-3);
        }
        catch (IOException e) {
            throw Log.log.responseFailedXa(e, -3);
        }
    }

    InvocationTracker getInvocationTracker() {
        return this.invocationTracker;
    }

    static TransactionClientChannel forConnection(Connection connection) throws IOException {
        return (TransactionClientChannel)CLIENT_SERVICE_HANDLE.getClientService(connection, OptionMap.EMPTY).get();
    }

    Channel.Receiver getReceiver() {
        return this.receiver;
    }

    Connection getConnection() {
        return this.channel.getConnection();
    }

    class ReceiverImpl
    implements Channel.Receiver {
        ReceiverImpl() {
        }

        public void handleError(Channel channel, IOException error) {
            this.handleEnd(channel);
        }

        public void handleEnd(Channel channel) {
            for (RemotingRemoteTransactionHandle transaction : TransactionClientChannel.this.peerTransactionMap) {
                transaction.disconnect();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Channel channel, MessageInputStream message) {
            try {
                int invId;
                channel.receiveMessage((Channel.Receiver)this);
                try {
                    invId = message.readUnsignedShort();
                }
                catch (IOException e) {
                    Log.log.inboundException(e);
                    IoUtils.safeClose((Closeable)message);
                    return;
                }
                TransactionClientChannel.this.invocationTracker.signalResponse(invId, 0, message, true);
            }
            finally {
                IoUtils.safeClose((Closeable)message);
            }
        }
    }
}

