/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import java.security.AccessController;
import java.security.Permission;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.wildfly.common.Assert;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.common.context.ContextManager;
import org.wildfly.common.context.Contextual;
import org.wildfly.transaction.TransactionPermission;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.CreationListener;
import org.wildfly.transaction.client.ImportResult;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.XAImporter;
import org.wildfly.transaction.client.XARecoverable;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.spi.LocalTransactionProvider;

public final class LocalTransactionContext
implements Contextual<LocalTransactionContext> {
    private static final ContextManager<LocalTransactionContext> CONTEXT_MANAGER = new ContextManager(LocalTransactionContext.class, "org.wildfly.transaction.client.context.local");
    private static final Supplier<LocalTransactionContext> PRIVILEGED_SUPPLIER = AccessController.doPrivileged(() -> CONTEXT_MANAGER.getPrivilegedSupplier());
    private static final Object LOCAL_TXN_KEY = new Object();
    private static final TransactionPermission CREATION_LISTENER_PERMISSION = TransactionPermission.forName("registerCreationListener");
    private static final TransactionPermission SUSPEND_REQUESTS_PERMISSION = TransactionPermission.forName("suspendRequests");
    private static final TransactionPermission RESUME_REQUESTS_PERMISSION = TransactionPermission.forName("resumeRequests");
    private final LocalTransactionProvider provider;
    private final List<CreationListener> creationListeners = new CopyOnWriteArrayList<CreationListener>();
    private volatile boolean requestsSuspended;

    public LocalTransactionContext(LocalTransactionProvider provider) {
        Assert.checkNotNullParam((String)"provider", (Object)provider);
        this.provider = provider;
    }

    @NotNull
    public static ContextManager<LocalTransactionContext> getContextManager() {
        return CONTEXT_MANAGER;
    }

    @NotNull
    public ContextManager<LocalTransactionContext> getInstanceContextManager() {
        return LocalTransactionContext.getContextManager();
    }

    @NotNull
    public static LocalTransactionContext getCurrent() {
        return PRIVILEGED_SUPPLIER.get();
    }

    private LocalTransaction notifyCreationListeners(LocalTransaction transaction) {
        for (CreationListener creationListener : this.creationListeners) {
            try {
                creationListener.transactionCreated(transaction);
            }
            catch (Throwable t) {
                Log.log.trace("Transaction creation listener throws an exception", t);
            }
        }
        return transaction;
    }

    public void registerCreationListener(CreationListener creationListener) {
        Assert.checkNotNullParam((String)"creationListener", (Object)creationListener);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)((Object)CREATION_LISTENER_PERMISSION));
        }
        this.creationListeners.add(creationListener);
    }

    public void removeCreationListener(CreationListener creationListener) {
        Assert.checkNotNullParam((String)"creationListener", (Object)creationListener);
        this.creationListeners.removeIf(c -> c == creationListener);
    }

    @NotNull
    public LocalTransaction beginTransaction(int timeout) throws SystemException, SecurityException {
        return this.beginTransaction(timeout, false);
    }

    @NotNull
    public LocalTransaction beginTransaction(int timeout, boolean remote) throws SystemException, SecurityException {
        Assert.checkMinimumParameter((String)"timeout", (int)0, (int)timeout);
        if (remote && this.requestsSuspended) {
            throw Log.log.suspendedCannotCreateNew();
        }
        Transaction newTransaction = this.provider.createNewTransaction(timeout);
        if (newTransaction == null) {
            throw Log.log.providerCreatedNullTransaction();
        }
        return this.notifyCreationListeners(new LocalTransaction(this, newTransaction));
    }

    public ImportResult<LocalTransaction> findOrImportTransaction(Xid xid, int timeout, boolean doNotImport) throws XAException {
        Assert.checkNotNullParam((String)"xid", (Object)xid);
        Assert.checkMinimumParameter((String)"timeout", (int)0, (int)timeout);
        XAImporter xaImporter = this.provider.getXAImporter();
        boolean requestsSuspended = this.requestsSuspended;
        ImportResult<?> result = xaImporter.findOrImportTransaction(xid, timeout, doNotImport || requestsSuspended);
        if (result == null) {
            if (!doNotImport) {
                if (requestsSuspended) {
                    throw Log.log.suspendedCannotImportXa(-3);
                }
                throw Log.log.providerCreatedNullTransaction();
            }
            return null;
        }
        ImportResult<LocalTransaction> finalResult = result.withTransaction(this.getOrAttach((Transaction)result.getTransaction()));
        if (finalResult.isNew()) {
            this.notifyCreationListeners(finalResult.getTransaction());
        }
        return finalResult;
    }

    @NotNull
    public ImportResult<LocalTransaction> findOrImportTransaction(Xid xid, int timeout) throws XAException {
        return (ImportResult)Assert.assertNotNull(this.findOrImportTransaction(xid, timeout, false));
    }

    public boolean importProviderTransaction() throws SystemException, NotSupportedException {
        ContextTransactionManager.State state = ContextTransactionManager.INSTANCE.getStateRef().get();
        if (state.transaction != null) {
            throw Log.log.nestedNotSupported();
        }
        Transaction transaction = this.provider.getTransactionManager().getTransaction();
        if (transaction == null) {
            return false;
        }
        state.transaction = this.getOrAttach(transaction);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocalTransaction getOrAttach(Transaction transaction) {
        LocalTransaction txn = (LocalTransaction)this.provider.getResource(transaction, LOCAL_TXN_KEY);
        boolean isNew = false;
        if (txn == null) {
            Object object = LOCAL_TXN_KEY;
            synchronized (object) {
                txn = (LocalTransaction)this.provider.getResource(transaction, LOCAL_TXN_KEY);
                if (txn == null) {
                    txn = new LocalTransaction(this, transaction);
                    this.provider.putResource(transaction, LOCAL_TXN_KEY, txn);
                    isNew = true;
                }
            }
        }
        if (isNew) {
            this.notifyCreationListeners(txn);
        }
        return txn;
    }

    @NotNull
    public XARecoverable getRecoveryInterface() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)((Object)TransactionPermission.forName("getRecoveryInterface")));
        }
        final XAImporter xaImporter = this.provider.getXAImporter();
        return new XARecoverable(){

            @Override
            public Xid[] recover(int flag, String parentName) throws XAException {
                return xaImporter.recover(flag, parentName);
            }

            @Override
            public void commit(Xid xid, boolean onePhase) throws XAException {
                xaImporter.commit(xid, onePhase);
            }

            @Override
            public void forget(Xid xid) throws XAException {
                xaImporter.forget(xid);
            }
        };
    }

    public void suspendRequests() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)((Object)SUSPEND_REQUESTS_PERMISSION));
        }
        this.requestsSuspended = true;
    }

    public void resumeRequests() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)((Object)RESUME_REQUESTS_PERMISSION));
        }
        this.requestsSuspended = false;
    }

    LocalTransactionProvider getProvider() {
        return this.provider;
    }

    public String toString() {
        return String.format("Local transaction context for provider %s", this.provider);
    }

    static {
        AccessController.doPrivileged(() -> {
            CONTEXT_MANAGER.setGlobalDefault((Contextual)new LocalTransactionContext(LocalTransactionProvider.EMPTY));
            return null;
        });
    }
}

