/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client.provider.jboss;

import com.arjuna.ats.arjuna.AtomicAction;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.internal.jta.resources.arjunacore.SynchronizationImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionManagerImple;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.resource.spi.XATerminator;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.tm.ExtendedJBossXATerminator;
import org.jboss.tm.ImportedTransaction;
import org.jboss.tm.TransactionImportResult;
import org.jboss.tm.TransactionTimeoutConfiguration;
import org.wildfly.common.Assert;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.transaction.client.ImportResult;
import org.wildfly.transaction.client.SimpleXid;
import org.wildfly.transaction.client.XAImporter;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.spi.LocalTransactionProvider;
import org.wildfly.transaction.client.spi.SubordinateTransactionControl;

public final class JBossLocalTransactionProvider
implements LocalTransactionProvider {
    private static final Object ENTRY_KEY = new Object();
    private final int staleTransactionTime;
    private final ExtendedJBossXATerminator ext;
    private final XATerminator xt;
    private final TransactionManager tm;
    private final TransactionSynchronizationRegistry tsr;
    private final XAImporterImpl xi = new XAImporterImpl();
    private final ConcurrentSkipListSet<XidKey> timeoutSet = new ConcurrentSkipListSet();
    private final ConcurrentMap<SimpleXid, Entry> known = new ConcurrentHashMap<SimpleXid, Entry>();
    private static final MethodHandle registerSynchronizationImple = AccessController.doPrivileged(() -> {
        try {
            Method declaredMethod = TransactionImple.class.getDeclaredMethod("registerSynchronizationImple", SynchronizationImple.class);
            declaredMethod.setAccessible(true);
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            return lookup.unreflect(declaredMethod);
        }
        catch (Throwable t) {
            throw Log.log.unexpectedFailure(t);
        }
    });
    private static final long TIME_START = System.nanoTime();
    private static final int UID_LEN = 28;
    static final int BIT_BEFORE_COMP = 1;
    static final int BIT_PREPARE_OR_ROLLBACK = 2;
    static final int BIT_COMMIT_OR_FORGET = 4;
    private static final int PREPARE_OK = 0;
    private static final int PREPARE_NOTOK = 1;
    private static final int PREPARE_READONLY = 2;
    private static final int HEURISTIC_ROLLBACK = 3;
    private static final int HEURISTIC_COMMIT = 4;
    private static final int HEURISTIC_MIXED = 5;
    private static final int HEURISTIC_HAZARD = 6;
    private static final int FINISH_OK = 7;
    private static final int FINISH_ERROR = 8;
    private static final int NOT_PREPARED = 9;
    private static final int ONE_PHASE_ERROR = 10;
    private static final int INVALID_TRANSACTION = 11;
    private static final int PREPARE_ONE_PHASE_COMMITTED = 12;

    JBossLocalTransactionProvider(int staleTransactionTime, XATerminator xt, ExtendedJBossXATerminator ext, TransactionManager tm, TransactionSynchronizationRegistry tsr) {
        this.staleTransactionTime = staleTransactionTime;
        this.ext = (ExtendedJBossXATerminator)Assert.checkNotNullParam((String)"ext", (Object)ext);
        this.xt = (XATerminator)Assert.checkNotNullParam((String)"xt", (Object)xt);
        this.tm = (TransactionManager)Assert.checkNotNullParam((String)"tm", (Object)tm);
        this.tsr = (TransactionSynchronizationRegistry)Assert.checkNotNullParam((String)"tsr", (Object)tsr);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    @NotNull
    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    @Override
    @NotNull
    public XAImporter getXAImporter() {
        return this.xi;
    }

    @Override
    @NotNull
    public Transaction createNewTransaction(int timeout) throws SystemException, SecurityException {
        TransactionManager tm = this.tm;
        int oldTimeout = tm instanceof TransactionTimeoutConfiguration ? ((TransactionTimeoutConfiguration)tm).getTransactionTimeout() : (tm instanceof TransactionManagerImple ? ((TransactionManagerImple)tm).getTimeout() : 0);
        tm.setTransactionTimeout(timeout);
        try {
            Transaction suspended = tm.suspend();
            try {
                tm.begin();
                Transaction transaction = tm.suspend();
                SimpleXid gtid = SimpleXid.of(((TransactionImple)transaction).getTxId()).withoutBranch();
                this.known.put(gtid, this.getEntryFor(transaction, gtid));
                tm.setTransactionTimeout(oldTimeout);
                return transaction;
            }
            catch (NotSupportedException e) {
                throw Log.log.unexpectedFailure(e);
            }
            catch (Throwable t) {
                if (suspended != null) {
                    try {
                        tm.resume(suspended);
                    }
                    catch (InvalidTransactionException e) {
                        e.addSuppressed(t);
                        throw Log.log.unexpectedFailure(e);
                    }
                }
                throw t;
            }
        }
        catch (Throwable t) {
            try {
                tm.setTransactionTimeout(oldTimeout);
            }
            catch (Throwable t2) {
                t2.addSuppressed(t);
                throw t2;
            }
            throw t;
        }
    }

    @Override
    public boolean isImported(@NotNull Transaction transaction) throws IllegalArgumentException {
        return transaction instanceof ImportedTransaction;
    }

    @Override
    public void registerInterposedSynchronization(@NotNull Transaction transaction, @NotNull Synchronization sync) throws IllegalArgumentException {
        try {
            registerSynchronizationImple.invoke((TransactionImple)transaction, new SynchronizationImple(sync, true));
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Log.log.unexpectedFailure(t);
        }
    }

    @Override
    public Object getResource(@NotNull Transaction transaction, @NotNull Object key) {
        return ((TransactionImple)transaction).getTxLocalResource(key);
    }

    @Override
    public void putResource(@NotNull Transaction transaction, @NotNull Object key, Object value) throws IllegalArgumentException {
        ((TransactionImple)transaction).putTxLocalResource(key, value);
    }

    @Override
    public boolean getRollbackOnly(@NotNull Transaction transaction) throws IllegalArgumentException {
        try {
            return transaction.getStatus() == 1;
        }
        catch (SystemException e) {
            throw Log.log.unexpectedFailure(e);
        }
    }

    @Override
    @NotNull
    public Object getKey(@NotNull Transaction transaction) throws IllegalArgumentException {
        return ((TransactionImple)transaction).get_uid();
    }

    @Override
    public void commitLocal(@NotNull Transaction transaction) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.getEntryFor(transaction, SimpleXid.of(this.getXid(transaction)).withoutBranch()).commitLocal();
    }

    @Override
    public void rollbackLocal(@NotNull Transaction transaction) throws IllegalStateException, SystemException {
        this.getEntryFor(transaction, SimpleXid.of(this.getXid(transaction)).withoutBranch()).rollbackLocal();
    }

    @Override
    public void dropLocal(@NotNull Transaction transaction) {
        Xid xid = this.getXid(transaction);
        SimpleXid gtid = SimpleXid.of(xid).withoutBranch();
        Entry entry = (Entry)this.known.remove(gtid);
        if (entry != null) {
            this.timeoutSet.remove(entry.getXidKey());
        }
    }

    @Override
    public int getTimeout(@NotNull Transaction transaction) {
        return ((TransactionImple)transaction).getTimeout();
    }

    @Override
    @NotNull
    public Xid getXid(@NotNull Transaction transaction) {
        return ((TransactionImple)transaction).getTxId();
    }

    @Override
    @NotNull
    public String getNodeName() {
        String nodeIdentifier = arjPropertyManager.getCoreEnvironmentBean().getNodeIdentifier();
        if (nodeIdentifier == null) {
            throw Log.log.noLocalTransactionProviderNodeName();
        }
        return nodeIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Entry getEntryFor(Transaction transaction, SimpleXid gtid) {
        XidKey xidKey;
        Entry entry = (Entry)this.getResource(transaction, ENTRY_KEY);
        if (entry != null) {
            return entry;
        }
        Object object = ENTRY_KEY;
        synchronized (object) {
            entry = (Entry)this.getResource(transaction, ENTRY_KEY);
            if (entry != null) {
                return entry;
            }
            int lifetime = this.getTimeout(transaction) + this.staleTransactionTime;
            long timeTick = this.getTimeTick();
            xidKey = new XidKey(gtid, timeTick + (long)lifetime * 1000000000L);
            entry = new Entry(gtid, transaction, xidKey);
            this.putResource(transaction, ENTRY_KEY, entry);
        }
        this.timeoutSet.add(xidKey);
        this.registerInterposedSynchronization(transaction, new Synchronization(){

            public void beforeCompletion() {
            }

            public void afterCompletion(int status) {
                long timeTick = JBossLocalTransactionProvider.this.getTimeTick();
                ConcurrentMap known = JBossLocalTransactionProvider.this.known;
                Iterator iterator = JBossLocalTransactionProvider.this.timeoutSet.headSet(new XidKey(SimpleXid.EMPTY, timeTick)).iterator();
                while (iterator.hasNext()) {
                    known.remove(((XidKey)iterator.next()).gtid);
                    iterator.remove();
                }
            }
        });
        return entry;
    }

    long getTimeTick() {
        return System.nanoTime() - TIME_START;
    }

    @Override
    public String getNameFromXid(@NotNull Xid xid) {
        int formatId = xid.getFormatId();
        if (formatId == 131072 || formatId == 131077 || formatId == 131080) {
            byte[] gtid = xid.getGlobalTransactionId();
            int length = gtid.length;
            if (length <= 28) {
                return null;
            }
            return new String(gtid, 28, length - 28, StandardCharsets.UTF_8);
        }
        return null;
    }

    @Override
    public <T> T getProviderInterface(Transaction transaction, Class<T> providerInterfaceType) {
        return providerInterfaceType.isInstance(transaction) ? (T)providerInterfaceType.cast(transaction) : null;
    }

    public String toString() {
        return "JBoss transaction provider";
    }

    public static final class Builder {
        private int staleTransactionTime = 600;
        private ExtendedJBossXATerminator extendedJBossXATerminator;
        private XATerminator xaTerminator;
        private TransactionManager transactionManager;
        private TransactionSynchronizationRegistry transactionSynchronizationRegistry;

        Builder() {
        }

        public int getStaleTransactionTime() {
            return this.staleTransactionTime;
        }

        public Builder setStaleTransactionTime(int staleTransactionTime) {
            Assert.checkMinimumParameter((String)"staleTransactionTime", (int)1, (int)staleTransactionTime);
            this.staleTransactionTime = staleTransactionTime;
            return this;
        }

        public ExtendedJBossXATerminator getExtendedJBossXATerminator() {
            return this.extendedJBossXATerminator;
        }

        public Builder setExtendedJBossXATerminator(ExtendedJBossXATerminator ext) {
            Assert.checkNotNullParam((String)"ext", (Object)ext);
            this.extendedJBossXATerminator = ext;
            return this;
        }

        public XATerminator getXATerminator() {
            return this.xaTerminator;
        }

        public Builder setXATerminator(XATerminator xt) {
            Assert.checkNotNullParam((String)"xt", (Object)xt);
            this.xaTerminator = xt;
            return this;
        }

        public TransactionManager getTransactionManager() {
            return this.transactionManager;
        }

        public Builder setTransactionManager(TransactionManager tm) {
            Assert.checkNotNullParam((String)"tm", (Object)tm);
            this.transactionManager = tm;
            return this;
        }

        public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
            return this.transactionSynchronizationRegistry;
        }

        public Builder setTransactionSynchronizationRegistry(TransactionSynchronizationRegistry tsr) {
            Assert.checkNotNullParam((String)"tsr", (Object)tsr);
            this.transactionSynchronizationRegistry = tsr;
            return this;
        }

        public JBossLocalTransactionProvider build() {
            Assert.checkNotNullParam((String)"extendedJBossXATerminator", (Object)this.extendedJBossXATerminator);
            Assert.checkNotNullParam((String)"xaTerminator", (Object)this.xaTerminator);
            Assert.checkNotNullParam((String)"transactionManager", (Object)this.transactionManager);
            Assert.checkNotNullParam((String)"transactionSynchronizationRegistry", (Object)this.transactionSynchronizationRegistry);
            return new JBossLocalTransactionProvider(this.staleTransactionTime, this.xaTerminator, this.extendedJBossXATerminator, this.transactionManager, this.transactionSynchronizationRegistry);
        }
    }

    final class XAImporterImpl
    implements XAImporter {
        XAImporterImpl() {
        }

        public ImportResult<Transaction> findOrImportTransaction(Xid xid, int timeout, boolean doNotImport) throws XAException {
            try {
                Entry appearing;
                Transaction transaction;
                boolean imported;
                SimpleXid simpleXid = SimpleXid.of(xid);
                SimpleXid gtid = simpleXid.withoutBranch();
                ConcurrentMap known = JBossLocalTransactionProvider.this.known;
                Entry entry = (Entry)known.get(gtid);
                if (entry != null) {
                    return new ImportResult<Transaction>(entry.getTransaction(), entry, false);
                }
                if (doNotImport) {
                    imported = false;
                    transaction = JBossLocalTransactionProvider.this.ext.getTransaction(xid);
                    if (transaction == null) {
                        return null;
                    }
                } else {
                    TransactionImportResult result = JBossLocalTransactionProvider.this.ext.importTransaction(xid, timeout);
                    transaction = result.getTransaction();
                    imported = result.isNewImportedTransaction();
                }
                if ((appearing = known.putIfAbsent(gtid, entry = JBossLocalTransactionProvider.this.getEntryFor(transaction, gtid))) != null) {
                    return new ImportResult<Transaction>(transaction, appearing, imported);
                }
                return new ImportResult<Transaction>(transaction, entry, imported);
            }
            catch (XAException e) {
                throw e;
            }
            catch (Throwable t) {
                throw Log.log.resourceManagerErrorXa(-7, t);
            }
        }

        @Override
        public Transaction findExistingTransaction(Xid xid) throws XAException {
            try {
                SimpleXid simpleXid = SimpleXid.of(xid);
                SimpleXid gtid = simpleXid.withoutBranch();
                ConcurrentMap known = JBossLocalTransactionProvider.this.known;
                Entry entry = (Entry)known.get(gtid);
                if (entry != null) {
                    return entry.getTransaction();
                }
                Transaction transaction = JBossLocalTransactionProvider.this.ext.getTransaction(xid);
                if (transaction == null) {
                    return null;
                }
                return known.computeIfAbsent(gtid, g -> JBossLocalTransactionProvider.this.getEntryFor(transaction, (SimpleXid)g)).getTransaction();
            }
            catch (XAException e) {
                throw e;
            }
            catch (Throwable t) {
                throw Log.log.resourceManagerErrorXa(-7, t);
            }
        }

        @Override
        public void commit(Xid xid, boolean onePhase) throws XAException {
            try {
                Entry entry = (Entry)JBossLocalTransactionProvider.this.known.get(SimpleXid.of(xid).withoutBranch());
                if (entry == null) {
                    throw new XAException(-4);
                }
                entry.commit(onePhase);
            }
            catch (XAException e) {
                throw e;
            }
            catch (Throwable t) {
                throw Log.log.resourceManagerErrorXa(-7, t);
            }
        }

        @Override
        public void forget(Xid xid) throws XAException {
            try {
                Entry entry = (Entry)JBossLocalTransactionProvider.this.known.get(SimpleXid.of(xid).withoutBranch());
                if (entry == null) {
                    throw new XAException(-4);
                }
                entry.forget();
            }
            catch (XAException e) {
                throw e;
            }
            catch (Throwable t) {
                throw Log.log.resourceManagerErrorXa(-7, t);
            }
        }

        @Override
        @NotNull
        public Xid[] recover(int flag, String parentNodeName) throws XAException {
            try {
                try {
                    return JBossLocalTransactionProvider.this.ext.doRecover(null, parentNodeName);
                }
                catch (NotSupportedException e) {
                    throw new XAException(-7);
                }
            }
            catch (XAException e) {
                throw e;
            }
            catch (Throwable t) {
                throw Log.log.resourceManagerErrorXa(-7, t);
            }
        }
    }

    final class Entry
    implements SubordinateTransactionControl {
        private final SimpleXid gtid;
        private final Transaction transaction;
        private final AtomicInteger completionBits = new AtomicInteger(0);
        private final XidKey xidKey;

        Entry(SimpleXid gtid, Transaction transaction, XidKey xidKey) {
            this.gtid = gtid;
            this.transaction = transaction;
            this.xidKey = xidKey;
        }

        XidKey getXidKey() {
            return this.xidKey;
        }

        Transaction getTransaction() {
            return this.transaction;
        }

        void rollbackLocal() throws SystemException {
            int oldVal;
            if (this.transaction instanceof ImportedTransaction) {
                throw Log.log.rollbackOnImported();
            }
            do {
                if (((oldVal = this.completionBits.get()) & 2) == 0) continue;
                throw Log.log.invalidTxnState();
            } while (!this.completionBits.compareAndSet(oldVal, oldVal | 2 | 1));
            this.transaction.rollback();
        }

        void commitLocal() throws HeuristicRollbackException, RollbackException, HeuristicMixedException, SystemException {
            int oldVal;
            if (this.transaction instanceof ImportedTransaction) {
                throw Log.log.commitOnImported();
            }
            do {
                if (((oldVal = this.completionBits.get()) & 2) == 0 && (oldVal & 4) == 0) continue;
                throw Log.log.invalidTxnState();
            } while (!this.completionBits.compareAndSet(oldVal, oldVal | 4 | 2 | 1));
            this.transaction.commit();
        }

        @Override
        public void rollback() throws XAException {
            int oldVal;
            Transaction transaction = this.transaction;
            if (!(transaction instanceof ImportedTransaction)) {
                throw Log.log.notImportedXa(-4);
            }
            do {
                if (((oldVal = this.completionBits.get()) & 2) == 0) continue;
                throw Log.log.invalidTxStateXa(-4);
            } while (!this.completionBits.compareAndSet(oldVal, oldVal | 2 | 1));
            ImportedTransaction importedTransaction = (ImportedTransaction)transaction;
            if (importedTransaction.activated()) {
                try {
                    importedTransaction.doRollback();
                }
                catch (HeuristicCommitException e) {
                    throw Log.log.heuristicCommitXa(7, e);
                }
                catch (HeuristicMixedException e) {
                    throw Log.log.heuristicMixedXa(5, e);
                }
                catch (HeuristicRollbackException e) {
                    throw Log.log.heuristicRollbackXa(6, e);
                }
                catch (IllegalStateException e) {
                    throw Log.log.illegalStateXa(-4, e);
                }
                catch (Throwable e) {
                    throw Log.log.resourceManagerErrorXa(-3, e);
                }
                finally {
                    JBossLocalTransactionProvider.this.ext.removeImportedTransaction((Xid)this.gtid);
                }
            }
        }

        @Override
        public void end(int flags) throws XAException {
            Transaction transaction = this.transaction;
            if (!(transaction instanceof ImportedTransaction)) {
                throw Log.log.notImportedXa(-4);
            }
            if (flags == 0x20000000) {
                // empty if block
            }
        }

        @Override
        public void beforeCompletion() throws XAException {
            int oldVal;
            Transaction transaction = this.transaction;
            if (!(transaction instanceof ImportedTransaction)) {
                throw Log.log.notImportedXa(-4);
            }
            do {
                if (((oldVal = this.completionBits.get()) & 1) == 0) continue;
                throw Log.log.invalidTxStateXa(-4);
            } while (!this.completionBits.compareAndSet(oldVal, oldVal | 1));
            ImportedTransaction importedTransaction = (ImportedTransaction)transaction;
            try {
                if (!importedTransaction.doBeforeCompletion()) {
                    throw new XAException(-3);
                }
            }
            catch (IllegalStateException e) {
                throw Log.log.illegalStateXa(-4, e);
            }
            catch (Throwable e) {
                throw Log.log.resourceManagerErrorXa(-3, e);
            }
        }

        @Override
        public int prepare() throws XAException {
            int oldVal;
            Transaction transaction = this.transaction;
            if (!(transaction instanceof ImportedTransaction)) {
                throw Log.log.notImportedXa(-4);
            }
            do {
                if (((oldVal = this.completionBits.get()) & 2) == 0) continue;
                throw Log.log.invalidTxStateXa(-4);
            } while (!this.completionBits.compareAndSet(oldVal, oldVal | 2 | 1));
            ImportedTransaction importedTransaction = (ImportedTransaction)transaction;
            int tpo = importedTransaction.doPrepare();
            switch (tpo) {
                case 2: {
                    JBossLocalTransactionProvider.this.ext.removeImportedTransaction((Xid)this.gtid);
                    return 3;
                }
                case 0: {
                    return 0;
                }
                case 1: {
                    try {
                        importedTransaction.doRollback();
                    }
                    catch (HeuristicCommitException | HeuristicMixedException | HeuristicRollbackException | SystemException e) {
                        JBossLocalTransactionProvider.this.ext.removeImportedTransaction((Xid)this.gtid);
                        throw this.initializeSuppressed(Log.log.resourceManagerErrorXa(-3, e), importedTransaction);
                    }
                    catch (Throwable t) {
                        JBossLocalTransactionProvider.this.ext.removeImportedTransaction((Xid)this.gtid);
                        throw this.initializeSuppressed(Log.log.resourceManagerErrorXa(-3, t), importedTransaction);
                    }
                    throw this.initializeSuppressed(new XAException(100), importedTransaction);
                }
                case 11: {
                    throw new XAException(-4);
                }
            }
            throw new XAException(104);
        }

        @Override
        public void forget() throws XAException {
            int oldVal;
            Transaction transaction = this.transaction;
            if (!(transaction instanceof ImportedTransaction)) {
                throw Log.log.notImportedXa(-4);
            }
            do {
                if (((oldVal = this.completionBits.get()) & 4) == 0) continue;
                throw Log.log.invalidTxStateXa(-4);
            } while (!this.completionBits.compareAndSet(oldVal, oldVal | 4 | 2 | 1));
            ImportedTransaction importedTransaction = (ImportedTransaction)transaction;
            try {
                importedTransaction.doForget();
            }
            catch (IllegalStateException e) {
                throw Log.log.illegalStateXa(-4, e);
            }
            catch (Throwable e) {
                throw Log.log.resourceManagerErrorXa(-3, e);
            }
        }

        @Override
        public void commit(boolean onePhase) throws XAException {
            int oldVal;
            Transaction transaction = this.transaction;
            if (!(transaction instanceof ImportedTransaction)) {
                throw Log.log.notImportedXa(-4);
            }
            do {
                oldVal = this.completionBits.get();
                if ((!onePhase || (oldVal & 2) == 0) && (oldVal & 4) == 0) continue;
                throw Log.log.invalidTxStateXa(-4);
            } while (!this.completionBits.compareAndSet(oldVal, oldVal | 4 | 2 | 1));
            ImportedTransaction importedTransaction = (ImportedTransaction)transaction;
            try {
                if (onePhase) {
                    importedTransaction.doOnePhaseCommit();
                } else if (!importedTransaction.doCommit()) {
                    throw new XAException(4);
                }
            }
            catch (HeuristicMixedException e) {
                throw this.initializeSuppressed(Log.log.heuristicMixedXa(5, e), importedTransaction);
            }
            catch (RollbackException e) {
                throw this.initializeSuppressed(Log.log.rollbackXa(100, e), importedTransaction);
            }
            catch (HeuristicCommitException e) {
                throw this.initializeSuppressed(Log.log.heuristicCommitXa(7, e), importedTransaction);
            }
            catch (HeuristicRollbackException e) {
                throw this.initializeSuppressed(Log.log.heuristicRollbackXa(6, e), importedTransaction);
            }
            catch (IllegalStateException e) {
                throw this.initializeSuppressed(Log.log.illegalStateXa(-4, e), importedTransaction);
            }
            catch (Throwable e) {
                throw this.initializeSuppressed(Log.log.resourceManagerErrorXa(-3, e), importedTransaction);
            }
        }

        private XAException initializeSuppressed(XAException ex, ImportedTransaction transaction) {
            try {
                if (transaction instanceof AtomicAction) {
                    for (Throwable t : ((AtomicAction)transaction).getDeferredThrowables()) {
                        ex.addSuppressed(t);
                    }
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            return ex;
        }
    }

    static final class XidKey
    implements Comparable<XidKey> {
        private final SimpleXid gtid;
        private final long expiration;

        XidKey(SimpleXid gtid, long expiration) {
            this.gtid = gtid;
            this.expiration = expiration;
        }

        @Override
        public int compareTo(XidKey o) {
            int res = Long.signum(this.expiration - o.expiration);
            return res == 0 ? this.gtid.compareTo(o.gtid) : res;
        }
    }
}

