/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import java.security.AccessController;
import java.security.Permission;
import java.util.function.Supplier;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.wildfly.common.Assert;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.common.context.ContextManager;
import org.wildfly.common.context.Contextual;
import org.wildfly.transaction.TransactionPermission;
import org.wildfly.transaction.client.ImportResult;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.XAImporter;
import org.wildfly.transaction.client.XARecoverable;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.spi.LocalTransactionProvider;
import org.wildfly.transaction.client.spi.SubordinateTransactionControl;

public final class LocalTransactionContext
implements Contextual<LocalTransactionContext> {
    private static final ContextManager<LocalTransactionContext> CONTEXT_MANAGER = new ContextManager(LocalTransactionContext.class, "org.wildfly.transaction.client.context.local");
    private static final Supplier<LocalTransactionContext> PRIVILEGED_SUPPLIER = AccessController.doPrivileged(() -> CONTEXT_MANAGER.getPrivilegedSupplier());
    private final LocalTransactionProvider provider;

    LocalTransactionContext(LocalTransactionProvider provider) {
        this.provider = provider;
    }

    @NotNull
    public static ContextManager<LocalTransactionContext> getContextManager() {
        return CONTEXT_MANAGER;
    }

    @NotNull
    public ContextManager<LocalTransactionContext> getInstanceContextManager() {
        return LocalTransactionContext.getContextManager();
    }

    @NotNull
    public static LocalTransactionContext getCurrent() {
        return PRIVILEGED_SUPPLIER.get();
    }

    @NotNull
    public LocalTransaction beginTransaction(int timeout) throws SystemException, SecurityException {
        Assert.checkMinimumParameter((String)"timeout", (int)0, (int)timeout);
        Transaction newTransaction = this.provider.createNewTransaction(timeout);
        if (newTransaction == null) {
            throw Log.log.providerCreatedNullTransaction();
        }
        return new LocalTransaction(this, newTransaction);
    }

    @NotNull
    public ImportResult findOrImportTransaction(final Xid xid, int timeout) throws XAException {
        Assert.checkNotNullParam((String)"xid", (Object)xid);
        Assert.checkMinimumParameter((String)"timeout", (int)0, (int)timeout);
        final XAImporter xaImporter = this.provider.getXAImporter();
        XAImporter.ProviderImportResult result = xaImporter.findOrImportTransaction(xid, timeout);
        final LocalTransaction transaction = new LocalTransaction(this, result.getTransaction());
        return new ImportResult(transaction, new SubordinateTransactionControl(){

            @Override
            public void rollback() throws XAException {
                xaImporter.rollback(xid);
            }

            @Override
            public void end(int flags) throws XAException {
                if (flags == 0x20000000) {
                    try {
                        transaction.setRollbackOnly();
                    }
                    catch (IllegalStateException e) {
                        throw Log.log.notActiveXA(-5);
                    }
                    catch (SystemException e) {
                        throw Log.log.rollbackOnlyFailed(-3, e);
                    }
                }
            }

            @Override
            public void beforeCompletion() throws XAException {
                xaImporter.beforeComplete(xid);
            }

            @Override
            public int prepare() throws XAException {
                return xaImporter.prepare(xid);
            }

            @Override
            public void forget() throws XAException {
                xaImporter.forget(xid);
            }

            @Override
            public void commit(boolean onePhase) throws XAException {
                xaImporter.commit(xid, onePhase);
            }
        }, result.isNew());
    }

    @NotNull
    public XARecoverable getRecoveryInterface() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)((Object)TransactionPermission.forName("getRecoveryInterface")));
        }
        final XAImporter xaImporter = this.provider.getXAImporter();
        return new XARecoverable(){

            @Override
            public Xid[] recover(int flag) throws XAException {
                return xaImporter.recover(flag);
            }

            @Override
            public void commit(Xid xid, boolean onePhase) throws XAException {
                xaImporter.commit(xid, onePhase);
            }

            @Override
            public void forget(Xid xid) throws XAException {
                xaImporter.forget(xid);
            }
        };
    }

    LocalTransactionProvider getProvider() {
        return this.provider;
    }

    static {
        AccessController.doPrivileged(() -> {
            CONTEXT_MANAGER.setGlobalDefault((Contextual)new LocalTransactionContext(LocalTransactionProvider.EMPTY));
            return null;
        });
    }
}

