/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import java.util.concurrent.atomic.AtomicInteger;

final class OutflowHandleManager {
    static final int FL_COMMITTED = Integer.MIN_VALUE;
    static final int FL_CONFIRMED = 0x40000000;
    static final int FL_NON_MASTER = 0x20000000;
    static final int FLAGS = -536870912;

    OutflowHandleManager() {
    }

    static int count(int val) {
        return val & 0x1FFFFFFF;
    }

    static int flags(int val) {
        return val & 0xE0000000;
    }

    static boolean isSet(int val, int flags) {
        return (val & flags) == flags;
    }

    static boolean open(AtomicInteger stateRef) {
        int newVal;
        int oldVal;
        do {
            if (OutflowHandleManager.isSet(oldVal = stateRef.get(), Integer.MIN_VALUE)) {
                return false;
            }
            if (!OutflowHandleManager.isSet(oldVal, 0x40000000)) continue;
            return true;
        } while (!stateRef.compareAndSet(oldVal, newVal = oldVal + 1));
        return true;
    }

    static boolean commit(AtomicInteger stateRef) {
        int newVal;
        int oldVal;
        while (!OutflowHandleManager.isSet(oldVal = stateRef.get(), Integer.MIN_VALUE) && !stateRef.compareAndSet(oldVal, newVal = OutflowHandleManager.isSet(oldVal, 0x40000000) ? Integer.MIN_VALUE | OutflowHandleManager.flags(oldVal) : (OutflowHandleManager.count(oldVal) > 0 ? -1073741824 : Integer.MIN_VALUE))) {
        }
        return OutflowHandleManager.isSet(oldVal, 0x40000000) && !OutflowHandleManager.isSet(oldVal, 0x20000000);
    }

    static void verifyOne(AtomicInteger stateRef) {
        int newVal;
        int oldVal;
        do {
            if (OutflowHandleManager.isSet(oldVal = stateRef.get(), Integer.MIN_VALUE)) {
                return;
            }
            if (!OutflowHandleManager.isSet(oldVal, 0x40000000)) continue;
            return;
        } while (!stateRef.compareAndSet(oldVal, newVal = 0x40000000));
    }

    static void forgetOne(AtomicInteger stateRef) {
        int newVal;
        int oldVal;
        do {
            if (OutflowHandleManager.isSet(oldVal = stateRef.get(), Integer.MIN_VALUE)) {
                return;
            }
            if (!OutflowHandleManager.isSet(oldVal, 0x40000000)) continue;
            return;
        } while (!stateRef.compareAndSet(oldVal, newVal = OutflowHandleManager.isSet(oldVal, 0x20000000) && OutflowHandleManager.count(oldVal) == 1 ? 0x60000000 : oldVal - 1));
    }

    static void nonMasterOne(AtomicInteger stateRef) {
        int newVal;
        int oldVal;
        do {
            if (OutflowHandleManager.isSet(oldVal = stateRef.get(), Integer.MIN_VALUE)) {
                return;
            }
            if (!OutflowHandleManager.isSet(oldVal, 0x40000000)) continue;
            return;
        } while (!stateRef.compareAndSet(oldVal, newVal = OutflowHandleManager.count(oldVal) == 1 ? 0x60000000 : oldVal - 1 | 0x20000000));
    }
}

