/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.SubordinateXAResource;
import org.wildfly.transaction.client.SynchronizationException;
import org.wildfly.transaction.client._private.Log;

final class XAOutflowedResources {
    private final LocalTransaction transaction;
    private final ConcurrentMap<URI, SubordinateXAResource> enlistments = new ConcurrentHashMap<URI, SubordinateXAResource>();

    XAOutflowedResources(LocalTransaction transaction) {
        this.transaction = transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SubordinateXAResource getOrEnlist(URI location) throws SystemException, RollbackException {
        SubordinateXAResource xaResource = (SubordinateXAResource)this.enlistments.get(location);
        if (xaResource != null) {
            return xaResource;
        }
        XAOutflowedResources xAOutflowedResources = this;
        synchronized (xAOutflowedResources) {
            xaResource = (SubordinateXAResource)this.enlistments.get(location);
            if (xaResource != null) {
                return xaResource;
            }
            xaResource = new SubordinateXAResource(location);
            if (!this.transaction.enlistResource(xaResource)) {
                throw Log.log.couldNotEnlist();
            }
            final SubordinateXAResource finalXaResource = xaResource;
            this.transaction.registerSynchronization(new Synchronization(){

                public void beforeCompletion() {
                    try {
                        if (finalXaResource.commit()) {
                            finalXaResource.beforeCompletion(finalXaResource.getXid());
                        } else {
                            try {
                                XAOutflowedResources.this.transaction.delistResource(finalXaResource, 0x4000000);
                            }
                            catch (SystemException systemException) {}
                        }
                    }
                    catch (XAException e) {
                        throw new SynchronizationException(e);
                    }
                }

                public void afterCompletion(int status) {
                }
            });
            this.enlistments.put(location, xaResource);
            return xaResource;
        }
    }

    LocalTransaction getTransaction() {
        return this.transaction;
    }
}

