/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client.provider.jboss;

import javax.resource.spi.XATerminator;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.tm.ExtendedJBossXATerminator;
import org.jboss.tm.ImportedTransaction;
import org.jboss.tm.TransactionImportResult;
import org.wildfly.common.Assert;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.transaction.client.XAImporter;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.spi.LocalTransactionProvider;

public final class JBossLocalTransactionProvider
implements LocalTransactionProvider {
    private final ExtendedJBossXATerminator ext;
    private final XATerminator xt;
    private final TransactionManager tm;
    private final TransactionSynchronizationRegistry tsr;
    private final XAImporter xi = new XAImporterImpl();

    public JBossLocalTransactionProvider(XATerminator xt, ExtendedJBossXATerminator ext, TransactionManager tm, TransactionSynchronizationRegistry tsr) {
        this.ext = (ExtendedJBossXATerminator)Assert.checkNotNullParam((String)"ext", (Object)ext);
        this.xt = (XATerminator)Assert.checkNotNullParam((String)"xt", (Object)xt);
        this.tm = (TransactionManager)Assert.checkNotNullParam((String)"tm", (Object)tm);
        this.tsr = (TransactionSynchronizationRegistry)Assert.checkNotNullParam((String)"tsr", (Object)tsr);
    }

    @Override
    @NotNull
    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    @Override
    @NotNull
    public XAImporter getXAImporter() {
        return this.xi;
    }

    @Override
    @NotNull
    public Transaction createNewTransaction(int timeout) throws SystemException, SecurityException {
        Transaction suspended = this.tm.suspend();
        try {
            this.tm.begin();
            return this.tm.suspend();
        }
        catch (NotSupportedException e) {
            throw Log.log.unexpectedFailure(e);
        }
        catch (Throwable t) {
            try {
                this.tm.resume(suspended);
            }
            catch (InvalidTransactionException e) {
                e.addSuppressed(t);
                throw Log.log.unexpectedFailure(e);
            }
            throw t;
        }
    }

    @Override
    public boolean isImported(@NotNull Transaction transaction) throws IllegalArgumentException {
        return transaction instanceof ImportedTransaction;
    }

    @Override
    public void registerInterposedSynchronization(@NotNull Transaction transaction, @NotNull Synchronization sync) throws IllegalArgumentException {
        this.tsr.registerInterposedSynchronization(sync);
    }

    @Override
    public Object getResource(@NotNull Transaction transaction, @NotNull Object key) {
        assert (this.safeGetTransaction() != transaction);
        return this.tsr.getResource(key);
    }

    private Transaction safeGetTransaction() {
        try {
            return this.tm.getTransaction();
        }
        catch (SystemException e) {
            throw Log.log.unexpectedFailure(e);
        }
    }

    @Override
    public void putResource(@NotNull Transaction transaction, @NotNull Object key, Object value) throws IllegalArgumentException {
        assert (this.safeGetTransaction() != transaction);
        this.tsr.putResource(key, value);
    }

    @Override
    public boolean getRollbackOnly(@NotNull Transaction transaction) throws IllegalArgumentException {
        assert (this.safeGetTransaction() != transaction);
        return this.tsr.getRollbackOnly();
    }

    @Override
    @NotNull
    public Object getKey(@NotNull Transaction transaction) throws IllegalArgumentException {
        assert (this.safeGetTransaction() != transaction);
        return this.tsr.getTransactionKey();
    }

    final class XAImporterImpl
    implements XAImporter {
        XAImporterImpl() {
        }

        @Override
        @NotNull
        public XAImporter.ProviderImportResult findOrImportTransaction(Xid xid, int timeout) throws XAException {
            TransactionImportResult result = JBossLocalTransactionProvider.this.ext.importTransaction(xid, timeout);
            return new XAImporter.ProviderImportResult((Transaction)result.getTransaction(), result.isNewImportedTransaction());
        }

        @Override
        public Transaction findExistingTransaction(Xid xid) throws XAException {
            return JBossLocalTransactionProvider.this.ext.getTransaction(xid);
        }

        @Override
        public void beforeComplete(Xid xid) throws XAException {
            ImportedTransaction importedTransaction = this.requireTxn(xid);
            try {
                if (!importedTransaction.doBeforeCompletion()) {
                    throw Log.log.beforeCompletionFailed(null, null);
                }
            }
            catch (SystemException e) {
                throw Log.log.beforeCompletionFailed(e, null);
            }
        }

        @Override
        public void commit(Xid xid, boolean onePhase) throws XAException {
            JBossLocalTransactionProvider.this.xt.commit(xid, onePhase);
        }

        @Override
        public void forget(Xid xid) throws XAException {
            JBossLocalTransactionProvider.this.xt.forget(xid);
        }

        @Override
        public int prepare(Xid xid) throws XAException {
            return JBossLocalTransactionProvider.this.xt.prepare(xid);
        }

        @Override
        public void rollback(Xid xid) throws XAException {
            JBossLocalTransactionProvider.this.xt.rollback(xid);
        }

        @Override
        @NotNull
        public Xid[] recover(int flag) throws XAException {
            return JBossLocalTransactionProvider.this.xt.recover(flag);
        }

        private ImportedTransaction requireTxn(Xid xid) throws XAException {
            ImportedTransaction importedTransaction = JBossLocalTransactionProvider.this.ext.getImportedTransaction(xid);
            if (importedTransaction == null) {
                throw Log.log.notActiveXA(-4);
            }
            return importedTransaction;
        }
    }
}

