/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client.provider.remoting;

import java.io.IOException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3._private.IntIndexHashMap;
import org.jboss.remoting3._private.IntIndexMap;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.transaction.client.ImportResult;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.LocalTransactionContext;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.provider.remoting.RemotingTransactionService;
import org.wildfly.transaction.client.provider.remoting.TransactionServerChannel;
import org.wildfly.transaction.client.spi.SubordinateTransactionControl;

public final class RemotingTransactionServer {
    private final RemotingTransactionService transactionService;
    private final Connection connection;
    private final IntIndexMap<Txn> txns = new IntIndexHashMap(Txn::getId);

    RemotingTransactionServer(RemotingTransactionService transactionService, Connection connection) {
        this.transactionService = transactionService;
        this.connection = connection;
        connection.addCloseHandler(this::handleClosed);
    }

    @NotNull
    public LocalTransaction requireTransaction(int id) throws SystemException {
        Txn txn = (Txn)this.txns.get(id);
        if (txn == null) {
            throw Log.log.noTransactionForId(id);
        }
        return txn.getTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public LocalTransaction getOrBeginTransaction(int id, int timeout) throws SystemException {
        Txn txn = (Txn)this.txns.get(id);
        if (txn != null) {
            return txn.getTransaction();
        }
        boolean ok = false;
        LocalTransaction transaction = this.transactionService.getTransactionContext().beginTransaction(timeout);
        try {
            Txn appearing = (Txn)this.txns.putIfAbsent((Object)new LocalTxn(id, transaction));
            if (appearing != null) {
                LocalTransaction localTransaction = appearing.getTransaction();
                return localTransaction;
            }
            ok = true;
            LocalTransaction localTransaction = transaction;
            return localTransaction;
        }
        finally {
            if (!ok) {
                RemotingTransactionServer.safeRollback(transaction);
            }
        }
    }

    public LocalTransaction getTransactionIfExists(int id) {
        Txn txn = (Txn)this.txns.get(id);
        return txn == null ? null : txn.getTransaction();
    }

    void handleClosed(Connection connection, IOException ignored) {
        for (Txn txn : this.txns) {
            if (!(txn instanceof LocalTxn)) continue;
            RemotingTransactionServer.safeRollback(txn.getTransaction());
        }
    }

    static void safeRollback(Transaction transaction) {
        if (transaction != null) {
            try {
                transaction.rollback();
            }
            catch (SystemException e) {
                Log.log.trace("Got exception during rollback-on-disconnect", e);
            }
        }
    }

    IntIndexMap<Txn> getTxnMap() {
        return this.txns;
    }

    public RemotingTransactionService getTransactionService() {
        return this.transactionService;
    }

    TransactionServerChannel openChannel(Channel channel) {
        TransactionServerChannel transactionServerChannel = new TransactionServerChannel(this, channel, this.transactionService.getTransactionContext());
        transactionServerChannel.start();
        return transactionServerChannel;
    }

    static class ImportedTxn
    extends Txn {
        private final LocalTransactionContext transactionContext;
        private final Xid xid;
        private final long startTime;
        private final int timeout;
        private volatile ImportResult importResult;

        ImportedTxn(int id, LocalTransactionContext transactionContext, Xid xid, int timeout) {
            super(id);
            this.transactionContext = transactionContext;
            this.xid = xid;
            this.startTime = System.nanoTime();
            this.timeout = timeout;
        }

        Xid getXid() {
            return this.xid;
        }

        @Override
        LocalTransaction getTransaction() {
            ImportResult importResult = this.importResult;
            return importResult == null ? null : importResult.getTransaction();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ImportResult getOrImport() throws XAException {
            ImportResult importResult = this.importResult;
            if (importResult != null) {
                return importResult;
            }
            ImportedTxn importedTxn = this;
            synchronized (importedTxn) {
                importResult = this.importResult;
                if (importResult != null) {
                    return importResult;
                }
                long elapsed = Math.max(0L, System.nanoTime() - this.startTime) / 1000000000L;
                if (elapsed >= (long)this.timeout) {
                    throw Log.log.transactionTimedOut(106);
                }
                this.importResult = importResult = this.transactionContext.findOrImportTransaction(this.xid, Math.max(1, this.timeout - (int)Math.min(Integer.MAX_VALUE, elapsed)));
                return importResult;
            }
        }

        SubordinateTransactionControl getControl() throws XAException {
            return this.getOrImport().getControl();
        }

        @Override
        ExceptionSupplier<LocalTransaction, XAException> getTransactionSupplier() {
            return () -> this.getOrImport().getTransaction();
        }
    }

    static final class LocalTxn
    extends Txn {
        private final LocalTransaction transaction;

        LocalTxn(int id, LocalTransaction transaction) {
            super(id);
            this.transaction = transaction;
        }

        @Override
        LocalTransaction getTransaction() {
            return this.transaction;
        }

        @Override
        ExceptionSupplier<LocalTransaction, XAException> getTransactionSupplier() {
            return this::getTransaction;
        }
    }

    static abstract class Txn {
        private final int id;

        Txn(int id) {
            this.id = id;
        }

        int getId() {
            return this.id;
        }

        abstract LocalTransaction getTransaction();

        abstract ExceptionSupplier<LocalTransaction, XAException> getTransactionSupplier();
    }
}

