/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client.provider.remoting;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.util.MessageTracker;
import org.jboss.remoting3.util.StreamUtils;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.LocalTransactionContext;
import org.wildfly.transaction.client.SimpleXid;
import org.wildfly.transaction.client.XARecoverable;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.provider.remoting.Protocol;
import org.wildfly.transaction.client.provider.remoting.RemotingTransactionServer;

final class TransactionServerChannel {
    private final RemotingTransactionServer server;
    private final MessageTracker messageTracker;
    private final Channel channel;
    private final Channel.Receiver receiver = new ReceiverImpl();
    private final LocalTransactionContext localTransactionContext;
    private static final Attachments.Key<TransactionServerChannel> KEY = new Attachments.Key(TransactionServerChannel.class);

    TransactionServerChannel(RemotingTransactionServer server, Channel channel, LocalTransactionContext localTransactionContext) {
        this.server = server;
        this.channel = channel;
        this.localTransactionContext = localTransactionContext;
        this.messageTracker = new MessageTracker(channel, ((Integer)channel.getOption(RemotingOptions.MAX_OUTBOUND_MESSAGES)).intValue());
        channel.getConnection().getAttachments().attach(KEY, (Object)this);
    }

    void start() {
        this.channel.receiveMessage(this.receiver);
    }

    void handleCapabilityMessage(MessageInputStream message, int invId) throws IOException {
        while (message.read() != -1) {
            Protocol.readIntParam((InputStream)message, StreamUtils.readPackedUnsignedInt32((InputStream)message));
        }
        try (MessageOutputStream outputStream = this.messageTracker.openMessageUninterruptibly();){
            outputStream.writeByte(0);
            outputStream.writeShort(invId);
        }
    }

    void handleUserTxnRollback(MessageInputStream message, int invId) throws IOException {
        int param;
        int context = 0;
        int secContext = 0;
        boolean hasContext = false;
        boolean hasSecContext = false;
        block4: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32((InputStream)message);
            switch (param) {
                case 241: {
                    context = message.readInt();
                    hasContext = true;
                    continue block4;
                }
                case 240: {
                    secContext = message.readInt();
                    hasSecContext = true;
                    continue block4;
                }
            }
            Protocol.readIntParam((InputStream)message, len);
        }
        if (!hasContext) {
            this.writeParamError(invId);
            return;
        }
        RemotingTransactionServer.Txn txn = (RemotingTransactionServer.Txn)this.server.getTxnMap().removeKey(context);
        if (txn == null) {
            this.writeParamError(invId);
            return;
        }
        SecurityIdentity securityIdentity = hasSecContext ? this.channel.getConnection().getLocalIdentity(secContext) : this.channel.getConnection().getLocalIdentity();
        securityIdentity.runAs(() -> {
            LocalTransaction transaction = txn.getTransaction();
            if (transaction != null) {
                try {
                    transaction.rollback();
                    this.writeSimpleResponse(26, invId);
                }
                catch (SystemException e) {
                    this.writeSimpleResponse(26, invId, 19);
                    return;
                }
            } else {
                this.writeParamError(invId);
            }
        });
    }

    void handleUserTxnCommit(MessageInputStream message, int invId) throws IOException {
        int param;
        int context = 0;
        int secContext = 0;
        boolean hasContext = false;
        boolean hasSecContext = false;
        block4: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32((InputStream)message);
            switch (param) {
                case 241: {
                    context = message.readInt();
                    hasContext = true;
                    continue block4;
                }
                case 240: {
                    secContext = message.readInt();
                    hasSecContext = true;
                    continue block4;
                }
            }
            Protocol.readIntParam((InputStream)message, len);
        }
        if (!hasContext) {
            this.writeParamError(invId);
            return;
        }
        RemotingTransactionServer.Txn txn = (RemotingTransactionServer.Txn)this.server.getTxnMap().removeKey(context);
        if (txn == null) {
            this.writeParamError(invId);
            return;
        }
        SecurityIdentity securityIdentity = hasSecContext ? this.channel.getConnection().getLocalIdentity(secContext) : this.channel.getConnection().getLocalIdentity();
        securityIdentity.runAs(() -> {
            LocalTransaction transaction = txn.getTransaction();
            if (transaction != null) {
                try {
                    transaction.commit();
                    this.writeSimpleResponse(26, invId);
                }
                catch (SystemException e) {
                    this.writeSimpleResponse(26, invId, 19);
                    return;
                }
                catch (HeuristicRollbackException e) {
                    this.writeSimpleResponse(26, invId, 18);
                    return;
                }
                catch (RollbackException e) {
                    this.writeSimpleResponse(26, invId, 16);
                    return;
                }
                catch (HeuristicMixedException e) {
                    this.writeSimpleResponse(26, invId, 17);
                    return;
                }
            } else {
                this.writeParamError(invId);
            }
        });
    }

    void handleXaTxnRollback(MessageInputStream message, int invId) throws IOException {
        int param;
        SimpleXid xid = null;
        int secContext = 0;
        boolean hasSecContext = false;
        block4: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32((InputStream)message);
            switch (param) {
                case 1: {
                    xid = Protocol.readXid((InputStream)message, len);
                    continue block4;
                }
                case 240: {
                    secContext = message.readInt();
                    hasSecContext = true;
                    continue block4;
                }
            }
            Protocol.readIntParam((InputStream)message, len);
        }
        if (xid == null) {
            this.writeParamError(invId);
            return;
        }
        SecurityIdentity securityIdentity = hasSecContext ? this.channel.getConnection().getLocalIdentity(secContext) : this.channel.getConnection().getLocalIdentity();
        securityIdentity.runAsObjIntConsumer((x, i) -> {
            try {
                this.localTransactionContext.findOrImportTransaction((Xid)x, 0).getControl().rollback();
                this.writeSimpleResponse(18, i);
            }
            catch (XAException e) {
                this.writeXaExceptionResponse(18, i, e.errorCode);
                return;
            }
        }, (Object)xid.withoutBranch(), invId);
    }

    void handleXaTxnRollbackOnly(MessageInputStream message, int invId) throws IOException {
        int param;
        SimpleXid xid = null;
        int secContext = 0;
        boolean hasSecContext = false;
        block4: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32((InputStream)message);
            switch (param) {
                case 1: {
                    xid = Protocol.readXid((InputStream)message, len);
                    continue block4;
                }
                case 240: {
                    secContext = message.readInt();
                    hasSecContext = true;
                    continue block4;
                }
            }
            Protocol.readIntParam((InputStream)message, len);
        }
        if (xid == null) {
            this.writeParamError(invId);
            return;
        }
        SecurityIdentity securityIdentity = hasSecContext ? this.channel.getConnection().getLocalIdentity(secContext) : this.channel.getConnection().getLocalIdentity();
        securityIdentity.runAsObjIntConsumer((x, i) -> {
            try {
                this.localTransactionContext.findOrImportTransaction((Xid)x, 0).getControl().end(0x20000000);
                this.writeSimpleResponse(18, i);
            }
            catch (XAException e) {
                this.writeXaExceptionResponse(18, i, e.errorCode);
                return;
            }
        }, (Object)xid.withoutBranch(), invId);
    }

    void handleXaTxnBefore(MessageInputStream message, int invId) throws IOException {
        int param;
        SimpleXid xid = null;
        int secContext = 0;
        boolean hasSecContext = false;
        block4: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32((InputStream)message);
            switch (param) {
                case 1: {
                    xid = Protocol.readXid((InputStream)message, len);
                    continue block4;
                }
                case 240: {
                    secContext = message.readInt();
                    hasSecContext = true;
                    continue block4;
                }
            }
            Protocol.readIntParam((InputStream)message, len);
        }
        if (xid == null) {
            this.writeParamError(invId);
            return;
        }
        SecurityIdentity securityIdentity = hasSecContext ? this.channel.getConnection().getLocalIdentity(secContext) : this.channel.getConnection().getLocalIdentity();
        securityIdentity.runAsObjIntConsumer((x, i) -> {
            try {
                this.localTransactionContext.findOrImportTransaction((Xid)x, 0).getControl().beforeCompletion();
                this.writeSimpleResponse(22, i);
            }
            catch (XAException e) {
                this.writeXaExceptionResponse(22, i, e.errorCode);
                return;
            }
        }, (Object)xid.withoutBranch(), invId);
    }

    void handleXaTxnPrepare(MessageInputStream message, int invId) throws IOException {
        int param;
        SimpleXid xid = null;
        int secContext = 0;
        boolean hasSecContext = false;
        block4: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32((InputStream)message);
            switch (param) {
                case 1: {
                    xid = Protocol.readXid((InputStream)message, len);
                    continue block4;
                }
                case 240: {
                    secContext = message.readInt();
                    hasSecContext = true;
                    continue block4;
                }
            }
            Protocol.readIntParam((InputStream)message, len);
        }
        if (xid == null) {
            this.writeParamError(invId);
            return;
        }
        SecurityIdentity securityIdentity = hasSecContext ? this.channel.getConnection().getLocalIdentity(secContext) : this.channel.getConnection().getLocalIdentity();
        securityIdentity.runAsObjIntConsumer((x, i) -> {
            try {
                int result = this.localTransactionContext.findOrImportTransaction((Xid)x, 0).getControl().prepare();
                if (result == 3) {
                    this.writeSimpleResponse(22, i, 7);
                } else {
                    this.writeSimpleResponse(22, i);
                }
            }
            catch (XAException e) {
                this.writeXaExceptionResponse(22, i, e.errorCode);
                return;
            }
        }, (Object)xid.withoutBranch(), invId);
    }

    void handleXaTxnForget(MessageInputStream message, int invId) throws IOException {
        int param;
        SimpleXid xid = null;
        int secContext = 0;
        boolean hasContext = false;
        boolean hasSecContext = false;
        block4: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32((InputStream)message);
            switch (param) {
                case 1: {
                    xid = Protocol.readXid((InputStream)message, len);
                    continue block4;
                }
                case 240: {
                    secContext = message.readInt();
                    hasSecContext = true;
                    continue block4;
                }
            }
            Protocol.readIntParam((InputStream)message, len);
        }
        if (xid == null) {
            this.writeParamError(invId);
            return;
        }
        SecurityIdentity securityIdentity = hasSecContext ? this.channel.getConnection().getLocalIdentity(secContext) : this.channel.getConnection().getLocalIdentity();
        securityIdentity.runAsObjIntConsumer((x, i) -> {
            try {
                this.localTransactionContext.getRecoveryInterface().forget((Xid)x);
                this.writeSimpleResponse(21, i);
            }
            catch (XAException e) {
                this.writeXaExceptionResponse(21, i, e.errorCode);
                return;
            }
        }, (Object)xid, invId);
    }

    void handleXaTxnCommit(MessageInputStream message, int invId) throws IOException {
        int param;
        SimpleXid xid = null;
        int secContext = 0;
        boolean hasContext = false;
        boolean hasSecContext = false;
        boolean onePhase = false;
        block5: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32((InputStream)message);
            switch (param) {
                case 1: {
                    xid = Protocol.readXid((InputStream)message, len);
                    continue block5;
                }
                case 240: {
                    secContext = message.readInt();
                    hasSecContext = true;
                    continue block5;
                }
                case 2: {
                    onePhase = true;
                    Protocol.readIntParam((InputStream)message, len);
                    continue block5;
                }
            }
            Protocol.readIntParam((InputStream)message, len);
        }
        if (xid == null) {
            this.writeParamError(invId);
            return;
        }
        SecurityIdentity securityIdentity = hasSecContext ? this.channel.getConnection().getLocalIdentity(secContext) : this.channel.getConnection().getLocalIdentity();
        securityIdentity.runAsConsumer((o, x) -> {
            try {
                this.localTransactionContext.getRecoveryInterface().commit((Xid)x, (boolean)o);
                this.writeSimpleResponse(20, invId);
            }
            catch (XAException e) {
                this.writeXaExceptionResponse(20, invId, e.errorCode);
            }
        }, (Object)onePhase, (Object)xid.withoutBranch());
    }

    void handleXaTxnRecover(MessageInputStream message, int invId) throws IOException {
        int param;
        int secContext = 0;
        boolean hasSecContext = false;
        block3: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32((InputStream)message);
            switch (param) {
                case 240: {
                    secContext = message.readInt();
                    hasSecContext = true;
                    continue block3;
                }
            }
            Protocol.readIntParam((InputStream)message, len);
        }
        SecurityIdentity securityIdentity = hasSecContext ? this.channel.getConnection().getLocalIdentity(secContext) : this.channel.getConnection().getLocalIdentity();
        securityIdentity.runAs(() -> {
            Xid[] xids;
            XARecoverable recoverable = this.localTransactionContext.getRecoveryInterface();
            try {
                xids = recoverable.recover(0x1000000);
            }
            catch (XAException e) {
                this.writeXaExceptionResponse(23, invId, e.errorCode);
                return;
            }
            try (MessageOutputStream outputStream = this.messageTracker.openMessageUninterruptibly();){
                SimpleXid simpleXid;
                boolean added;
                outputStream.writeByte(23);
                outputStream.writeShort(invId);
                HashSet<SimpleXid> seen = new HashSet<SimpleXid>();
                do {
                    added = false;
                    for (Xid xid : xids) {
                        simpleXid = SimpleXid.of(xid).withoutBranch();
                        if (!seen.add(simpleXid)) continue;
                        added = true;
                        Protocol.writeParam(1, (OutputStream)outputStream, simpleXid);
                    }
                    if (!added) continue;
                    try {
                        xids = recoverable.recover(0);
                    }
                    catch (XAException e) {
                        Protocol.writeParam(48, (OutputStream)outputStream, e.errorCode, true);
                        try {
                            recoverable.recover(0x800000);
                        }
                        catch (XAException e1) {
                            Log.log.recoverySuppressedException(e1);
                        }
                        if (outputStream != null) {
                            if (var5_7 != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (Throwable throwable) {
                                    var5_7.addSuppressed(throwable);
                                }
                            } else {
                                outputStream.close();
                            }
                        }
                        return;
                    }
                } while (xids.length > 0 && added);
                try {
                    xids = recoverable.recover(0x800000);
                }
                catch (XAException e) {
                    Protocol.writeParam(48, (OutputStream)outputStream, e.errorCode, true);
                    if (outputStream != null) {
                        if (var5_7 != null) {
                            try {
                                outputStream.close();
                            }
                            catch (Throwable throwable) {
                                var5_7.addSuppressed(throwable);
                            }
                        } else {
                            outputStream.close();
                        }
                    }
                    return;
                }
                for (Xid xid : xids) {
                    simpleXid = SimpleXid.of(xid).withoutBranch();
                    if (!seen.add(simpleXid)) continue;
                    Protocol.writeParam(1, (OutputStream)outputStream, xid);
                }
            }
            catch (IOException e) {
                Log.log.outboundException(e);
                try {
                    recoverable.recover(0x800000);
                }
                catch (XAException e1) {
                    Log.log.recoverySuppressedException(e1);
                }
            }
        });
    }

    void writeSimpleResponse(int msgId, int invId, int param1) {
        try (MessageOutputStream outputStream = this.messageTracker.openMessageUninterruptibly();){
            outputStream.writeByte(msgId);
            outputStream.writeShort(invId);
            Protocol.writeParam(param1, (OutputStream)outputStream);
        }
        catch (IOException e) {
            Log.log.outboundException(e);
        }
    }

    void writeXaExceptionResponse(int msgId, int invId, int errorCode) {
        try (MessageOutputStream outputStream = this.messageTracker.openMessageUninterruptibly();){
            outputStream.writeByte(msgId);
            outputStream.writeShort(invId);
            Protocol.writeParam(48, (OutputStream)outputStream, errorCode, true);
        }
        catch (IOException e) {
            Log.log.outboundException(e);
        }
    }

    void writeSimpleResponse(int msgId, int invId) {
        try (MessageOutputStream outputStream = this.messageTracker.openMessageUninterruptibly();){
            outputStream.writeByte(msgId);
            outputStream.writeShort(invId);
        }
        catch (IOException e) {
            Log.log.outboundException(e);
        }
    }

    void writeParamError(int invId) {
        try (MessageOutputStream outputStream = this.messageTracker.openMessageUninterruptibly();){
            outputStream.writeByte(254);
            outputStream.writeShort(invId);
        }
        catch (IOException e) {
            Log.log.outboundException(e);
        }
    }

    static /* synthetic */ MessageTracker access$000(TransactionServerChannel x0) {
        return x0.messageTracker;
    }

    class ReceiverImpl
    implements Channel.Receiver {
        ReceiverImpl() {
        }

        /*
         * Unable to fully structure code
         */
        public void handleMessage(Channel channel, MessageInputStream messageOriginal) {
            try {
                message = messageOriginal;
                var4_5 = null;
                try {
                    id = message.readUnsignedByte();
                    invId = message.readUnsignedShort();
                    switch (id) {
                        case 0: {
                            TransactionServerChannel.this.handleCapabilityMessage(message, invId);
                            ** break;
lbl11:
                            // 1 sources

                            break;
                        }
                        case 11: {
                            TransactionServerChannel.this.handleUserTxnRollback(message, invId);
                            ** break;
lbl15:
                            // 1 sources

                            break;
                        }
                        case 10: {
                            TransactionServerChannel.this.handleUserTxnCommit(message, invId);
                            ** break;
lbl19:
                            // 1 sources

                            break;
                        }
                        case 2: {
                            TransactionServerChannel.this.handleXaTxnRollback(message, invId);
                            ** break;
lbl23:
                            // 1 sources

                            break;
                        }
                        case 6: {
                            TransactionServerChannel.this.handleXaTxnBefore(message, invId);
                            ** break;
lbl27:
                            // 1 sources

                            break;
                        }
                        case 3: {
                            TransactionServerChannel.this.handleXaTxnPrepare(message, invId);
                            ** break;
lbl31:
                            // 1 sources

                            break;
                        }
                        case 5: {
                            TransactionServerChannel.this.handleXaTxnForget(message, invId);
                            ** break;
lbl35:
                            // 1 sources

                            break;
                        }
                        case 4: {
                            TransactionServerChannel.this.handleXaTxnCommit(message, invId);
                            ** break;
lbl39:
                            // 1 sources

                            break;
                        }
                        case 7: {
                            TransactionServerChannel.this.handleXaTxnRecover(message, invId);
                            ** break;
lbl43:
                            // 1 sources

                            break;
                        }
                        case 8: {
                            TransactionServerChannel.this.handleXaTxnRollbackOnly(message, invId);
                            ** break;
lbl47:
                            // 1 sources

                            break;
                        }
                        default: {
                            try {
                                outputStream = TransactionServerChannel.access$000(TransactionServerChannel.this).openMessageUninterruptibly();
                                var8_12 = null;
                                outputStream.writeByte(255);
                                outputStream.writeShort(invId);
                                if (outputStream == null) break;
                                if (var8_12 == null) ** GOTO lbl65
                                try {
                                    outputStream.close();
                                    ** break;
lbl60:
                                    // 1 sources

                                }
                                catch (Throwable var9_13) {
                                    var8_12.addSuppressed(var9_13);
                                    ** break;
                                }
lbl64:
                                // 1 sources

                                break;
lbl65:
                                // 1 sources

                                outputStream.close();
                                ** break;
lbl67:
                                // 1 sources

                                break;
                                catch (Throwable var9_14) {
                                    try {
                                        var8_12 = var9_14;
                                        throw var9_14;
                                    }
                                    catch (Throwable var10_15) {
                                        if (outputStream != null) {
                                            if (var8_12 != null) {
                                                try {
                                                    outputStream.close();
                                                }
                                                catch (Throwable var11_16) {
                                                    var8_12.addSuppressed(var11_16);
                                                }
                                            } else {
                                                outputStream.close();
                                            }
                                        }
                                        throw var10_15;
                                    }
                                }
                            }
                            catch (IOException e) {
                                Log.log.outboundException(e);
                            }
                            break;
                        }
                    }
                }
                catch (Throwable var5_8) {
                    var4_5 = var5_8;
                    throw var5_8;
                }
                finally {
                    if (message != null) {
                        if (var4_5 != null) {
                            try {
                                message.close();
                            }
                            catch (Throwable var5_7) {
                                var4_5.addSuppressed(var5_7);
                            }
                        } else {
                            message.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                Log.log.inboundException(e);
            }
            channel.receiveMessage((Channel.Receiver)this);
        }

        public void handleError(Channel channel, IOException error) {
        }

        public void handleEnd(Channel channel) {
        }
    }
}

