/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client.provider.remoting;

import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.ConnectionPeerIdentity;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.ServiceNotFoundException;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.provider.remoting.RemotingFallbackPeerProvider;
import org.wildfly.transaction.client.provider.remoting.RemotingOperations;
import org.wildfly.transaction.client.provider.remoting.TransactionClientChannel;
import org.wildfly.transaction.client.spi.RemoteTransactionPeer;
import org.wildfly.transaction.client.spi.SimpleTransactionControl;
import org.wildfly.transaction.client.spi.SubordinateTransactionControl;

class RemotingRemoteTransactionPeer
implements RemoteTransactionPeer {
    private static final Attachments.Key<RemotingOperations> key = new Attachments.Key(RemotingOperations.class);
    private static final AuthenticationContextConfigurationClient CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    private final URI location;
    private final SSLContext sslContext;
    private final AuthenticationConfiguration authenticationConfiguration;
    private final Endpoint endpoint;
    private final RemotingFallbackPeerProvider fallbackProvider;
    private final Set<Xid> rollbackOnlyXids = new ConcurrentHashMap().keySet(Boolean.TRUE);

    RemotingRemoteTransactionPeer(URI location, SSLContext sslContext, AuthenticationConfiguration authenticationConfiguration, Endpoint endpoint, RemotingFallbackPeerProvider fallbackProvider) {
        this.location = location;
        this.sslContext = sslContext;
        this.authenticationConfiguration = authenticationConfiguration;
        this.endpoint = endpoint;
        this.fallbackProvider = fallbackProvider;
    }

    ConnectionPeerIdentity getPeerIdentity() throws IOException {
        SSLContext finalSslContext;
        if (this.sslContext == null) {
            try {
                finalSslContext = CLIENT.getSSLContext(this.location, AuthenticationContext.captureCurrent(), "jta", "jboss");
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
        } else {
            finalSslContext = this.sslContext;
        }
        AuthenticationConfiguration finalAuthenticationConfiguration = this.authenticationConfiguration == null ? CLIENT.getAuthenticationConfiguration(this.location, AuthenticationContext.captureCurrent(), -1, "jta", "jboss") : this.authenticationConfiguration;
        return (ConnectionPeerIdentity)this.endpoint.getConnectedIdentity(this.location, finalSslContext, finalAuthenticationConfiguration).get();
    }

    ConnectionPeerIdentity getPeerIdentityXA() throws XAException {
        try {
            return this.getPeerIdentity();
        }
        catch (IOException e) {
            throw Log.log.failedToAcquireConnectionXA(e, -3);
        }
    }

    @NotNull
    RemotingOperations getOperations(Connection connection) throws IOException {
        RemotingOperations operations;
        block8: {
            Attachments attachments = connection.getAttachments();
            operations = (RemotingOperations)attachments.getAttachment(key);
            if (operations != null) {
                return operations;
            }
            try {
                operations = TransactionClientChannel.forConnection(connection);
                RemotingOperations appearing = (RemotingOperations)attachments.attachIfAbsent(key, (Object)operations);
                if (appearing != null) {
                    return appearing;
                }
            }
            catch (ServiceNotFoundException e) {
                RemotingFallbackPeerProvider fallbackProvider = this.fallbackProvider;
                if (fallbackProvider == null) {
                    throw e;
                }
                try {
                    operations = fallbackProvider.getOperations(connection);
                }
                catch (ServiceNotFoundException e1) {
                    e1.addSuppressed((Throwable)e);
                    throw e1;
                }
                if (operations == null) {
                    throw e;
                }
                RemotingOperations appearing = (RemotingOperations)attachments.attachIfAbsent(key, (Object)operations);
                if (appearing == null) break block8;
                return appearing;
            }
        }
        return operations;
    }

    RemotingOperations getOperationsXA(Connection connection) throws XAException {
        try {
            return this.getOperations(connection);
        }
        catch (IOException e) {
            throw Log.log.failedToAcquireConnectionXA(e, -3);
        }
    }

    @Override
    @NotNull
    public SubordinateTransactionControl lookupXid(final Xid xid) throws XAException {
        return new SubordinateTransactionControl(){

            @Override
            public void rollback() throws XAException {
                try {
                    ConnectionPeerIdentity peerIdentity = RemotingRemoteTransactionPeer.this.getPeerIdentityXA();
                    RemotingRemoteTransactionPeer.this.getOperationsXA(peerIdentity.getConnection()).rollback(xid, peerIdentity);
                }
                finally {
                    RemotingRemoteTransactionPeer.this.rollbackOnlyXids.remove(xid);
                }
            }

            @Override
            public void end(int flags) throws XAException {
                if (flags == 0x20000000 && RemotingRemoteTransactionPeer.this.rollbackOnlyXids.add(xid)) {
                    try {
                        ConnectionPeerIdentity peerIdentity = RemotingRemoteTransactionPeer.this.getPeerIdentityXA();
                        RemotingRemoteTransactionPeer.this.getOperationsXA(peerIdentity.getConnection()).setRollbackOnly(xid, peerIdentity);
                    }
                    catch (Throwable t) {
                        RemotingRemoteTransactionPeer.this.rollbackOnlyXids.remove(xid);
                        throw t;
                    }
                }
            }

            @Override
            public void beforeCompletion() throws XAException {
                ConnectionPeerIdentity peerIdentity = RemotingRemoteTransactionPeer.this.getPeerIdentityXA();
                RemotingRemoteTransactionPeer.this.getOperationsXA(peerIdentity.getConnection()).beforeCompletion(xid, peerIdentity);
            }

            @Override
            public int prepare() throws XAException {
                try {
                    ConnectionPeerIdentity peerIdentity = RemotingRemoteTransactionPeer.this.getPeerIdentityXA();
                    int n = RemotingRemoteTransactionPeer.this.getOperationsXA(peerIdentity.getConnection()).prepare(xid, peerIdentity);
                    return n;
                }
                finally {
                    RemotingRemoteTransactionPeer.this.rollbackOnlyXids.remove(xid);
                }
            }

            @Override
            public void forget() throws XAException {
                try {
                    ConnectionPeerIdentity peerIdentity = RemotingRemoteTransactionPeer.this.getPeerIdentityXA();
                    RemotingRemoteTransactionPeer.this.getOperationsXA(peerIdentity.getConnection()).forget(xid, peerIdentity);
                }
                finally {
                    RemotingRemoteTransactionPeer.this.rollbackOnlyXids.remove(xid);
                }
            }

            @Override
            public void commit(boolean onePhase) throws XAException {
                try {
                    ConnectionPeerIdentity peerIdentity = RemotingRemoteTransactionPeer.this.getPeerIdentityXA();
                    RemotingRemoteTransactionPeer.this.getOperationsXA(peerIdentity.getConnection()).commit(xid, onePhase, peerIdentity);
                }
                finally {
                    RemotingRemoteTransactionPeer.this.rollbackOnlyXids.remove(xid);
                }
            }
        };
    }

    @Override
    @NotNull
    public Xid[] recover(int flag, String parentName) throws XAException {
        ConnectionPeerIdentity peerIdentity = this.getPeerIdentityXA();
        return this.getOperationsXA(peerIdentity.getConnection()).recover(flag, parentName, peerIdentity);
    }

    @Override
    @NotNull
    public SimpleTransactionControl begin(int timeout) throws SystemException {
        try {
            ConnectionPeerIdentity peerIdentity = this.getPeerIdentity();
            return this.getOperations(peerIdentity.getConnection()).begin(peerIdentity);
        }
        catch (IOException e) {
            throw Log.log.failedToAcquireConnection(e);
        }
    }
}

