/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client.naming.txn;

import java.util.Arrays;
import java.util.Collections;
import javax.naming.Binding;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.wildfly.naming.client.AbstractContext;
import org.wildfly.naming.client.CloseableNamingEnumeration;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.ContextTransactionSynchronizationRegistry;
import org.wildfly.transaction.client.LocalUserTransaction;
import org.wildfly.transaction.client.RemoteTransactionContext;
import org.wildfly.transaction.client.naming.txn.ReadOnlyBinding;
import org.wildfly.transaction.client.naming.txn.ReadOnlyNameClassPair;

class TxnNamingContext
extends AbstractContext {
    private static final String TRANSACTION_MANAGER = "TransactionManager";
    private static final String USER_TRANSACTION = "UserTransaction";
    private static final String TRANSACTION_SYNCHRONIZATION_REGISTRY = "TransactionSynchronizationRegistry";
    private final NamingProvider namingProvider;

    TxnNamingContext(NamingProvider namingProvider) {
        this.namingProvider = namingProvider;
    }

    protected Object lookupNative(Name name) throws NamingException {
        String str;
        switch (str = name.get(0)) {
            case "UserTransaction": {
                if (this.namingProvider != null) {
                    return this.getRemoteUserTransaction();
                }
                return LocalUserTransaction.getInstance();
            }
            case "TransactionManager": {
                if (this.namingProvider != null) break;
                return ContextTransactionManager.getInstance();
            }
            case "TransactionSynchronizationRegistry": {
                if (this.namingProvider != null) break;
                return ContextTransactionSynchronizationRegistry.getInstance();
            }
        }
        throw TxnNamingContext.nameNotFound((Name)name);
    }

    protected Object lookupLinkNative(Name name) throws NamingException {
        return this.lookupNative(name);
    }

    protected CloseableNamingEnumeration<NameClassPair> listNative(Name name) throws NamingException {
        if (!name.isEmpty()) {
            throw TxnNamingContext.nameNotFound((Name)name);
        }
        return CloseableNamingEnumeration.fromIterable(this.namingProvider == null ? Arrays.asList(this.nameClassPair(UserTransaction.class), this.nameClassPair(TransactionManager.class), this.nameClassPair(TransactionSynchronizationRegistry.class)) : Collections.singleton(this.nameClassPair(UserTransaction.class)));
    }

    protected CloseableNamingEnumeration<Binding> listBindingsNative(Name name) throws NamingException {
        if (!name.isEmpty()) {
            throw TxnNamingContext.nameNotFound((Name)name);
        }
        return CloseableNamingEnumeration.fromIterable(this.namingProvider == null ? Arrays.asList(this.binding(UserTransaction.class, LocalUserTransaction.getInstance()), this.binding(TransactionManager.class, ContextTransactionManager.getInstance()), this.binding(TransactionSynchronizationRegistry.class, ContextTransactionSynchronizationRegistry.getInstance())) : Collections.singleton(this.binding(UserTransaction.class, this.getRemoteUserTransaction())));
    }

    private NameClassPair nameClassPair(Class<?> clazz) {
        return new ReadOnlyNameClassPair(clazz.getSimpleName(), clazz.getName(), "txn:" + clazz.getSimpleName());
    }

    private <T> Binding binding(Class<T> clazz, T content) {
        return new ReadOnlyBinding(clazz.getSimpleName(), clazz.getName(), content, "txn:" + clazz.getSimpleName());
    }

    private UserTransaction getRemoteUserTransaction() {
        return RemoteTransactionContext.getInstance().getUserTransaction(this.namingProvider.getProviderUri(), this.namingProvider.getSSLContext(), this.namingProvider.getAuthenticationConfiguration());
    }

    public void close() throws NamingException {
    }

    public String getNameInNamespace() throws NamingException {
        return "";
    }
}

