/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import java.net.URI;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.wildfly.common.Assert;
import org.wildfly.common.context.ContextManager;
import org.wildfly.common.context.Contextual;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.RemoteUserTransaction;
import org.wildfly.transaction.client.SubordinateXAResource;
import org.wildfly.transaction.client.XAOutflowHandle;
import org.wildfly.transaction.client.XAOutflowedResources;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.spi.RemoteTransactionProvider;

public final class RemoteTransactionContext
implements Contextual<RemoteTransactionContext> {
    private static final RemoteTransactionProvider[] NO_PROVIDERS = new RemoteTransactionProvider[0];
    private final ConcurrentMap<URI, RemoteUserTransaction> userTransactions = new ConcurrentHashMap<URI, RemoteUserTransaction>();
    private final List<RemoteTransactionProvider> providers;
    private static final ContextManager<RemoteTransactionContext> CONTEXT_MANAGER = new ContextManager(RemoteTransactionContext.class, "org.wildfly.transaction.client.context.remote");
    private static final Supplier<RemoteTransactionContext> PRIVILEGED_SUPPLIER = AccessController.doPrivileged(() -> CONTEXT_MANAGER.getPrivilegedSupplier());
    private static final Object outflowKey = new Object();

    public RemoteTransactionContext(ClassLoader classLoader) {
        this(AccessController.doPrivileged(() -> {
            ServiceLoader<RemoteTransactionProvider> loader = ServiceLoader.load(RemoteTransactionProvider.class, classLoader);
            ArrayList<RemoteTransactionProvider> providers = new ArrayList<RemoteTransactionProvider>();
            Iterator<RemoteTransactionProvider> iterator = loader.iterator();
            while (true) {
                try {
                    while (iterator.hasNext()) {
                        providers.add(iterator.next());
                    }
                }
                catch (ServiceConfigurationError e) {
                    Log.log.serviceConfigurationFailed(e);
                    continue;
                }
                break;
            }
            providers.trimToSize();
            return providers;
        }), false);
    }

    public RemoteTransactionContext(List<RemoteTransactionProvider> providers) {
        this(providers, true);
    }

    RemoteTransactionContext(List<RemoteTransactionProvider> providers, boolean clone) {
        Assert.checkNotNullParam((String)"providers", providers);
        if (clone) {
            providers = Arrays.asList(providers.toArray(NO_PROVIDERS));
        }
        Assert.checkNotEmptyParam((String)"providers", providers);
        int size = providers.size();
        for (int i = 0; i < size; ++i) {
            Assert.checkNotNullArrayParam((String)"providers", (int)i, (Object)providers.get(i));
        }
        this.providers = providers;
    }

    public static ContextManager<RemoteTransactionContext> getContextManager() {
        return CONTEXT_MANAGER;
    }

    public ContextManager<RemoteTransactionContext> getInstanceContextManager() {
        return RemoteTransactionContext.getContextManager();
    }

    public static RemoteTransactionContext getInstance() {
        return (RemoteTransactionContext)RemoteTransactionContext.getContextManager().get();
    }

    static RemoteTransactionContext getInstancePrivate() {
        return PRIVILEGED_SUPPLIER.get();
    }

    public UserTransaction getUserTransaction(URI location) {
        Assert.checkNotNullParam((String)"location", (Object)location);
        return this.userTransactions.computeIfAbsent(location, RemoteUserTransaction::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAOutflowHandle outflowTransaction(URI location, LocalTransaction transaction) throws SystemException, IllegalStateException, UnsupportedOperationException, RollbackException {
        Assert.checkNotNullParam((String)"location", (Object)location);
        Assert.checkNotNullParam((String)"transaction", (Object)transaction);
        XAOutflowedResources outflowedResources = (XAOutflowedResources)transaction.getResource(outflowKey);
        if (outflowedResources == null) {
            Object object = transaction.getOutflowLock();
            synchronized (object) {
                outflowedResources = (XAOutflowedResources)transaction.getResource(outflowKey);
                if (outflowedResources == null) {
                    outflowedResources = new XAOutflowedResources(transaction);
                    transaction.putResource(outflowKey, outflowedResources);
                }
            }
        }
        SubordinateXAResource resource = outflowedResources.getOrEnlist(location, transaction.getParentName());
        return resource.addHandle(resource.getXid());
    }

    RemoteTransactionProvider getProvider(URI location) {
        for (RemoteTransactionProvider provider : this.providers) {
            if (!provider.supportsScheme(location.getScheme())) continue;
            return provider;
        }
        return null;
    }
}

