# WildFly Transaction Client

## About

WildFly Transaction Client is a library that facilitates integration of Narayana transaction manager with WildFly and its client libraries.

## Getting help

TODO

## Building

Prerequisites:

* JDK 11 or newer - check `java -version`
* Maven 3.6.0 or newer - check `mvn -v`

To build with your own Maven installation:

    mvn install

On Windows

    mvnw install


## Architecture


### Local Transactions 

Local transaction are transaction that are managed by a transaction manager collocated in the same JVM.  The most
important related interfaces:

* `org.wildfly.transaction.client.LocalTransactionProvider` implementation of this class contains all the methods which
* are necessary for the support of local transactions. Implementation of those classes provided are JBossJTALocalTransactionProvider
  and JBossJTSLocalTransactionProvider. Those implementations delegate to transaction manager present in WildFly runtime
  to provide all the functionalities required to transaction provisioning.
* `org.wildfly.transaction.client.LocalTransactionContext` manages creation and usage of local transaction. Delegates to
  underlying LocalTransactionProvider to perform operations specific to underlying transaction manager
* `org.wildfly.transaction.client.LocalTransaction` interface representing the local transaction

### Scenario 1: Container managed transaction in WildFly

    @Stateless
    public class Foo implements FooView {

    public void foo() {
        
    }

Let's suppose the above EJB is invoked from the servlet using local interface. We are going to trace how wildfly-transaction-client
classes are used in this scenario.

1. When WildFly server is started LocalTransactionContext is initialized with 
_
License
-------
* [GNU Lesser General Public License Version 2.1](http://www.gnu.org/licenses/lgpl-2.1-standalone.html)

