/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.wildfly.common.Assert;
import org.wildfly.transaction.client.AbstractTransaction;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.CreationListener;
import org.wildfly.transaction.client.LocalTransactionContext;
import org.wildfly.transaction.client.RemoteTransactionContext;
import org.wildfly.transaction.client.XAOutflowedResources;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.spi.LocalTransactionProvider;

public final class LocalTransaction
extends AbstractTransaction {
    private final LocalTransactionContext owner;
    private final Transaction transaction;

    LocalTransaction(LocalTransactionContext owner, Transaction transaction) {
        this.owner = owner;
        this.transaction = transaction;
    }

    @Override
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        if (this.isImported()) {
            throw Log.log.commitOnImported();
        }
        try {
            this.owner.getProvider().commitLocal(this.transaction);
        }
        catch (RollbackException re) {
            this.addRollbackExceptions((Exception)((Object)re));
            throw re;
        }
        finally {
            XAOutflowedResources outflowedResources = RemoteTransactionContext.getOutflowedResources(this);
            if (outflowedResources == null || outflowedResources.getEnlistedSubordinates() == 0) {
                this.owner.getProvider().dropLocal(this.transaction);
            } else {
                this.owner.getProvider().dropRemote(this.transaction);
            }
        }
    }

    @Override
    void commitAndDissociate() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        if (this.isImported()) {
            throw Log.log.commitOnImported();
        }
        this.notifyAssociationListeners(false);
        try {
            this.owner.getProvider().getTransactionManager().commit();
        }
        catch (RollbackException re) {
            this.addRollbackExceptions((Exception)((Object)re));
            throw re;
        }
        finally {
            XAOutflowedResources outflowedResources = RemoteTransactionContext.getOutflowedResources(this);
            if (outflowedResources == null || outflowedResources.getEnlistedSubordinates() == 0) {
                this.owner.getProvider().dropLocal(this.transaction);
            } else {
                this.owner.getProvider().dropRemote(this.transaction);
            }
        }
    }

    @Override
    public void rollback() throws IllegalStateException, SystemException {
        if (this.isImported()) {
            throw Log.log.rollbackOnImported();
        }
        try {
            this.owner.getProvider().rollbackLocal(this.transaction);
        }
        finally {
            XAOutflowedResources outflowedResources = RemoteTransactionContext.getOutflowedResources(this);
            if (outflowedResources == null || outflowedResources.getEnlistedSubordinates() == 0) {
                this.owner.getProvider().dropLocal(this.transaction);
            } else {
                this.owner.getProvider().dropRemote(this.transaction);
            }
        }
    }

    @Override
    void rollbackAndDissociate() throws IllegalStateException, SystemException {
        if (this.isImported()) {
            throw Log.log.rollbackOnImported();
        }
        this.notifyAssociationListeners(false);
        try {
            this.owner.getProvider().getTransactionManager().rollback();
        }
        finally {
            XAOutflowedResources outflowedResources = RemoteTransactionContext.getOutflowedResources(this);
            if (outflowedResources == null || outflowedResources.getEnlistedSubordinates() == 0) {
                this.owner.getProvider().dropLocal(this.transaction);
            } else {
                this.owner.getProvider().dropRemote(this.transaction);
            }
        }
    }

    @Override
    boolean importBacking() throws SystemException {
        ContextTransactionManager.State state = ContextTransactionManager.INSTANCE.getStateRef().get();
        Transaction transaction = this.owner.getProvider().getTransactionManager().getTransaction();
        if (transaction == null) {
            return false;
        }
        LocalTransaction localTransaction = this.owner.getOrAttach(transaction, CreationListener.CreatedBy.MERGE);
        if (state.transaction == null) {
            state.transaction = localTransaction;
            return true;
        }
        localTransaction.verifyAssociation();
        return false;
    }

    @Override
    void unimportBacking() {
        ContextTransactionManager.State state = ContextTransactionManager.INSTANCE.getStateRef().get();
        if (state.transaction.equals(this)) {
            state.transaction = null;
        }
    }

    LocalTransactionProvider getProvider() {
        return this.owner.getProvider();
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        super.setRollbackOnly();
        this.transaction.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        return this.transaction.getStatus();
    }

    @Override
    public int getTransactionTimeout() {
        return this.owner.getProvider().getTimeout(this.transaction);
    }

    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        Assert.checkNotNullParam((String)"xaRes", (Object)xaRes);
        int estimatedRemainingTime = this.getEstimatedRemainingTime();
        if (estimatedRemainingTime == 0) {
            throw Log.log.cannotEnlistToTimeOutTransaction(xaRes, this);
        }
        try {
            if (!xaRes.setTransactionTimeout(estimatedRemainingTime)) {
                Log.log.setTimeoutUnsuccessful(estimatedRemainingTime);
            }
        }
        catch (XAException e) {
            throw Log.log.setTimeoutFailed(estimatedRemainingTime, e);
        }
        return this.transaction.enlistResource(xaRes);
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        Assert.checkNotNullParam((String)"xaRes", (Object)xaRes);
        return this.transaction.delistResource(xaRes, flag);
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        Assert.checkNotNullParam((String)"sync", (Object)sync);
        this.transaction.registerSynchronization((Synchronization)new AbstractTransaction.AssociatingSynchronization(sync));
    }

    public String getParentName() {
        return this.owner.getProvider().getNameFromXid(this.owner.getProvider().getXid(this.transaction));
    }

    public Xid getXid() {
        return this.owner.getProvider().getXid(this.transaction);
    }

    @Override
    void registerInterposedSynchronization(Synchronization sync) throws IllegalStateException {
        Assert.checkNotNullParam((String)"sync", (Object)sync);
        this.owner.getProvider().registerInterposedSynchronization(this.transaction, new AbstractTransaction.AssociatingSynchronization(sync));
    }

    @Override
    public Object getResource(Object key) throws NullPointerException {
        return this.owner.getProvider().getResource(this.transaction, Assert.checkNotNullParamWithNullPointerException((String)"key", (Object)key));
    }

    @Override
    public void putResource(Object key, Object value) throws NullPointerException {
        this.owner.getProvider().putResource(this.transaction, Assert.checkNotNullParamWithNullPointerException((String)"key", (Object)key), value);
    }

    @Override
    public Object putResourceIfAbsent(Object key, Object value) throws IllegalArgumentException {
        return this.owner.getProvider().putResourceIfAbsent(this.transaction, Assert.checkNotNullParamWithNullPointerException((String)"key", (Object)key), value);
    }

    @Override
    Object getKey() {
        return this.owner.getProvider().getKey(this.transaction);
    }

    @Override
    boolean getRollbackOnly() {
        return this.owner.getProvider().getRollbackOnly(this.transaction);
    }

    @Override
    void suspend() throws SystemException {
        this.notifyAssociationListeners(false);
        TransactionManager transactionManager = this.owner.getProvider().getTransactionManager();
        if (!this.transaction.equals(transactionManager.getTransaction())) {
            throw Log.log.unexpectedProviderTransactionMismatch(this.transaction, transactionManager.getTransaction());
        }
        Transaction transactionManagerTransaction = transactionManager.suspend();
        if (!this.transaction.equals(transactionManagerTransaction)) {
            throw Log.log.unexpectedProviderTransactionMismatch(this.transaction, transactionManagerTransaction);
        }
    }

    @Override
    void resume() throws SystemException {
        TransactionManager transactionManager = this.owner.getProvider().getTransactionManager();
        try {
            transactionManager.resume(this.transaction);
        }
        catch (InvalidTransactionException e) {
            throw Log.log.invalidTxnState();
        }
        Transaction transactionManagerTransaction = transactionManager.getTransaction();
        if (!this.transaction.equals(transactionManagerTransaction)) {
            throw Log.log.unexpectedProviderTransactionMismatch(this.transaction, transactionManagerTransaction);
        }
        this.notifyAssociationListeners(true);
    }

    @Override
    void verifyAssociation() {
        TransactionManager transactionManager = this.owner.getProvider().getTransactionManager();
        try {
            Transaction transactionManagerTransaction = transactionManager.getTransaction();
            if (!this.transaction.equals(transactionManagerTransaction)) {
                throw Log.log.unexpectedProviderTransactionMismatch(this.transaction, transactionManagerTransaction);
            }
        }
        catch (SystemException e) {
            throw Log.log.invalidTxnState();
        }
    }

    public boolean isImported() {
        return this.owner.getProvider().isImported(this.transaction);
    }

    @Override
    public <T> T getProviderInterface(Class<T> providerInterfaceType) {
        return this.owner.getProvider().getProviderInterface(this.transaction, providerInterfaceType);
    }

    public int hashCode() {
        return this.transaction.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof LocalTransaction && this.equals((LocalTransaction)obj);
    }

    private boolean equals(LocalTransaction obj) {
        return this == obj || obj != null && this.transaction.equals(obj.transaction);
    }

    public String toString() {
        return String.format("Local transaction (delegate=%s, owner=%s)", this.transaction, this.owner);
    }
}

