/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client.naming.txn;

import java.util.Arrays;
import javax.naming.Binding;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.wildfly.naming.client.AbstractContext;
import org.wildfly.naming.client.CloseableNamingEnumeration;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.naming.client.ProviderEnvironment;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.ContextTransactionSynchronizationRegistry;
import org.wildfly.transaction.client.LocalUserTransaction;
import org.wildfly.transaction.client.RemoteTransactionContext;
import org.wildfly.transaction.client.RemoteUserTransaction;
import org.wildfly.transaction.client.naming.txn.ReadOnlyBinding;
import org.wildfly.transaction.client.naming.txn.ReadOnlyNameClassPair;
import org.wildfly.transaction.client.naming.txn.TxnNamingContextFactory;

class TxnNamingContext
extends AbstractContext {
    private static final String TRANSACTION_MANAGER = "TransactionManager";
    private static final String USER_TRANSACTION = "UserTransaction";
    private static final String REMOTE_USER_TRANSACTION = "RemoteUserTransaction";
    private static final String LOCAL_USER_TRANSACTION = "LocalUserTransaction";
    private static final String TRANSACTION_SYNCHRONIZATION_REGISTRY = "TransactionSynchronizationRegistry";
    private final NamingProvider namingProvider;
    private final ProviderEnvironment providerEnvironment;
    private final RemoteUserTransaction remoteUserTransaction;
    private final TxnNamingContextFactory.AccessChecker accessChecker;

    TxnNamingContext(NamingProvider namingProvider, ProviderEnvironment providerEnvironment, TxnNamingContextFactory.AccessChecker accessChecker) {
        this.namingProvider = namingProvider;
        this.providerEnvironment = providerEnvironment;
        this.accessChecker = accessChecker;
        this.remoteUserTransaction = this.getRemoteUserTransaction();
    }

    protected Object lookupNative(Name name) throws NamingException {
        String str;
        if (this.accessChecker != null) {
            this.accessChecker.checkAccessAllowed();
        }
        switch (str = name.get(0)) {
            case "UserTransaction": {
                return this.remoteUserTransaction;
            }
            case "RemoteUserTransaction": {
                return this.remoteUserTransaction;
            }
            case "LocalUserTransaction": {
                return LocalUserTransaction.getInstance();
            }
            case "TransactionManager": {
                if (this.namingProvider != null) break;
                return ContextTransactionManager.getInstance();
            }
            case "TransactionSynchronizationRegistry": {
                if (this.namingProvider != null) break;
                return ContextTransactionSynchronizationRegistry.getInstance();
            }
        }
        throw TxnNamingContext.nameNotFound((Name)name);
    }

    protected Object lookupLinkNative(Name name) throws NamingException {
        return this.lookupNative(name);
    }

    protected CloseableNamingEnumeration<NameClassPair> listNative(Name name) throws NamingException {
        if (!name.isEmpty()) {
            throw TxnNamingContext.nameNotFound((Name)name);
        }
        return CloseableNamingEnumeration.fromIterable(Arrays.asList(this.nameClassPair(UserTransaction.class), this.nameClassPair(RemoteUserTransaction.class), this.nameClassPair(LocalUserTransaction.class), this.nameClassPair(TransactionManager.class), this.nameClassPair(TransactionSynchronizationRegistry.class)));
    }

    protected CloseableNamingEnumeration<Binding> listBindingsNative(Name name) throws NamingException {
        if (!name.isEmpty()) {
            throw TxnNamingContext.nameNotFound((Name)name);
        }
        return CloseableNamingEnumeration.fromIterable(Arrays.asList(this.binding(UserTransaction.class, this.remoteUserTransaction), this.binding(RemoteUserTransaction.class, this.remoteUserTransaction), this.binding(LocalUserTransaction.class, LocalUserTransaction.getInstance()), this.binding(TransactionManager.class, ContextTransactionManager.getInstance()), this.binding(TransactionSynchronizationRegistry.class, ContextTransactionSynchronizationRegistry.getInstance())));
    }

    private NameClassPair nameClassPair(Class<?> clazz) {
        return new ReadOnlyNameClassPair(clazz.getSimpleName(), clazz.getName(), "txn:" + clazz.getSimpleName());
    }

    private <T> Binding binding(Class<T> clazz, T content) {
        return new ReadOnlyBinding(clazz.getSimpleName(), clazz.getName(), content, "txn:" + clazz.getSimpleName());
    }

    private RemoteUserTransaction getRemoteUserTransaction() {
        AuthenticationContext context = (AuthenticationContext)this.providerEnvironment.getAuthenticationContextSupplier().get();
        return (RemoteUserTransaction)context.runFunction(RemoteTransactionContext::getUserTransaction, (Object)RemoteTransactionContext.getInstance());
    }

    public void close() throws NamingException {
    }

    public String getNameInNamespace() throws NamingException {
        return "";
    }
}

