/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.url.http;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.function.Supplier;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.jboss.logging.Logger;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.TwoWayPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;

class ElytronCredentialsProvider
implements CredentialsProvider {
    static final ElytronCredentialsProvider INSTANCE = new ElytronCredentialsProvider();
    static final AuthenticationContextConfigurationClient client = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    private static final Logger log = Logger.getLogger((String)"org.wildfly.url.http");

    ElytronCredentialsProvider() {
    }

    public Credentials getCredentials(AuthScope authscope) {
        char[] password;
        NameCallback nameCallback;
        URI uri;
        block13: {
            AuthenticationContext context = AuthenticationContext.captureCurrent();
            HttpHost origin = authscope.getOrigin();
            String protocol = origin != null ? origin.getSchemeName() : (authscope.getPort() == 443 ? "https" : "http");
            try {
                uri = new URI(protocol, null, authscope.getHost(), authscope.getPort(), null, null, null);
            }
            catch (URISyntaxException e) {
                log.tracef("URISyntaxException getting URI from the requesting AuthScope [%s]:", (Object)authscope.toString(), (Object)e);
                return null;
            }
            log.trace((Object)("Obtaining AuthenticationConfiguration for URI " + uri));
            AuthenticationConfiguration authenticationConfiguration = client.getAuthenticationConfiguration(uri, context);
            if (authenticationConfiguration == null) {
                log.trace((Object)("No AuthenticationConfiguration for URI " + uri));
                return null;
            }
            CallbackHandler callbackHandler = client.getCallbackHandler(authenticationConfiguration);
            nameCallback = new NameCallback("Username");
            CredentialCallback credentialCallback = new CredentialCallback(PasswordCredential.class);
            password = null;
            try {
                callbackHandler.handle(new Callback[]{nameCallback, credentialCallback});
                TwoWayPassword twoWayPassword = (TwoWayPassword)credentialCallback.applyToCredential(PasswordCredential.class, c -> (TwoWayPassword)c.getPassword().castAs(TwoWayPassword.class));
                if (twoWayPassword == null) {
                    return null;
                }
                PasswordFactory factory = PasswordFactory.getInstance((String)twoWayPassword.getAlgorithm(), (Supplier)client.getProviderSupplier(authenticationConfiguration));
                password = ((ClearPasswordSpec)factory.getKeySpec(factory.translate((Password)twoWayPassword), ClearPasswordSpec.class)).getEncodedPassword();
            }
            catch (UnsupportedCallbackException e) {
                if (e.getCallback() != credentialCallback) break block13;
                PasswordCallback passwordCallback = new PasswordCallback("Password", false);
                try {
                    callbackHandler.handle(new Callback[]{nameCallback, passwordCallback});
                    password = passwordCallback.getPassword();
                }
                catch (IOException | UnsupportedCallbackException e1) {
                    log.trace((Object)"Error handling callback:", (Throwable)e1);
                    return null;
                }
            }
            catch (IOException e) {
                log.trace((Object)"IOException handling callback:", (Throwable)e);
                return null;
            }
            catch (NoSuchAlgorithmException e) {
                log.trace((Object)"NoSuchAlgorithmException getting PasswordFactory:", (Throwable)e);
                return null;
            }
            catch (InvalidKeySpecException e) {
                log.trace((Object)"InvalidKeySpecException getting ClearPasswordSpec:", (Throwable)e);
                return null;
            }
            catch (InvalidKeyException e) {
                log.trace((Object)"InvalidKeyException getting ClearPasswordSpec:", (Throwable)e);
                return null;
            }
        }
        String name = nameCallback.getName();
        log.tracef("Authenticating against %s: username = %s  password = %b", (Object)uri, (Object)name, (Object)(password != null ? 1 : 0));
        if (name == null || password == null) {
            return null;
        }
        return new UsernamePasswordCredentials(name, new String(password));
    }

    public void setCredentials(AuthScope authscope, Credentials credentials) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }
}

