/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.url.http;

import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import org.wildfly.url.http.HttpClientURLConnection;

public class WildflyURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static final URLStreamHandler httpHandler = new Handler(80);
    private static final URLStreamHandler httpsHandler = new Handler(443);

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (protocol.equalsIgnoreCase("http")) {
            return httpHandler;
        }
        if (protocol.equalsIgnoreCase("https")) {
            return httpsHandler;
        }
        return null;
    }

    private static class Handler
    extends URLStreamHandler {
        private final int defaultPort;

        Handler(int defaultPort) {
            this.defaultPort = defaultPort;
        }

        @Override
        protected int getDefaultPort() {
            return this.defaultPort;
        }

        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            return new HttpClientURLConnection(url, null);
        }

        @Override
        protected URLConnection openConnection(URL url, Proxy proxy) throws IOException {
            return new HttpClientURLConnection(url, proxy);
        }
    }
}

