/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.chat;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.ollama.OllamaChatModel;
import java.time.Duration;
import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.ai.AIAttributeDefinitions;
import org.wildfly.extension.ai.chat.AbstractChatModelProviderServiceConfigurator;
import org.wildfly.service.capture.ValueRegistry;
import org.wildfly.subsystem.service.ResourceServiceInstaller;

public class OllamaChatModelProviderServiceConfigurator
extends AbstractChatModelProviderServiceConfigurator {
    public OllamaChatModelProviderServiceConfigurator(ValueRegistry<String, ChatLanguageModel> registry) {
        super(registry);
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final Double temperature = AIAttributeDefinitions.TEMPERATURE.resolveModelAttribute(context, model).asDoubleOrNull();
        final Long connectTimeOut = AIAttributeDefinitions.CONNECT_TIMEOUT.resolveModelAttribute(context, model).asLong();
        final Boolean logRequests = AIAttributeDefinitions.LOG_REQUESTS.resolveModelAttribute(context, model).asBooleanOrNull();
        final Boolean logResponses = AIAttributeDefinitions.LOG_RESPONSES.resolveModelAttribute(context, model).asBooleanOrNull();
        final String baseUrl = AIAttributeDefinitions.BASE_URL.resolveModelAttribute(context, model).asString();
        final Integer maxRetries = AIAttributeDefinitions.MAX_RETRIES.resolveModelAttribute(context, model).asIntOrNull();
        final String modelName = AIAttributeDefinitions.MODEL_NAME.resolveModelAttribute(context, model).asString();
        final boolean isJson = AIAttributeDefinitions.ResponseFormat.isJson(AIAttributeDefinitions.RESPONSE_FORMAT.resolveModelAttribute(context, model).asStringOrNull());
        Supplier<ChatLanguageModel> factory = new Supplier<ChatLanguageModel>(){

            @Override
            public ChatLanguageModel get() {
                OllamaChatModel.OllamaChatModelBuilder builder = OllamaChatModel.builder().baseUrl(baseUrl).logRequests(logRequests).logResponses(logResponses).maxRetries(maxRetries).temperature(temperature).timeout(Duration.ofMillis(connectTimeOut)).modelName(modelName);
                if (isJson) {
                    builder.format("json");
                }
                return builder.build();
            }
        };
        return this.installService(context.getCurrentAddressValue(), factory);
    }
}

