/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.chat;

import dev.langchain4j.model.chat.ChatLanguageModel;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.RuntimePackageDependency;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.ai.AIAttributeDefinitions;
import org.wildfly.extension.ai.Capabilities;
import org.wildfly.extension.ai.chat.ChatModelConnectionCheckerOperationHandler;
import org.wildfly.extension.ai.chat.OpenAIChatModelProviderServiceConfigurator;
import org.wildfly.service.capture.ValueExecutorRegistry;
import org.wildfly.service.capture.ValueRegistry;
import org.wildfly.subsystem.resource.ChildResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;

public class OpenAIChatLanguageModelProviderRegistrar
implements ChildResourceDefinitionRegistrar {
    public static final SimpleAttributeDefinition FREQUENCY_PENALTY = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("frequency-penalty", ModelType.DOUBLE, true).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition ORGANIZATION_ID = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("organization-id", ModelType.STRING, true).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition PRESENCE_PENALTY = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("presence-penalty", ModelType.DOUBLE, true).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition SEED = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("seed", ModelType.INT, true).setAllowExpression(true)).build();
    public static final Collection<AttributeDefinition> ATTRIBUTES = List.of(AIAttributeDefinitions.API_KEY, AIAttributeDefinitions.BASE_URL, AIAttributeDefinitions.CONNECT_TIMEOUT, FREQUENCY_PENALTY, AIAttributeDefinitions.LOG_REQUESTS, AIAttributeDefinitions.LOG_RESPONSES, AIAttributeDefinitions.MAX_TOKEN, AIAttributeDefinitions.MODEL_NAME, ORGANIZATION_ID, PRESENCE_PENALTY, AIAttributeDefinitions.RESPONSE_FORMAT, SEED, AIAttributeDefinitions.TEMPERATURE, AIAttributeDefinitions.TOP_P);
    private final ResourceRegistration registration;
    private final ResourceDescriptor descriptor;
    static final String NAME = "openai-chat-model";
    public static final PathElement PATH = PathElement.pathElement((String)"openai-chat-model");
    private final ValueExecutorRegistry<String, ChatLanguageModel> registry = ValueExecutorRegistry.newInstance();

    public OpenAIChatLanguageModelProviderRegistrar(ParentResourceDescriptionResolver parentResolver) {
        this.registration = ResourceRegistration.of((PathElement)PATH);
        this.descriptor = ((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)parentResolver.createChildResolver(PATH)).addCapability(Capabilities.CHAT_MODEL_PROVIDER_CAPABILITY)).addAttributes(ATTRIBUTES)).withRuntimeHandler(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)new OpenAIChatModelProviderServiceConfigurator((ValueRegistry<String, ChatLanguageModel>)this.registry)))).build();
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        ResourceDefinition definition = ResourceDefinition.builder((ResourceRegistration)this.registration, (ResourceDescriptionResolver)this.descriptor.getResourceDescriptionResolver()).build();
        ManagementResourceRegistration resourceRegistration = parent.registerSubModel(definition);
        ChatModelConnectionCheckerOperationHandler.register(resourceRegistration, this.descriptor, this.registry);
        resourceRegistration.registerAdditionalRuntimePackages(new RuntimePackageDependency[]{RuntimePackageDependency.required((String)"dev.langchain4j.openai")});
        ManagementResourceRegistrar.of((ResourceDescriptor)this.descriptor).register(resourceRegistration);
        return resourceRegistration;
    }
}

