/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.chat;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import java.time.Duration;
import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.ai.AIAttributeDefinitions;
import org.wildfly.extension.ai.chat.AbstractChatModelProviderServiceConfigurator;
import org.wildfly.extension.ai.chat.OpenAIChatLanguageModelProviderRegistrar;
import org.wildfly.service.capture.ValueRegistry;
import org.wildfly.subsystem.service.ResourceServiceInstaller;

public class OpenAIChatModelProviderServiceConfigurator
extends AbstractChatModelProviderServiceConfigurator {
    public OpenAIChatModelProviderServiceConfigurator(ValueRegistry<String, ChatLanguageModel> registry) {
        super(registry);
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final String baseUrl = AIAttributeDefinitions.BASE_URL.resolveModelAttribute(context, model).asString();
        final Long connectTimeOut = AIAttributeDefinitions.CONNECT_TIMEOUT.resolveModelAttribute(context, model).asLong();
        final Double frequencyPenalty = OpenAIChatLanguageModelProviderRegistrar.FREQUENCY_PENALTY.resolveModelAttribute(context, model).asDoubleOrNull();
        final String key = AIAttributeDefinitions.API_KEY.resolveModelAttribute(context, model).asString();
        final String organizationId = OpenAIChatLanguageModelProviderRegistrar.ORGANIZATION_ID.resolveModelAttribute(context, model).asString();
        final String modelName = AIAttributeDefinitions.MODEL_NAME.resolveModelAttribute(context, model).asString();
        final Integer maxToken = AIAttributeDefinitions.MAX_TOKEN.resolveModelAttribute(context, model).asIntOrNull();
        final Double presencePenalty = OpenAIChatLanguageModelProviderRegistrar.PRESENCE_PENALTY.resolveModelAttribute(context, model).asDoubleOrNull();
        final Boolean logRequests = AIAttributeDefinitions.LOG_REQUESTS.resolveModelAttribute(context, model).asBooleanOrNull();
        final Boolean logResponses = AIAttributeDefinitions.LOG_RESPONSES.resolveModelAttribute(context, model).asBooleanOrNull();
        final Integer seed = OpenAIChatLanguageModelProviderRegistrar.SEED.resolveModelAttribute(context, model).asIntOrNull();
        final Double temperature = AIAttributeDefinitions.TEMPERATURE.resolveModelAttribute(context, model).asDoubleOrNull();
        final Double topP = AIAttributeDefinitions.TOP_P.resolveModelAttribute(context, model).asDoubleOrNull();
        final boolean isJson = AIAttributeDefinitions.ResponseFormat.isJson(AIAttributeDefinitions.RESPONSE_FORMAT.resolveModelAttribute(context, model).asStringOrNull());
        Supplier<ChatLanguageModel> factory = new Supplier<ChatLanguageModel>(){

            @Override
            public ChatLanguageModel get() {
                OpenAiChatModel.OpenAiChatModelBuilder builder = OpenAiChatModel.builder().apiKey(key).baseUrl(baseUrl).frequencyPenalty(frequencyPenalty).logRequests(logRequests).logResponses(logResponses).maxRetries(Integer.valueOf(5)).maxTokens(maxToken).modelName(modelName).organizationId(organizationId).presencePenalty(presencePenalty).seed(seed).temperature(temperature).timeout(Duration.ofMillis(connectTimeOut)).topP(topP);
                if (isJson) {
                    builder.responseFormat("json_object");
                }
                return builder.build();
            }
        };
        return this.installService(context.getCurrentAddressValue(), factory);
    }
}

